


XTACACSD(8)                                           XTACACSD(8)


NNAAMMEE
       xtacacsd - Extended TAC Access Control server

SSYYNNOOPPSSIISS
       xxttaaccaaccssdd  [  --ddllnnqqss  ]  [  --uu _u_t_m_p_f_i_l_e ] [ --ww _w_t_m_p_f_i_l_e ] [
       _f_i_l_e_n_a_m_e._..  ]
               --dd  _(_d_e_b_u_g_)
               --ll  _(_l_o_g _a_c_t_i_o_n_s _v_i_a _s_y_s_l_o_g_)
               --nn  _(_d_i_s_a_b_l_e _u_s_e _o_f _n_a_m_e_s_e_r_v_e_r_)
               --qq  _(_q_u_i_e_t _m_o_d_e_-  _d_e_n_y _t_y_p_e _r_e_s_p_o_n_s_e_s _n_o_t _s_e_n_t _o_u_t_)
               --ss  _(_s_t_a_n_d_a_l_o_n_e _m_o_d_e_- _d_e_f_a_u_l_t _v_i_a  iinneettdd_)

DDEESSCCRRIIPPTTIIOONN
       xxttaaccaaccssdd is an _e_x_t_e_n_d_e_d TACACS server which  authenticates
       users  logging  onto  a terminal server (or any host which
       cares to query the server). This version of  xxttaaccaaccssdd  has
       the following features:

       -      Can run under _i_n_e_t_d or in standalone mode as a dae-
              mon.

       -      can process either the old tacacs  queries  or  the
              new extended tacacs format queries.

       -      can process multiple password files (upto 5 files).

       -      optionally  disable  the  use  of  nameservers  for
              faster  response  times  or  avoid depending on the
              nameservers.

       -      optionally not send DENY type responses so that the
              client can query multiple tacacs servers.

       -      log queries from terminal servers in different _w_t_m_p
              files (depending on where the query came from).

       -      converts all query names to lowercase  (useful  for
              SLIP queries and looking up in the nameserver).

       -      group  id  of user is processed for controlling the
              number of logins and denying access.

       -      group id of user is used to get the access list for
              the user on the terminal server. The group id wraps
              after MAXACCESSLIST (99)- thus a group id  of  1075
              will yield an access list number of 75.

       -      the  access  list for the user when SLIP is invoked
              (slip_on) is one higher than the access list number
              at  login. Thus, if the group id is 1075, the login
              access list number is 75, and the slip access  list
              number  will be 76. This allows more control of the
              user depending on whether he/she is in _s_l_i_p mode or
              in  _l_o_g_i_n  mode  (this  might  be  a highly JvNCnet



                          April 29, 1992                        1





XTACACSD(8)                                           XTACACSD(8)


              specific feature).

       -      configurable password for SLIP requests for  tacacs
              ddeeffaauulltt  queries  (used  for  statically configured
              lines).

       This program can be used to authenticate users  when  they
       try  to  access a terminal server ( _c_i_s_c_o terminal servers
       support this option). The server can log information about
       all  queries  coming  to  the  server using ssyysslloogg..  It is
       meant to be invoked by iinneettdd but can be run from a  termi-
       nal in standalone mode if desired. In this mode, it writes
       all errors to the controlling terminal.

       The server expects a _u_s_e_r_n_a_m_e and _p_a_s_s_w_o_r_d to be  supplied
       in  the  query  packet recieved from the terminal servers.
       This username and password are authenticated by  searching
       in  the password file(s).  (The default is _/_e_t_c_/_p_a_s_s_w_d but
       upto five alternate filenames can be specified on the com-
       mand line).  If it cannot find a match in any of the pass-
       word files, it sends an _a_u_t_h_e_n_t_i_c_a_t_i_o_n  _f_a_i_l_u_r_e  reply  to
       the  query  (unless the _q_u_i_e_t option is specified in which
       case no negative response will be sent).

       The server always returns an  authentication  failure  for
       any  queries  that have a uid of 0 ( _r_o_o_t _u_i_d ) or for any
       users that do not have a password in the  password  files.
       It  also  verifies  that  the  account  is current and not
       expired if the last password field  (  _p_w___s_h_e_l_l_)  supports
       this  feature. Lastly, the group id of the user is checked
       for the number of allowable logins (by masking all  except
       the  last  digit  in the group id) and if access should be
       denied (see compile time options below). This can be  used
       to  control the number of logins and also deny access to a
       certain group of users.

       SLIP queries are all made in uppercase.  Since  most  Unix
       accounts  are  lowercase,  this program converts all query
       usernames to lowercase (if TOLOWER is defined during  com-
       pile  time). Note that this causes authentication problems
       for mixed case usernames like _U_j_v_n_c_n_e_t.

OOPPTTIIOONNSS
       --dd     _(_d_e_b_u_g_) Logs additional debugging  information  (to
              _s_y_s_l_o_g  or  on  the  terminal  in standalone mode).
              Extensive debugging information is obtained by com-
              piling the program with the DDEEBBUUGG option.

       --ss     _(_s_t_a_n_d_a_l_o_n_e_)  When  the  server is run in the stan-
              dalone mode, it sits in an endless loop waiting for
              data  to  arrive  on  the TACACS port. If the debug
              ((--dd)) option is not specified, the program forks and
              detaches  itself from the controlling terminal. All
              errors are logged to _s_t_d_e_r_r.



                          April 29, 1992                        2





XTACACSD(8)                                           XTACACSD(8)


       --ll     _(_l_o_g_g_i_n_g_) With this option,  the  server  logs  all
              queries  that  it  serves  via  ssyysslloogg  at the INFO
              level. Without this option, only errors are logged.
              The  logging  is done at either the DAEMON facility
              or the LOCAL6 facility (see  compile  time  options
              below).

       --nn     _(_n_o _n_a_m_e_s_e_r_v_e_r_) This option disables the use of the
              nameserver  to  resolve  internet  addresses   into
              names.  This  speeds up responses in case the name-
              server is heavily loaded or is down.

       --qq     _(_q_u_i_e_t_) So that the server does not  send  _n_e_g_a_t_i_v_e
              responses  to  a  query.  Thus a client can ask the
              next tacacs server in its list in case of  a  time-
              out.  Note  that if a user has accounts on two sys-
              tems with tacacs servers,  and  if  the  number  of
              logins  in  being controlled via the group-id, then
              the second server might  respond  even  though  the
              maximum number of allowable logins has been reached
              on the first tacacs server.

       --uu _<_u_t_m_p_f_i_l_e_>
              specifies an alternate _u_t_m_p file to be searched for
              the  number  of allowed logins. The default file is
              //eettcc//uuttmmpp.  Note that the xxttaaccaaccssdd server does  not
              delete  entries  in  the utmp file when a user logs
              out, so this file is different from the  _w_t_m_p  file
              (which  is  a  sequential  log  of  all  logins and
              logouts on the system).

       --ww _<_w_t_m_p_f_i_l_e_>
              Extended tacacs logs the times that a user connects
              to  the  terminal server, logs out or enables _s_l_i_p.
              All queries are  logged  to  different  _w_t_m_p  files
              whose name is constructed by appending the hostname
              in front of the master _w_t_m_p file name. All  queries
              from  all  terminal  servers are also logged in the
              master _w_t_m_p file. All _s_l_i_p queries  are  logged  in
              the file _<_w_t_m_p_>..sslliipp This is done to aid accounting
              programs like aacc(8).

       ffiilleess  _<_a_l_t_e_r_n_a_t_e _p_a_s_s_w_o_r_d  _f_i_l_e_s_>  By  default  the  file
              //eettcc//ppaasssswwdd  is used for verifying the username and
              the password in a tacacs query.   However,  upto  5
              alternate  password  files  can be specified on the
              command line and the server will search in all  the
              files  until  it  finds  a  match or else return an
              error. The alternate password files must be in  the
              //eettcc//ppaasssswwdd format so that the _g_e_t_p_w_e_n_t(3) routines
              can be used on them.

CCOOMMPPIILLEE TTIIMMEE OOPPTTIIOONNSS
       The complete list of compile time options are described in



                          April 29, 1992                        3





XTACACSD(8)                                           XTACACSD(8)


       the  Makefile  and the source code. The most relevant ones
       (to use) are described here.

       -      If  the  U_NUMLOGINS_GID  and  U_NUMLOGINS_GID  are
              defined while compiling, the user's group-id in the
              passwd file is used a a measure of  allowed  logins
              The last digit of the gid is masked and used as the
              number  of  allowed  logins.   The  UUTTMMPP   (default
              _/_e_t_c_/_u_t_m_p)  file is searched for the number of cur-
              rent  logins.  If  the  number  of  current  logins
              exceeds the number of allowable logins then a nega-
              tive response is set (unless the _q_u_i_e_t option is in
              effect).  Undefine  either  one of these to disable
              this feature.

       -      Users with their group id  between  U_DENY_GID  and
              L_DENY_GID  are  denied access. Undefine or comment
              out either one to disable this feature.

       -      All SLIP queries are in uppercase (for cciissccoo termi-
              nal  servers).  If  the  program  is  compiled with
              TOLOWER defined, then all usernames  are  converted
              to lowercase.

       -      The  extended tacacs queries are logged in the _w_t_m_p
              format by the server. To help in  accounting,  each
              terminal server has its own _w_t_m_p file. The name and
              location of these files are  formed  by  prepending
              the  value  of  WWTTMMPP  to  the  name of the terminal
              server. The default value  is  //eettcc//wwttmmpp,  implying
              that  queries  from wwoorrmmhhoollee..ffoooo..eedduu will be logged
              in the file //eettcc//wwttmmpp..wwoorrmmhhoollee.   Set  this  during
              compile  time  to  change  the location of the wtmp
              files. It is advised to create a separate directory
              if there are a large number of terminal servers.

       -      For queries with the username of ddeeffaauulltt (for stat-
              ically assigned  IP  addresses),  the  password  is
              defined as DEFAULTS_IP_PASSWORD. Note that the pro-
              gram should be installed with read access denied to
              the world so that this password cannot be extracted
              from the binary.

UUSSEEFFUULL TTIIDDBBIITTSS
       -      The //eettcc//uuttmmpp file on Unix systems keeps  track  of
              the  users  _c_u_r_r_e_n_t_l_y  logged  on  the  system,  as
              opposed to the //eettcc//wwttmmpp file which lists  all  the
              logins and logouts in the life of the current file.

       -      llaasstt(1) wwhhoo(1) ppaasssswwdd(1) all support alternate file
              names  on  the  command  line.  These standard Unix
              utilities allow  looking  and  modifying  alternate
              _w_t_m_p or _p_a_s_s_w_d files.




                          April 29, 1992                        4





XTACACSD(8)                                           XTACACSD(8)


       -      Sun  workstations  (perhaps  others  too)  have  an
              accounting tool under //vvaarr//aaddmm//aacccctt//nniittee//ffwwttmmpp that
              can  help  modify  and repair corrupted _w_t_m_p format
              files.

       -      Multiple user entries can show up in the _w_t_m_p files
              if  the terminal servers do not recieve an acknowl-
              edgement in time from the tacacs  server  and  send
              out multiple requests or log messages to the tacacs
              server.  llaasstt(1) takes care of such multiple  bogus
              entries in its output.

       -      The  alternate  password  files  can be set to _r_o_o_t
              readable only if so desired since the server is run
              as _r_o_o_t from iinneettdd.

FFIILLEESS
       //eettcc//xxttaaccaaccssdd       the main server

       //eettcc//ppaasssswwdd         default password file used for authen-
                           tication

       //eettcc//uuttmmpp           default file used to check  number  of
                           allowed logins

       //eettcc//wwttmmpp           default  file  prefix used for logging
                           all logins and logouts. The  extension
                           _._s_l_i_p  is  used  for  logging the SLIP
                           events.

SSEEEE AALLSSOO
       llaasstt(1)  iinneettdd(8)  iinneettdd..ccoonnff(5),  sseerrvviicceess(5),  ssyysslloogg(8)
       ssyysslloogg..ccoonnff(5)

       _T_A_C_A_C_S  _U_s_e_r  _I_d_e_n_t_i_f_i_c_a_t_i_o_n _T_e_l_n_e_t _O_p_t_i_o_n Brian A. Ander-
       son, _R_F_C _9_2_7

AAUUTTHHOORR
       Greg Satz (satz@cisco.com), Cisco Systems.  Original  ver-
       sion

       Pushpendra  Mohta (pushp@cerf.net), CERFnet. Added _n_o_n_a_m_e_-
       _s_e_r_v_e_r and multiple wtmp file capability.

       Vikas Aggarwal (vikas@jvnc.net), JvNCnet.  Added  multiple
       password  files, _l_o_w_e_r_c_a_s_e, _q_u_i_e_t, group id features, man-
       ual page and cleaned up code for easy customization.

DDIIAAGGNNOOSSTTIICCSS
       Exit status is normally 0.







                          April 29, 1992                        5


