/********************/
/* SPECIAL: Mini-scripts that execute within this function.*/
/********************/

/*	Albert Crosby's "special" function - handles execution of some 	*/
/*	local commands & passing results back to client.		*/

  parse arg sel '?' options, tempfile, who
  /* Allow support for user-created scripts that return other information 	*/
  /* from the server. 							*/
  /*									*/
  /*  Make sure to return the command to the filter - returning an empty	*/
  /*   string will result in a "not found" message returned to the client... 	*/
  select
    when sel='time'          then return 'STRING The server''s time is 'time()' on 'date()
    when sel='dir'           then return 'STRING The working directory is 'directory()
    when sel='who'           then do
      if options\="" then header="Information about "options
      else header="Users logged on to the Domain"
      return execute('net who 'options,"Information about Network Users",header)
      end
    when sel='printers'      then return execute('net print \\sig','Jobs Printing at the Microcomputer Lab')
    when sel='ping'          then do
      parse var options host '&count=' count
      if host="" | host="*" then host=who
      if count="" then count=1
      return execute('ping 'host 56 count,'Ping 'host)
      end
    otherwise return ''
  end                                                                   
/* End of the Special commands */                                     
 return    /* Should never get here... */


/* ----------------------------------------------------------------------- */
/* EXECUTE: Executes an OS/2 command and sends the result to the remote    */
/*          client.  Care should be taken to prevent creating a security   */
/*          hole.                                                          */
/* ----------------------------------------------------------------------- */
execute: procedure expose tempfile
  parse arg command, title, header
  if title="" then title="Results of "command
  if header="" then header=title
  call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 2.0//EN">'
  call lineout tempfile, "<html><head><title>" title "</title></head>"
  call lineout tempfile, "<body><h2>"header"</h2>"
  call lineout tempfile, "<hr><pre>"
  call lineout tempfile  /* close */
  address cmd command ">>"tempfile
  call lineout tempfile, "</body></html>"
  call lineout tempfile  /* close */
  return 'FILE ERASE TYPE text/html NAME' tempfile

extension: procedure
arg filename
/* If no period or only period is first char, then return "" */
if lastpos(".",filename)<2 then return ""
return translate(substr(filename, lastpos('.',filename)+1))
