/*   Directory to HTML Convertor
     Copyright (C) 1996   Helge Walter
     
     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2
     of the License, or any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact me at hwa@master.hrz.th-zwickau.de or
                   Helge.Walter@banyan.th-zwickau.de
      or via snail-mail at
                   Helge Walter
                   Friedrichstr. 15
                   08124 Cainsdorf
                   Germany
*/

Parse Arg CmdLine
Call InitKonst
If Words(CmdLine)<1 then Do
   Call Intro
   Call Usage
end  /* Do */
Else Do
   Call ParseOptions
   Call Intro
   Call WriteHeader
   Call ProcessFiles
   Call WriteFooter
End /* Do */
Exit

InitKonst:
   Version="v1.5"
   OutFile=1
   Subjects=2
   Description=3
   Server=4
   LowerCase=5
   Files=6
   Debug=7
   DirDescription=8
   IndexFile=9
   ResponseFile=10
   Title=11
   Heading=12
   PreFace=13
   PostScriptum=14
   IndexHint=15
   HTMLBody=16
   CGIMode=17
   Options.CGIMode=0
   EinTab="ABCDEFGHIJKLMNOPQRSTUVWXYZ"
   AusTab="abcdefghijklmnopqrstuvwxyz"
   ResponseLevel=0
   Return

Intro: Procedure Expose Version CGIMode Options.CGIMode
   If \(Options.CGIMode) then Do
      Say "Directory To HTML Convertor "Version", Copyright (C) 1996 Helge Walter"
      Say
   end  /* Do */
   Return

SysFailure: Procedure
   Parse Arg ErrDescr,RetCode
   Say "Error "ErrDescr". System returns "RetCode
   If Pos(":", RetCode) Then Parse Value RetCode With Verbal":"RC
   Else RC=RetCode
   Say SysGetMessage(RC)
   Return

StringTranslate:
   Parse Arg Kette
   EndKette=""
   Do While Pos("%", Kette)<>0
      Posi=Pos("%", Kette)
      EndKette=EndKette""Left(Kette, Posi-1)
      Command=SubStr(Kette, Posi+1, 1)
      Kette=SubStr(Kette, Posi+2)
      Select
         when Command="%" then Addi="%"
         when Command="d" then Addi=Date("Normal")
         when Command="t" then Addi=Time("Normal")
         when Command="i" then Addi='<A HREF="'Options.Server''Options.IndexFile'">'Options.IndexFile'</A>'
         when Command="v" then Addi="<EM>DIR2HTML "Version"</EM>"
         when Command="f" then Addi=Options.Files
      otherwise
         Addi=""
      end  /* select */
      EndKette=EndKette""Addi
   end /* do */
   EndKette=EndKette""Kette
   Return EndKette

AddToZip:
   Parse Arg Dateiens
   If Options.Debug Then Say "Adding files "Dateiens" to file "Options.IndexFile
   "@Zip -k9q "Options.IndexFile" "Dateiens
   Return

LoadResponse:
   Parse Arg RPF
   If Options.Debug then Say "Processing responsefile "RPF"..."
   RC=Stream(RPF, "Command", "Open Read")
   If RC<>"READY:" then Do
      If Options.Debug then Call SysFailure "opening file "RPF, RC
      Else Say "Error opening responsefile ... skipping"
   end /* Do */
   Else Do
      Do While Lines(RPF)
         Zeile = Strip(LineIn(RPF))
         Parse Value Zeile With FOption Rest
         Select
            when FOption="-o" then Parse Value Rest With Options.OutFile Rest
            when FOption="-s" then Options.Subjects=1
            when FOption="-d" then Options.Description=1
            when FOption="-p" then Parse Value Rest With Options.Server Rest
            when FOption="-l" then Options.LowerCase=1
            when FOption="-debug" then Options.Debug=1
            when FOption="-f" then Options.DirDescription=1
            when FOption="-i" then Do
               Parse Value Rest With Options.IndexFile Rest
               If Pos(".", FileSpec("Name", Options.IndexFile))=0 then Do
                  Options.IndexFile = Options.IndexFile".zip"
               end  /* Do */
            end /* Do */
            when FOption="-r" then Do
               ResponseLevel=ResponseLevel+1
               ResponseName.ResponseLevel=RPF
               Call LoadResponse Rest
               RPF=ResponseName.ResponseLevel
               ResponseLevel=ResponseLevel-1
            end  /* Do */
            when FOption="-title" then Options.Title=Rest
            when FOption="-heading" then Options.Heading=Rest
            when FOption="-files" then Options.Files=Rest
            when FOption="-index" then Options.IndexHint=Rest
            when FOption="-body" then Options.HTMLBody=Rest
            when FOption="-begin" then Do
               Rest=Strip(Rest)
               If Rest="preface" then Options.PreFace=""
               else If Rest="postscriptum" then Options.PostScriptum=""
               else Say "Unknown environment "Rest" ignored"
               Zeile=Strip(LineIn(RPF))
               Do While (Zeile<>"-end")&(Lines(RPF))
                  If Rest="preface" then Options.PreFace=Options.PreFace" "Zeile
                  else If Rest="postscriptum" then Options.PostScriptum=Options.PostScriptum" "Zeile
                  Zeile=Strip(LineIn(RPF))
               end /* do */
            end  /* Do */
            when Left(FOption,1)=";" then Nop
         otherwise
            Say "Unknown option "FOption" ignored"
         end  /* select */
      end /* do */
      Call Stream RPF, "Command", "Close"
   end  /* Do */
   Return

Usage: Procedure
   Say "Usage: DIR2HTML [<Options>] <Filemask>"
   Say
   Say "----> Options ----------------------------------------------------------------"
   Say " -s             use filedescription stored in .SUBJECT EA"
   Say " -d             use filedescription stored in DESCRIPT.ION file"
   Say " -f             use FILE_ID.DIZ to describe directory"
   Say " -o <filename>  produce the file <filename> instead of the default index.htm"
   Say " -p <server>    use fully qualified path to server <server>. Normally DIR2HTML"
   Say "                stores only the filename in the created anchors. But:"
   Say "                DIR2HTLM -p http://www.th-zwickau.de/~hwa/midis *.mid"
   Say "                produces anchors like this:"
   Say '                <a href="http://www.th-zwickau.de/~hwa/midis/rebyell.mid">'
   Say " -l             convert filenames to lower case. Usefull if you create the"
   Say "                index-file on a Os/2-FAT system but your www-server is a unix-"
   Say "                machine with lower case filenames."
   Say " -i <filename>  creates a Info-Zip file containing all indexed files"
   Say " -r <filename>  uses a response file instead of command line options, herewith"
   Say "                you can create language specific documents"
   Say " -cgi           use the special WWW mode. So you can use DIR2HTML as a cgi-bin"
   Say "                It uses dir2html.rc as response file"
   Say " -debug         gives a verbose description of actions done by DIR2HTML"
   Say "*** Press Enter to continue ***"
   Pull EnterKey
   Say
   Say "DIR2HTML comes with ABSOLUTELY NO WARRANTY.  This is free software,"
   Say "and you are welcome to redistribute it under certain conditions; read"
   Say "the file COPYING for details."
   Return

ParseOptions:
   Options.OutFile="index.htm"
   Options.Subjects=0
   Options.Description=0
   Options.Server=""
   Options.LowerCase=0
   Options.Files="*"
   Options.Debug=0
   Options.DirDescription=0
   Options.IndexFile=""
   Options.ResponseFile=""
   Options.Title="Listing Of Files %f"
   Options.Heading=Options.Title
   Options.PreFace=""
   Options.PostScriptum="Last updated %d %t"
   Options.IndexHint="To download a collection of all indexed files try %i."
   Options.HTMLBody=""
   Options.CGIMode=0
   Flag=1
   Do While Flag
      Parse Value CmdLine With Option CmdLine
      Select
         when Option="-o" then Do
            Parse Value CmdLine With Options.OutFile CmdLine
            If Options.CGIMode then Options.OutFile=""
         end  /* Do */
         when Option="-s" then Options.Subjects=1
         when Option="-d" then Options.Description=1
         when Option="-p" then Parse Value CmdLine With Options.Server CmdLine
         when Option="-l" then Options.LowerCase=1
         when Option="-debug" then Options.Debug=1
         when Option="-f" then Options.DirDescription=1
         when Option="-cgi" then Do
            Options.CGIMode=1
            Options.OutFile=""
         end  /* Do */
         when Option="-i" then Do
            Parse Value CmdLine With Options.IndexFile CmdLine
            If Pos(".", FileSpec(Options.IndexFile))=0 then Do
               Options.IndexFile = Options.IndexFile".zip"
            end  /* Do */
         end /* Do */
         when Option="-r" then Do
            Parse Value CmdLine With Options.ResponseFile CmdLine
            Call LoadResponse Options.ResponseFile
         end /* Do */
      otherwise
         If SubStr(Option, 1, 1)="-" then Say "Unknown option "Option" ignored"
         else Do
            if Option<>"" then Options.Files=Option" "CmdLine
            Flag=0
         end  /* Do */
      end  /* select */
   end /* do */
   If Options.Debug then Do
      Say "DIR2HTML produces file "Options.OutFile" while processing "Options.Files
      Say "Subjects processing is "Options.Subjects
      Say "Description processing is "Options.Description
      Say "Describe directory is "Options.DirDescription
      Say "Serverpath is '"Options.Server"'"
      Say "Lowercase conversion is "Options.LowerCase
      Say "Using indexfile '"Options.IndexFile"'"
      Say "Using responsefile '"Options.ResponseFile"'"
   end  /* Do */
   If Options.Debug Then Say "Loading RexxUtil..."
   /* Load RexxUtil.DLL */
   CALL RxFuncAdd 'SysLoadFuncs','Rexxutil','SysLoadFuncs'
   CALL SysLoadFuncs
Return

WriteHeader:
   If \(Options.CGIMode) then Do
      If Options.Debug then Say "Deleting file "Options.OutFile" if existing..."
      Call SysFileDelete Options.OutFile
   end  /* Do */
   If Options.IndexFile<>"" then Do
      If Options.Debug then Say "Deleting file "Options.IndexFile" if existing..."
      Call SysFileDelete Options.IndexFile
   end  /* Do */
   If \Options.CGIMode then Do
      If Options.Debug then Say "Opening file "Options.OutFile
      RC=Stream(Options.OutFile, "Command", "Open Write");
      If RC<>"READY:" then Do
         If Options.Debug then Call SysFailure "opening file "Options.OutFile,RC
         else Say "Cannot open file "Options.OutFile
         Exit
      end  /* Do */
   end  /* Do */
   If Options.Debug then Say "Writing HTML-Header..."
   Call LineOut Options.OutFile, "<HTML>"
   Call LineOut Options.OutFile, "<TITLE>"StringTranslate(Options.Title)"</TITLE>"
   If Options.HTMLBody="" then Call LineOut Options.OutFile, "<BODY>"
   else Call LineOut Options.OutFile, "<BODY "Options.HTMLBody">"
   Call LineOut Options.OutFile, "<H1>"StringTranslate(Options.Heading)"</H1>"
   If Options.PreFace<>"" then Call LineOut Options.OutFile, StringTranslate(Options.PreFace)"<BR>"
   If Options.DirDescription then Do
      If Options.Debug then Say "Inserting FILE_ID.DIZ..."
      RC=Stream("file_id.diz", "Command", "Open Read");
      If RC<>"READY:" then Do
         If Options.Debug then Do
            Call SysFailure "opening file",RC
            Say "Skipping directory description..."
         end  /* Do */
      End /* Do */
      else Do
         Call LineOut Options.OutFile, "<PRE>"
         Do While Lines("file_id.diz")
            Call LineOut Options.OutFile, LineIn("file_id.diz")
         End /* Do */
         Call LineOut Options.OutFile, "</PRE>"
      end  /* Do */
      RC=Stream("file_id.diz", "Command", "Close")
      Call AddToZip "file_id.diz"
   end  /* Do */
   Call LineOut Options.OutFile, "<HR>"
   Call LineOut Options.OutFile, "<UL>"
   If Options.Description then Call AddToZip "descript.ion"
Return

WriteFooter:
   If Options.Debug then Say "Writing HTML-Footer..."
   Call LineOut Options.OutFile, "</UL>"
   If Options.IndexFile<>"" then Call LineOut Options.OutFile, StringTranslate(Options.IndexHint)
   Call LineOut Options.OutFile, "<HR>"
   If Options.PostScriptum<>"" Then Call LineOut Options.OutFile, StringTranslate(Options.PostScriptum)
   Call LineOut Options.OutFile, "<HR>This page was automagically created by <EM>DIR2HTML "Version"</EM> written by Helge Walter"
   If \Options.CGIMode then Do
      If Options.Debug then Say "Closing file "Options.OutFile"..."
      RC=Stream(Options.OutFile, "Command", "Close");
   end  /* Do */
Return

ProcessFiles:
   Do Until Words(Options.Files)=0
      Parse Value Options.Files With Current Options.Files
      If Options.Debug then Say "Retrieving directory listing matching "Current"..."
      RC=SysFileTree(Current, Dateien, "F");
      If RC<>0 then Do
         If Options.Debug then Call SysFailure "retrieving dirlist",RC
         else Say "Error retrieving directory listing."
      end  /* Do */
      else Do Counter=1 TO Dateien.0
         Call ProcessFile Dateien.Counter
      end  /* Do */
      If Options.IndexFile<>"" Then Call AddToZip Current
   end /* Do */
Return

ProcessFile:
   Parse Arg Datei
   Descript = ""
   Parse Value Datei With DDate DTime DSize DAttr DUName
   DUName = Strip(DUName)
   DName = FileSpec("Name", DUName)
   If Options.Debug then Say "Processing file "DUName"..."
   If Options.Subjects then Do
      If Options.Debug then Say "Reading Subject..."
      RC=SysGetEA(DUName, ".SUBJECT", "DESCRIPT")
      Parse Var Descript 5 Descript
      If Options.Debug then Say "Evaluated subject is "Descript
      If RC<>0 then Do
         If Options.Debug then Call SysFailure "reading subject",RC
         Descript=""
      end  /* Do */
   end  /* Do */
   If Options.Description then Do
      If Options.Debug then Say "Reading DESCRIPT.ION..."
      RC=SysFileSearch(DName, "descript.ion", Zeilen)
      If RC<>0 then Do
         If Options.Debug then Call SysFailure "searching thru DESCRIPT.ION",RC
      end  /* Do */
      else Do
         If Zeilen.0=0 then Do
            If Options.Debug then Say "Unable to find "DName" in DESCRIPT.ION. Skipping..."
         end  /* Do */
         else Do
            Descript=SubWord(Zeilen.1, 2)
         end  /* Do */
      end  /* Do */
   end  /* Do */
   If Options.LowerCase then DName=Translate(DName, AusTab, EinTab)
   If Descript="" then Descript=DName
   Zeile='<LI><A HREF="'Options.Server''DName'">'Descript'</A> ('DSize' Bytes)'
   Call LineOut Options.OutFile, Zeile
   Drop Descript
   Drop Zeilen.
Return

