/* Rexx Script */

/*
 * This script is based on the "automatic reply rexx script" 
 * It sends a passed text with a passed subject via inet.mail to an also
 * passed username.
 *
 * Please modify the settings...
 *
 * Usage: inetmail.cmd <UserName> <MsgFile> <Subject>
 *        
 */

/* Created: August 20, 1997 */
/* Added: September 15, 1997 */


Env = 'OS2ENVIRONMENT'
ReplyTo = 'info'                   /* Point to an address for more info */
Mailer = 'hmailer'
WhereAmI = 'ddan.dyn.ml.org'       /* Define to your local hostname */
Sender = 'postmaster'           /* Where errors will go */

/* The external functions we need */
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'

/* start main function */
/* The first arg is who the message is sent to.
 * The second is the filename to be sent.  The third it the 
 * Subject
 */
parse arg UserName MsgFile Subject

/* Find out where the files are */
AutoReply = value('autoreply',,Env)  /* comment this line to not use the environment variable */
/* AutoReply = 'f:\inetmail\forms' */  /* uncomment this line to specify a directory */

/* change to the directory for autoreply files */
Junk = directory(AutoReply)

/* create a temp file for the outgoing message */
OutFile = SysTempFileName('f?????.tmp', '?');
rc = stream(OutFile, 'C', 'OPEN WRITE')  /* open the file for writing */
call WriteHeaders /* the headers for the outgoing message */
rc = stream(OutFile, 'C', 'close')       /* close the file */

/* creat a temp file for the outgoing destionations */
Emailfile = SysTempFileName('e?????.tmp', '?')
rc = Stream(Emailfile, 'C' , 'OPEN WRITE')
rc = lineout(Emailfile, Username, )
rc = stream(Emailfile, 'C', 'close')

ReplyFile = AutoReply'\'MsgFile   /* append the reply file to the */
rc = AppendLock(ReplyFile OutFile)      /* headers file */

say 'Calling mailer'
/* now start the mailer */
Mailer Sender'@'WhereAmI EmailFile OutFile

return

/* ------------------------------------------------------------------ */
/*
 * Write out our standard headers for a message
 *
 */

WriteHeaders:  /* note that we have full access to all globals here */

TimeZone = value( 'TZ', , Env)
TmpTime = time('N')
DayOfWeek = date('W')
DayOfWeek = left(DayOfWeek, 3)
TmpDate = date('N')
/* we put in the local time for date so that posts are chronological */
rc = lineout(OutFile, 'From:' Sender '<'Sender'@'WhereAmI'>', )
if ReplyTo <> '' then
  rc = lineout(OutFile, 'Reply-To:' ReplyTo, )
rc = lineout(OutFile, 'Date:' DayOfWeek',' TmpDate TmpTime TimeZone, )
rc = lineout(OutFile, 'To:' UserName, )
rc = lineout(OutFile, 'Subject: ' Subject, )
/* rc = lineout(OutFile, 'OS/2 Rexx Form reply script for Inetmail 1.0', ) */
rc = lineout(OutFile, '', )

return

/* ------------------------------------------------------------------ */