/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applet;

import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Certificate;
import java.security.Identity;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import sun.applet.AppletAudioClip;
import sun.awt.image.URLImageSource;
import sun.tools.jar.JarVerifierStream;
import sunw.hotjava.applet.AppletClassEntry;
import sunw.hotjava.applet.AppletClassLoader;
import sunw.hotjava.security.TrustManager;

public class AppletResourceLoader {
    private Hashtable jarsLoaded = new Hashtable(3);
    private Hashtable resourceHash = new Hashtable(11);
    private Hashtable mimeHash = new Hashtable(11);
    AppletClassLoader loader;

    public AppletResourceLoader(AppletClassLoader appletClassLoader) {
        this.loader = appletClassLoader;
    }

    public void loadJar(URL uRL, String string) throws IOException {
        Object object;
        Boolean bl;
        URL uRL2 = this.loader.makeRelativeURLWithSecurity(uRL, string);
        Hashtable hashtable = this.jarsLoaded;
        synchronized (hashtable) {
            while (true) {
                if ((bl = (Boolean)this.jarsLoaded.get(uRL2)) == null) break;
                if (bl == Boolean.TRUE) {
                    Object var5_7 = null;
                    return;
                }
                if (bl != Boolean.FALSE) continue;
                try {
                    this.jarsLoaded.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException.toString());
                }
            }
            this.jarsLoaded.put(uRL2, Boolean.FALSE);
        }
        boolean bl2 = false;
        try {
            try {
                object = this.loader.checkRedirects(uRL2.openConnection());
                InputStream inputStream = this.loader.openConnection((URLConnection)object);
                this.loadJar(uRL, uRL2, inputStream);
                bl2 = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Resource " + uRL2 + " was not found");
            }
            bl = null;
            object = this.jarsLoaded;
        }
        catch (Throwable throwable) {
            bl = null;
            Hashtable hashtable2 = this.jarsLoaded;
            synchronized (hashtable2) {
                if (bl2) {
                    this.jarsLoaded.put(uRL2, Boolean.TRUE);
                } else {
                    this.jarsLoaded.remove(uRL2);
                }
                this.jarsLoaded.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            if (bl2) {
                this.jarsLoaded.put(uRL2, Boolean.TRUE);
            } else {
                this.jarsLoaded.remove(uRL2);
            }
            this.jarsLoaded.notifyAll();
        }
    }

    private void loadJar(URL uRL, URL uRL2, InputStream inputStream) throws IOException {
        block17: {
            JarVerifierStream jarVerifierStream = null;
            Hashtable<Object, AppletClassEntry> hashtable = new Hashtable<Object, AppletClassEntry>();
            try {
                try {
                    Object object;
                    jarVerifierStream = new JarVerifierStream(inputStream);
                    ZipEntry zipEntry = null;
                    byte[] byArray = new byte[2048];
                    while ((zipEntry = jarVerifierStream.getNextEntry()) != null) {
                        int n;
                        object = zipEntry.getName();
                        String string = null;
                        byte[] byArray2 = null;
                        int n2 = (int)zipEntry.getSize();
                        ByteArrayOutputStream byteArrayOutputStream = null;
                        if (n2 > 0) {
                            int n3;
                            byArray2 = new byte[n2];
                            n = n2;
                            while (n > 0) {
                                n3 = jarVerifierStream.read(byArray2, n2 - n, n);
                                if (n3 == -1) {
                                    byte[] byArray3 = byArray2;
                                    byArray2 = new byte[n2 - n];
                                    System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
                                }
                                n -= n3;
                            }
                            n3 = jarVerifierStream.read();
                            if (n3 != -1) {
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                byteArrayOutputStream.write(byArray2);
                                byArray2 = null;
                                byteArrayOutputStream.write(n3);
                            }
                        } else {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                        }
                        if (byteArrayOutputStream != null) {
                            while ((n = jarVerifierStream.read(byArray)) > 0) {
                                byteArrayOutputStream.write(byArray, 0, n);
                            }
                            byArray2 = byteArrayOutputStream.toByteArray();
                        }
                        if (string == null) {
                            string = this.guessManifestType((String)object);
                        }
                        if (string == null) {
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                            string = URLConnection.guessContentTypeFromStream(byteArrayInputStream);
                        }
                        if (string == null) {
                            string = "input-stream/input-stream";
                        }
                        if (string.startsWith("application/java-vm")) {
                            String string2 = ((String)object).substring(0, ((String)object).length() - 6).replace('/', '.');
                            AppletClassEntry appletClassEntry = this.loader.defineClassFromBytes(string2, byArray2, 0, byArray2.length);
                            hashtable.put(object, appletClassEntry);
                            continue;
                        }
                        if (string.equals("manifest/manifest") || string.equals("manifest/signature-bin")) continue;
                        this.putLocalResource(this.makeResourceURL(uRL2, (String)object), byArray2, string);
                    }
                    object = jarVerifierStream.getBlocks();
                    jarVerifierStream.getManifest();
                    if (object != null) {
                        this.signClasses(jarVerifierStream.getVerifiedSignatures(), hashtable);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Object var7_20 = null;
                if (jarVerifierStream == null) break block17;
            }
            catch (Throwable throwable) {
                block18: {
                    Object var7_21 = null;
                    if (jarVerifierStream == null) break block18;
                    jarVerifierStream.close();
                }
                throw throwable;
            }
            jarVerifierStream.close();
        }
    }

    private void signClasses(Hashtable hashtable, Hashtable hashtable2) {
        TrustManager trustManager = TrustManager.getTrustManager();
        if (hashtable == null || trustManager == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string);
            Object v = hashtable2.get(string);
            Object[] objectArray = new Identity[vector.size()];
            vector.copyInto(objectArray);
            Certificate[][] certificateArray = new Certificate[objectArray.length][];
            int n = 0;
            while (n < objectArray.length) {
                certificateArray[n] = ((Identity)objectArray[n]).certificates();
                ++n;
            }
            if (trustManager.isTrustedFor(certificateArray, "software", new Date())) {
                AppletClassEntry appletClassEntry;
                if (!(v instanceof AppletClassEntry) || (appletClassEntry = (AppletClassEntry)this.loader.rawClasses.get(v)) == null || appletClassEntry != v) continue;
                appletClassEntry.ids = objectArray;
                continue;
            }
            this.loader.rawClasses.clear();
            hashtable2.clear();
            return;
        }
    }

    String guessManifestType(String string) {
        if ((string = string.toUpperCase()).startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.startsWith("META-INF/")) {
            return null;
        }
        if (string.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            return "manifest/manifest";
        }
        if (string.endsWith("DSA") || string.endsWith("PK7") || string.endsWith("PGP")) {
            return "manifest/signature-bin";
        }
        if (string.endsWith("SF")) {
            return "manifest/signature-asc";
        }
        return null;
    }

    public AudioClip getAudioClip(URL uRL) {
        return new AppletAudioClip(uRL);
    }

    public Image getImage(URL uRL) {
        return Toolkit.getDefaultToolkit().createImage(new URLImageSource(uRL));
    }

    private void putLocalResource(URL uRL, byte[] byArray, String string) {
        this.resourceHash.put(uRL, byArray);
        this.mimeHash.put(uRL, string);
    }

    public URL getResourceAsURL(String string) throws MalformedURLException {
        Hashtable hashtable = this.jarsLoaded;
        synchronized (hashtable) {
            Enumeration enumeration = this.jarsLoaded.keys();
            while (enumeration.hasMoreElements()) {
                URL uRL = (URL)enumeration.nextElement();
                URL uRL2 = this.makeResourceURL(uRL, string);
                if (this.getResourceBytes(uRL2) == null) continue;
                URL uRL3 = uRL2;
                Object var4_7 = null;
                return uRL3;
            }
        }
        return null;
    }

    public byte[] getResourceBytes(URL uRL) {
        return (byte[])this.resourceHash.get(uRL);
    }

    public String getResourceType(URL uRL) {
        return (String)this.mimeHash.get(uRL);
    }

    private URL makeResourceURL(URL uRL, String string) throws MalformedURLException {
        return new URL("appletresource:/" + this.loader.base + "!" + uRL + "!" + string);
    }
}

