/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applet;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import sunw.hotjava.applet.AppletClassLoader;
import sunw.hotjava.applet.AppletObjectInputStream;
import sunw.hotjava.applet.AppletResourceLoader;
import sunw.hotjava.applet.AppletThreadGroup;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.security.AppletSecurityException;

public class BasicAppletManager {
    private static String propPrefix = "appletpanel.";
    private static Hashtable classloaders = new Hashtable(11);
    private static Hashtable codeBaseRefCounts = new Hashtable(11);
    private static Hashtable threadGroups = new Hashtable(11);

    private synchronized void flushClassLoader(URL uRL) {
        AppletClassLoader appletClassLoader = (AppletClassLoader)classloaders.get(uRL);
        appletClassLoader.destroy();
        classloaders.remove(uRL);
        codeBaseRefCounts.remove(uRL);
    }

    public void removeThreadGroup(URL uRL) {
        Hashtable hashtable = threadGroups;
        synchronized (hashtable) {
            threadGroups.remove(uRL);
            return;
        }
    }

    public synchronized ClassLoader refClassLoader(URL uRL, String[] stringArray, Object object) {
        if (uRL != null) {
            try {
                AppletClassLoader appletClassLoader = (AppletClassLoader)classloaders.get(uRL);
                boolean bl = false;
                if (appletClassLoader == null) {
                    appletClassLoader = new AppletClassLoader(uRL, this, object);
                    bl = true;
                }
                this.incrementCodeBaseRefCount(appletClassLoader.getBase());
                if (stringArray != null && stringArray.length > 0) {
                    this.loadJarFiles(appletClassLoader, stringArray);
                }
                if (bl) {
                    classloaders.put(uRL, appletClassLoader);
                }
                return appletClassLoader;
            }
            catch (IOException iOException) {
                System.out.println("IOException!!!!!!");
            }
            catch (InterruptedException interruptedException) {
                System.out.println("InterruptedException");
            }
        }
        return null;
    }

    public static AppletClassLoader getClassLoaderIfExists(URL uRL) {
        AppletClassLoader appletClassLoader = (AppletClassLoader)classloaders.get(uRL);
        return appletClassLoader;
    }

    private void incrementCodeBaseRefCount(URL uRL) {
        Hashtable hashtable = codeBaseRefCounts;
        synchronized (hashtable) {
            Integer n = (Integer)codeBaseRefCounts.get(uRL);
            if (n == null) {
                codeBaseRefCounts.put(uRL, new Integer(1));
            } else {
                n = new Integer(n + 1);
                codeBaseRefCounts.put(uRL, n);
            }
            if (n == null) {
                n = new Integer(1);
            }
            return;
        }
    }

    public ThreadGroup getThreadGroup(URL uRL) {
        ThreadGroup threadGroup;
        Hashtable hashtable = threadGroups;
        synchronized (hashtable) {
            threadGroup = (ThreadGroup)threadGroups.get(uRL);
            if (threadGroup == null || threadGroup.isDestroyed()) {
                threadGroup = new AppletThreadGroup(String.valueOf(uRL) + "-threadGroup");
                threadGroup.setDaemon(true);
                threadGroups.put(uRL, threadGroup);
            }
        }
        return threadGroup;
    }

    public synchronized Integer deRefClassLoader(URL uRL, boolean bl) {
        Hashtable hashtable = codeBaseRefCounts;
        synchronized (hashtable) {
            Integer n = (Integer)codeBaseRefCounts.get(uRL);
            if (n == null || n <= 0) {
                System.err.println("Invalid count!");
                Thread.dumpStack();
                n = null;
            } else {
                n = n == 1 ? null : new Integer(n - 1);
            }
            if (n == null) {
                this.flushClassLoader(uRL);
                codeBaseRefCounts.remove(uRL);
            } else {
                codeBaseRefCounts.put(uRL, n);
            }
            Integer n2 = n;
            Object var5_6 = null;
            return n2;
        }
    }

    private static synchronized void flushClassLoaders() {
        classloaders = new Hashtable(11);
        codeBaseRefCounts = new Hashtable(11);
    }

    private void loadJarFiles(AppletClassLoader appletClassLoader, String[] stringArray) throws IOException, InterruptedException {
        AppletResourceLoader appletResourceLoader = appletClassLoader.getResourceLoader();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                appletResourceLoader.loadJar(appletClassLoader.getBase(), stringArray[n]);
            }
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Applet createApplet(ClassLoader classLoader, String string, String string2) throws ClassNotFoundException, IllegalAccessException, IOException, InstantiationException, InterruptedException {
        AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
        Applet applet = null;
        if (string != null) {
            applet = null;
            if (string.startsWith("sunw.hotjava.applets.") || string.startsWith("sunw.hotjava.bean.applets.")) {
                applet = (Applet)Class.forName(string).newInstance();
            }
            if (applet != null) return applet;
            Class clazz = this.loadCode(string, appletClassLoader);
            if (clazz == null) throw new ClassNotFoundException(string);
            return (Applet)clazz.newInstance();
        }
        if (string2 == null) return applet;
        InputStream inputStream = appletClassLoader.getResourceAsStream(string2);
        if (inputStream == null) {
            inputStream = appletClassLoader.openRelativeURLWithSecurity(appletClassLoader.getCodeBase(), string2);
        }
        AppletObjectInputStream appletObjectInputStream = new AppletObjectInputStream(inputStream, appletClassLoader);
        Object object = appletObjectInputStream.readObject();
        return (Applet)object;
    }

    private Class loadCode(String string, AppletClassLoader appletClassLoader) throws ClassNotFoundException {
        String string2 = ".class";
        String string3 = ".java";
        int n = string.lastIndexOf(46);
        String string4 = "";
        if (n != -1) {
            string4 = string.substring(n);
        }
        if (n != -1 && string.indexOf(47) != -1) {
            String string5 = string.substring(0, n);
            String string6 = string5.replace('/', '.');
            try {
                return this.loadCode(string5, string4, string6, appletClassLoader);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string6);
            }
        }
        if (string4.equals(string3) || string4.equals(string2)) {
            String string7 = string.substring(0, n);
            string7 = string7.replace('.', '/');
            string4 = string2;
            String string8 = string7.replace('/', '.');
            try {
                return this.loadCode(string7, string4, string8, appletClassLoader);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(String.valueOf(string8) + ":  " + iOException.getLocalizedMessage());
            }
        }
        String string9 = string.replace('.', '/');
        string4 = string2;
        String string10 = string9.replace('/', '.');
        try {
            return this.loadCode(string9, string4, string10, appletClassLoader);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (n < 0) {
            n = string.length();
        }
        string9 = string.substring(0, n);
        string9 = string9.replace('.', '/');
        string4 = string.substring(n);
        string10 = string9.replace('/', '.');
        try {
            return this.loadCode(string9, string4, string10, appletClassLoader);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        string9 = string.substring(0, n);
        string9 = string9.replace('.', '/');
        string4 = string.substring(n);
        string10 = string.replace('/', '.');
        try {
            return this.loadCode(string9, string4, string10, appletClassLoader);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string10);
        }
    }

    private Class loadCode(String string, String string2, String string3, AppletClassLoader appletClassLoader) throws ClassNotFoundException, IOException {
        if (!this.isPriviledgedPage(appletClassLoader)) {
            BasicAppletManager.checkNewAppletPackageAccess(string3);
        }
        return appletClassLoader.loadCode(string, string2, string3);
    }

    private boolean isPriviledgedPage(AppletClassLoader appletClassLoader) {
        URL uRL = appletClassLoader.getCodeBase();
        String string = uRL.getProtocol();
        return "doc".equals(string) || "mailto".equals(string);
    }

    public void destroyApplets(int n) {
        AppletThreadGroup.letAppletsFinish(n);
    }

    public static void checkNewAppletPackageAccess(String string) {
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
        int n = string.indexOf(46);
        while (true) {
            String string2;
            if (n < 0) {
                n = string.length();
            }
            if (Boolean.valueOf(hJBProperties.getProperty("package.restrict.definition." + (string2 = string.substring(0, n)))).booleanValue()) {
                throw new AppletSecurityException("checkpackagedefinition", string);
            }
            if (n == string.length()) break;
            n = string.indexOf(46, n + 1);
        }
    }

    public Class createScriptClass(ClassLoader classLoader, String string, byte[] byArray) {
        if (!(classLoader instanceof AppletClassLoader)) {
            return null;
        }
        AppletClassLoader appletClassLoader = (AppletClassLoader)classLoader;
        return appletClassLoader.defineRealClassFromBytes(string, byArray, 0, byArray.length);
    }
}

