/*
 * Decompiled with CFR 0.152.
 */
package hfalk.hotedit;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextPane;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.SoftBevelBorder;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Document;
import hfalk.JHotEdit;
import hfalk.db.DBHotEditManager;
import hfalk.hotedit.JSaveHTMLAction;
import hfalk.jfc.JFrameWindow;
import hfalk.util.AdvHTMLCompositor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;

public class JHTMLTextAreaDialog
extends JFrameWindow
implements ActionListener,
KeyListener,
Observer {
    public JTextPane textAreaControl;
    JScrollPane scroller;
    private Dimension dim;
    String actionCommand = "Cancel";
    String actionText;
    boolean writeable;
    String helpId;
    JFrame frame;
    public static final Border loweredBorder = new SoftBevelBorder(1);
    JButton okButton;
    JButton cancelButton;
    JButton saveButton;
    private ResourceBundle resource;

    public JHTMLTextAreaDialog(JFrame jFrame, String string, String string2, boolean bl) {
        super(string);
        Locale locale;
        try {
            locale = new Locale(DBHotEditManager.instance().getLanguage(), DBHotEditManager.instance().getCountry());
            this.resource = ResourceBundle.getBundle("hfalk.hotedit.JHTMLTextAreaDialogL", locale);
        }
        catch (MissingResourceException missingResourceException) {
            JOptionPane.showMessageDialog((Component)this.frame, (Object)missingResourceException.getMessage(), (String)"INFORMATION_MESSAGE", (int)1);
            return;
        }
        this.frame = jFrame;
        this.actionText = string2;
        this.writeable = bl;
        ((Component)((Object)this)).enableEvents(64L);
        this.getContentPane().setLayout(new CardLayout(10, 10));
        this.getContentPane().setBackground(Color.lightGray);
        locale = new JPanel();
        ((Container)((Object)locale)).setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new BorderLayout());
        jPanel.setBorder((Border)BorderFactory.createTitledBorder((String)string2));
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        jPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
        this.textAreaControl = new JTextPane();
        this.textAreaControl.setFont(new Font("Courier", 0, 12));
        this.textAreaControl.addKeyListener(this);
        this.scroller = new JScrollPane(20, 30);
        JViewport jViewport = this.scroller.getViewport();
        jViewport.add((Component)this.textAreaControl);
        jViewport.revalidate();
        jViewport.setBackingStoreEnabled(true);
        jPanel.add((Component)this.scroller);
        JPanel jPanel2 = new JPanel();
        this.saveButton = new JButton(this.resource.getString("JHTMLTextAreaDialogL_Generate"));
        this.saveButton.setToolTipText(this.resource.getString("JHTMLTextAreaDialogL_TTGenerateHTML"));
        this.saveButton.addActionListener((ActionListener)this);
        this.saveButton.addKeyListener(this);
        jPanel2.add((Component)this.saveButton);
        this.okButton = new JButton(DBHotEditManager.instance().common("Common_Close"));
        this.okButton.setToolTipText(this.resource.getString("JHTMLTextAreaDialogL_TTCloseWindow"));
        this.okButton.addActionListener((ActionListener)this);
        this.okButton.addKeyListener(this);
        jPanel2.add((Component)this.okButton);
        ((Container)((Object)locale)).add("Center", (Component)jPanel);
        ((Container)((Object)locale)).add("South", (Component)jPanel2);
        this.getContentPane().add("Center", (Component)((Object)locale));
        ((Component)((Object)this)).setSize(500, 400);
        if (!this.writeable) {
            this.okButton.requestFocus();
            return;
        }
        this.textAreaControl.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (DBHotEditManager.instance().common("Common_Close").equals(string)) {
            this.actionCommand = "Cancel";
            ((Component)((Object)this)).setVisible(false);
            ((JHotEdit)this.frame).hotSpotGroup.deleteObserver(this);
            ((Window)((Object)this)).dispose();
        }
        if (this.resource.getString("JHTMLTextAreaDialogL_Generate").equals(string)) {
            this.actionCommand = "Save";
            this.okButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            JSaveHTMLAction jSaveHTMLAction = new JSaveHTMLAction((JHotEdit)this.frame);
            jSaveHTMLAction.actionPerformed(null);
            JOptionPane.showMessageDialog((Component)this.getContentPane(), (Object)this.resource.getString("JHTMLTextAreaDialogL_GenerateHTML"), (String)(String.valueOf(this.frame.getTitle()) + this.resource.getString("JHTMLTextAreaDialogL_Title")), (int)1);
            this.okButton.setEnabled(true);
            this.saveButton.setEnabled(true);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 201: {
                this.actionCommand = "Cancel";
                ((Component)((Object)this)).setVisible(false);
                ((JHotEdit)this.frame).hotSpotGroup.deleteObserver(this);
                ((Window)((Object)this)).dispose();
                return;
            }
        }
    }

    public String getCommand() {
        return this.actionCommand;
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.actionCommand = "Cancel";
                ((Component)((Object)this)).setVisible(false);
                ((JHotEdit)this.frame).hotSpotGroup.deleteObserver(this);
                ((Window)((Object)this)).dispose();
                return;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public synchronized String getText() {
        return this.textAreaControl.getText();
    }

    public synchronized void setText(String string) {
        this.textAreaControl.setText(string);
    }

    public void setCaretPosition(int n) {
        this.textAreaControl.setCaretPosition(n);
    }

    public void update(Observable observable, Object object) {
        Document document = this.textAreaControl.getDocument();
        try {
            document.remove(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {}
        AdvHTMLCompositor advHTMLCompositor = new AdvHTMLCompositor();
        advHTMLCompositor.compose(document, ((JHotEdit)this.frame).hotSpotGroup);
    }
}

