/*
 * Decompiled with CFR 0.152.
 */
package hfalk.hotedit;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.JOptionPane;
import hfalk.JHotEdit;
import hfalk.db.DBHotEditManager;
import hfalk.db.DBHotSpotItem;
import hfalk.hotedit.JEditImageNameAction;
import hfalk.hotedit.JShowImageDescriptionAction;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JHotSpotCanvas
extends JComponent
implements ActionListener,
MouseListener,
MouseMotionListener {
    private Image image;
    MediaTracker tracker;
    JHotEdit frame;
    PopupMenu popup;
    MenuItem m1;
    MenuItem m2;
    MenuItem m3;
    PopupMenu popupItem;
    MenuItem m1Item;
    MenuItem m2Item;
    int lastX = -1;
    int lastY = -1;
    int lastDX = -1;
    int lastDY = -1;
    boolean isRightMouseEvent;
    private ResourceBundle resource;
    private ResourceBundle gresource;

    public JHotSpotCanvas(JHotEdit jHotEdit, Image image) {
        try {
            Locale locale = new Locale(DBHotEditManager.instance().getLanguage(), DBHotEditManager.instance().getCountry());
            this.resource = ResourceBundle.getBundle("hfalk.hotedit.JHotSpotCanvasL", locale);
            this.gresource = ResourceBundle.getBundle("hfalk.JHotEditL", locale);
        }
        catch (MissingResourceException missingResourceException) {
            JOptionPane.showMessageDialog((Component)((Object)this.frame), (Object)missingResourceException.getMessage(), (String)"INFORMATION_MESSAGE", (int)1);
            return;
        }
        this.tracker = new MediaTracker((Component)((Object)this));
        this.image = image;
        this.frame = jHotEdit;
        this.tracker.addImage(image, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        ((Component)((Object)this)).enableEvents(96L);
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addMouseMotionListener(this);
    }

    public boolean setImage(Image image) {
        this.image = image;
        this.tracker.addImage(image, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        this.update(this.getGraphics());
        return true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth((ImageObserver)((Object)this)), this.image.getHeight((ImageObserver)((Object)this)));
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.image.getWidth((ImageObserver)((Object)this)), this.image.getHeight((ImageObserver)((Object)this)));
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.image.getWidth((ImageObserver)((Object)this)), this.image.getHeight((ImageObserver)((Object)this)));
    }

    public void paint(Graphics graphics) {
        ((Component)((Object)this)).setSize(this.image.getWidth((ImageObserver)((Object)this)), this.image.getHeight((ImageObserver)((Object)this)));
        Rectangle rectangle = this.getVisibleRect();
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.drawImage(this.image, 0, 0, (ImageObserver)((Object)this));
        Enumeration enumeration = this.frame.hotSpotGroup.items().elements();
        while (enumeration.hasMoreElements()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)enumeration.nextElement();
            if (!dBHotSpotItem.isVisible()) continue;
            dBHotSpotItem.paint(graphics, true);
        }
    }

    public void refresh() {
        this.paint(this.getGraphics());
    }

    public boolean showHotSpot(DBHotSpotItem dBHotSpotItem) {
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getVisibleRect();
        this.paint(graphics);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        dBHotSpotItem.paint(graphics, true);
        return true;
    }

    public boolean clearHotSpot() {
        this.lastX = -1;
        this.lastY = -1;
        this.update(this.getGraphics());
        return true;
    }

    public boolean saveHotSpot(String string) {
        String string2 = string.substring(0, string.length() - 4);
        this.saveHotSpotBinary(String.valueOf(string2) + ".HSB");
        return true;
    }

    public boolean saveHotSpotBinary(String string) {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        DBHotSpotItem dBHotSpotItem = null;
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getVisibleRect();
        switch (DBHotEditManager.instance().state) {
            case 16: {
                DBHotEditManager.instance().state = 2;
                ((Component)((Object)this)).setCursor(new Cursor(1));
                return;
            }
        }
        this.isRightMouseEvent = false;
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        if (DBHotEditManager.instance().state == 2) {
            int n = this.frame.currentItem.value() == null ? 0 : this.frame.currentItem.value().length;
            int[] nArray = new int[n + 2];
            if (n != 0) {
                int[] nArray2 = this.frame.currentItem.value();
                int n2 = 0;
                while (n2 < nArray2.length) {
                    nArray[n2] = nArray2[n2];
                    ++n2;
                }
            }
            nArray[n] = mouseEvent.getX();
            nArray[n + 1] = mouseEvent.getY();
            if (this.frame.currentItem.type().equals("RECT") && nArray.length == 4) {
                this.isRightMouseEvent = true;
                this.frame.currentItem.setValue(nArray);
                this.frame.endmarkToolFunc();
                return;
            }
            if (this.frame.currentItem.type().equals("CIRCLE") && nArray.length == 4) {
                this.isRightMouseEvent = true;
                this.frame.currentItem.setValue(nArray);
                this.frame.endmarkToolFunc();
                return;
            }
            this.frame.currentItem.setValue(nArray);
        }
        if ((dBHotSpotItem = this.frame.hotSpotGroup.getSelected()) != null) {
            dBHotSpotItem.setSelected(false);
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.paint(graphics);
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            dBHotSpotItem.paint(graphics, false);
        }
        if ((dBHotSpotItem = this.frame.hotSpotGroup.select(mouseEvent.getX(), mouseEvent.getY())) != null) {
            dBHotSpotItem.setSelected(true);
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            dBHotSpotItem.paint(graphics, false);
        }
        if ((dBHotSpotItem = this.frame.hotSpotGroup.getSelected()) != null) {
            ((Frame)((Object)this.frame)).setTitle(String.valueOf(this.gresource.getString("JHotEdit_Title")) + " " + this.gresource.getString("JHotEdit_Version") + dBHotSpotItem.asString());
            return;
        }
        ((Frame)((Object)this.frame)).setTitle(String.valueOf(this.gresource.getString("JHotEdit_Title")) + " " + this.gresource.getString("JHotEdit_Version"));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (DBHotEditManager.instance().state == 2) {
            ((Component)((Object)this)).setCursor(new Cursor(1));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ((Component)((Object)this)).setCursor(new Cursor(0));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        DBHotSpotItem dBHotSpotItem = null;
        if (DBHotEditManager.instance().state == 2) {
            return;
        }
        dBHotSpotItem = this.frame.hotSpotGroup.getSelected();
        if (dBHotSpotItem != null && dBHotSpotItem.isOnAnchor(mouseEvent.getX(), mouseEvent.getY())) {
            DBHotEditManager.instance().state = 8;
            return;
        }
        dBHotSpotItem = this.frame.hotSpotGroup.getSelected();
        if (dBHotSpotItem != null && dBHotSpotItem.isOnBorder(mouseEvent.getX(), mouseEvent.getY())) {
            DBHotEditManager.instance().state = 4;
            this.lastDX = mouseEvent.getX();
            this.lastDY = mouseEvent.getY();
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        DBHotSpotItem dBHotSpotItem = null;
        if (DBHotEditManager.instance().state == 4 || DBHotEditManager.instance().state == 8) {
            DBHotEditManager.instance().state = 0;
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            Object object;
            Object object2;
            if (DBHotEditManager.instance().state == 0) {
                dBHotSpotItem = this.frame.hotSpotGroup.getSelected();
                if (this.popup == null) {
                    this.m1 = new MenuItem(this.resource.getString("JHotSpotCanvasL_MenuEditStartMarkPOLY"));
                    this.m1.addActionListener(this);
                    this.m2 = new MenuItem(this.resource.getString("JHotSpotCanvasL_MenuEditStartMarkRECT"));
                    this.m2.addActionListener(this);
                    this.m3 = new MenuItem(this.resource.getString("JHotSpotCanvasL_MenuEditStartMarkCIRCLE"));
                    this.m3.addActionListener(this);
                    MenuItem menuItem = new MenuItem(this.resource.getString("JHotSpotCanvasL_MenuEditImageName"));
                    object2 = (Object)new JEditImageNameAction(this.frame);
                    menuItem.addActionListener((ActionListener)object2);
                    object = new MenuItem(this.resource.getString("JHotSpotCanvasL_MenuEditImageDescription"));
                    JShowImageDescriptionAction jShowImageDescriptionAction = new JShowImageDescriptionAction(this.frame);
                    ((MenuItem)object).addActionListener((ActionListener)((Object)jShowImageDescriptionAction));
                    this.popup = new PopupMenu();
                    ((Component)((Object)this)).add(this.popup);
                    this.popup.add(this.m1);
                    this.popup.add(this.m2);
                    this.popup.add(this.m3);
                    this.popup.addSeparator();
                    this.popup.add(menuItem);
                    this.popup.add((MenuItem)object);
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (!this.isRightMouseEvent) {
                    this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            if (DBHotEditManager.instance().state == 2) {
                int n = this.frame.currentItem.value() == null ? 0 : this.frame.currentItem.value().length;
                object2 = new int[n + 2];
                if (n != 0) {
                    object = this.frame.currentItem.value();
                    int n2 = 0;
                    while (n2 < ((int[])object).length) {
                        object2[n2] = object[n2];
                        ++n2;
                    }
                }
                object2[n] = mouseEvent.getX();
                object2[n + 1] = mouseEvent.getY();
                if (this.frame.currentItem.type().equals("RECT") && ((int[])object2).length == 4) {
                    this.isRightMouseEvent = true;
                    this.frame.currentItem.setValue((int[])object2);
                    this.frame.endmarkToolFunc();
                    return;
                }
                if (this.frame.currentItem.type().equals("CIRCLE") && ((int[])object2).length == 4) {
                    this.isRightMouseEvent = true;
                    this.frame.currentItem.setValue((int[])object2);
                    this.frame.endmarkToolFunc();
                    return;
                }
                this.frame.endmarkToolFunc();
            }
        }
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getVisibleRect();
        if (DBHotEditManager.instance().state == 2) {
            int n;
            String string;
            if (this.frame.currentItem.type().equals("POLY")) {
                String string2 = " - POLY XY[" + String.valueOf(mouseEvent.getX()) + " , " + String.valueOf(mouseEvent.getY()) + " ]";
                ((Frame)((Object)this.frame)).setTitle(String.valueOf(this.gresource.getString("JHotEdit_Title")) + " " + this.gresource.getString("JHotEdit_Version") + string2);
                if (this.lastX != -1 && this.lastY != -1) {
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.update(graphics);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.frame.currentItem.paint(graphics, false);
                    this.frame.currentItem.setSelected(true);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.drawLine(this.lastX, this.lastY, mouseEvent.getX(), mouseEvent.getY());
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - 2, this.lastY - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(mouseEvent.getX() - 2, mouseEvent.getY() - 2, 5, 5);
                }
                return;
            }
            if (this.frame.currentItem.type().equals("RECT")) {
                string = " - RECT XY[" + String.valueOf(mouseEvent.getX()) + " , " + String.valueOf(mouseEvent.getY()) + " ]";
                ((Frame)((Object)this.frame)).setTitle(String.valueOf(this.gresource.getString("JHotEdit_Title")) + " " + this.gresource.getString("JHotEdit_Version") + string);
                if (this.lastX != -1 && this.lastY != -1) {
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.update(graphics);
                    n = Math.min(this.lastX, mouseEvent.getX());
                    int n2 = Math.min(this.lastY, mouseEvent.getY());
                    int n3 = Math.abs(mouseEvent.getX() - this.lastX);
                    int n4 = Math.abs(mouseEvent.getY() - this.lastY);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.drawRect(n, n2, n3, n4);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(mouseEvent.getX() - 2, this.lastY - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(mouseEvent.getX() - 2, mouseEvent.getY() - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - 2, this.lastY - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - 2, mouseEvent.getY() - 2, 5, 5);
                }
            }
            if (this.frame.currentItem.type().equals("CIRCLE")) {
                string = " - CIRCLE XY[" + String.valueOf(mouseEvent.getX()) + " , " + String.valueOf(mouseEvent.getY()) + " ]";
                ((Frame)((Object)this.frame)).setTitle(String.valueOf(this.gresource.getString("JHotEdit_Title")) + " " + this.gresource.getString("JHotEdit_Version") + string);
                if (this.lastX != -1 && this.lastY != -1) {
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.update(graphics);
                    n = (int)Math.round(Math.sqrt(Math.pow(mouseEvent.getX() - this.lastX, 2.0) + Math.pow(mouseEvent.getY() - this.lastY, 2.0)));
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.getGraphics().drawArc(this.lastX - n, this.lastY - n, n * 2, n * 2, 0, 360);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - 2, this.lastY + n - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - 2, this.lastY - n - 2, 5, 5);
                    graphics.fillRect(this.lastX + n - 2, this.lastY - 2, 5, 5);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.fillRect(this.lastX - n - 2, this.lastY - 2, 5, 5);
                    return;
                }
            }
        } else {
            ((Component)((Object)this)).setCursor(new Cursor(0));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = this.getVisibleRect();
        if (DBHotEditManager.instance().state == 2) {
            return;
        }
        DBHotSpotItem dBHotSpotItem = this.frame.hotSpotGroup.getSelected();
        switch (DBHotEditManager.instance().state) {
            case 4: {
                if (dBHotSpotItem == null || this.lastDX == -1 || this.lastDY == -1) break;
                dBHotSpotItem.translate(mouseEvent.getX() - this.lastDX, mouseEvent.getY() - this.lastDY);
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.paint(graphics);
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                dBHotSpotItem.paint(graphics, false);
                ((Frame)((Object)this.frame)).setTitle(String.valueOf(this.gresource.getString("JHotEdit_Title")) + " " + this.gresource.getString("JHotEdit_Version") + dBHotSpotItem.asString());
                break;
            }
            case 8: {
                if (dBHotSpotItem == null) break;
                dBHotSpotItem.resize(mouseEvent.getX(), mouseEvent.getY());
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.paint(graphics);
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                dBHotSpotItem.paint(graphics, false);
                ((Frame)((Object)this.frame)).setTitle(String.valueOf(this.gresource.getString("JHotEdit_Title")) + " " + this.gresource.getString("JHotEdit_Version") + dBHotSpotItem.asString());
                break;
            }
            default: {
                ((Frame)((Object)this.frame)).setTitle(String.valueOf(this.gresource.getString("JHotEdit_Title")) + " " + this.gresource.getString("JHotEdit_Version"));
            }
        }
        if (dBHotSpotItem != null) {
            dBHotSpotItem.refresh();
        }
        this.lastDX = mouseEvent.getX();
        this.lastDY = mouseEvent.getY();
        mouseEvent.consume();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = actionEvent.getActionCommand();
        if (string.equals(this.resource.getString("JHotSpotCanvasL_MenuEditStartMarkPOLY"))) {
            bl = this.frame.markToolFunc("POLY");
            DBHotEditManager.instance().state = 2;
        }
        if (string.equals(this.resource.getString("JHotSpotCanvasL_MenuEditStartMarkRECT"))) {
            bl = this.frame.markToolFunc("RECT");
            DBHotEditManager.instance().state = 2;
        }
        if (string.equals(this.resource.getString("JHotSpotCanvasL_MenuEditStartMarkCIRCLE"))) {
            bl = this.frame.markToolFunc("CIRCLE");
            DBHotEditManager.instance().state = 2;
        }
        this.frame.enableMenu();
    }
}

