/*
 * Decompiled with CFR 0.152.
 */
package hfalk.hotedit;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JOptionPane;
import hfalk.JHotEdit;
import hfalk.db.DBHotEditManager;
import hfalk.print.PrintDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.ImageObserver;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class PrintReport01
extends AbstractAction {
    JFrame frame;
    private ResourceBundle resource;
    PrintDocument doc;

    public PrintReport01(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Locale locale = new Locale(DBHotEditManager.instance().getLanguage(), DBHotEditManager.instance().getCountry());
            this.resource = ResourceBundle.getBundle("hfalk.hotedit.PrintReport01L", locale);
        }
        catch (MissingResourceException missingResourceException) {
            JOptionPane.showMessageDialog((Component)this.frame, (Object)missingResourceException.getMessage(), (String)"INFORMATION_MESSAGE", (int)1);
            return;
        }
        this.print();
    }

    public String description() {
        return this.resource.getString("PrintReport01_Description");
    }

    public boolean print() {
        try {
            this.doc = new PrintDocument((Frame)this.frame, "PrintReport01");
        }
        catch (Exception exception) {
            this.doc = null;
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        String string = calendar.getTime().toString();
        this.doc.setHeader(((JHotEdit)this.frame).hotSpotGroup.name(), string);
        this.doc.setFooter("", "");
        this.doc.setApplicationName(this.resource.getString("PrintReport01_ApplicationName"));
        this.doc.newPage();
        this.doc.printHeader();
        Graphics graphics = this.doc.getGraphics();
        Rectangle rectangle = this.doc.getBounds();
        Font font = new Font("SansSerif", 0, 12);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.resource.getString("PrintReport01_Information"));
        vector.addElement("");
        vector.addElement(this.resource.getString("PrintReport01_Name"));
        vector.addElement("        " + ((JHotEdit)this.frame).hotSpotGroup.name());
        vector.addElement("");
        vector.addElement("");
        vector.addElement(this.resource.getString("PrintReport01_Description"));
        StringTokenizer stringTokenizer = new StringTokenizer(((JHotEdit)this.frame).hotSpotGroup.description(), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement("        " + stringTokenizer.nextToken());
        }
        vector.addElement("");
        vector.addElement("");
        vector.addElement(this.resource.getString("PrintReport01_File"));
        vector.addElement("        " + ((JHotEdit)this.frame).hotSpotGroup.fileName());
        vector.addElement("");
        vector.addElement("");
        vector.addElement(this.resource.getString("PrintReport01_Width"));
        vector.addElement("        " + String.valueOf(((JHotEdit)this.frame).img.getWidth((ImageObserver)this.frame)));
        vector.addElement("");
        vector.addElement(this.resource.getString("PrintReport01_Height"));
        vector.addElement("        " + String.valueOf(((JHotEdit)this.frame).img.getHeight((ImageObserver)this.frame)));
        int n2 = 2 * n;
        int n3 = 0;
        while (n3 < vector.size()) {
            if (n2 + n > rectangle.height) {
                this.doc.printFooter();
                this.doc.formFeed();
                this.doc.newPage();
                this.doc.printHeader();
                graphics = this.doc.getGraphics();
                rectangle = this.doc.getBounds();
                font = new Font("SansSerif", 0, 12);
                graphics.setFont(font);
                graphics.setColor(Color.black);
                fontMetrics = graphics.getFontMetrics(font);
                n = fontMetrics.getHeight();
                n2 = 2 * n;
            }
            graphics.drawString((String)vector.elementAt(n3), rectangle.x, rectangle.y + n2);
            n2 += n;
            ++n3;
        }
        this.doc.printFooter();
        this.doc.formFeed();
        this.doc.print();
        return true;
    }
}

