/*
 * Decompiled with CFR 0.152.
 */
package hfalk.hotedit;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JOptionPane;
import hfalk.JHotEdit;
import hfalk.db.DBHotEditManager;
import hfalk.db.DBHotSpotGroup;
import hfalk.db.DBHotSpotItem;
import hfalk.print.PrintDocument;
import hfalk.util.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.ImageObserver;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class PrintReport02
extends AbstractAction {
    JFrame frame;
    private ResourceBundle resource;
    PrintDocument doc;

    public PrintReport02(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Locale locale = new Locale(DBHotEditManager.instance().getLanguage(), DBHotEditManager.instance().getCountry());
            this.resource = ResourceBundle.getBundle("hfalk.hotedit.PrintReport02L", locale);
        }
        catch (MissingResourceException missingResourceException) {
            JOptionPane.showMessageDialog((Component)this.frame, (Object)missingResourceException.getMessage(), (String)"INFORMATION_MESSAGE", (int)1);
            return;
        }
        this.print();
    }

    public String description() {
        return this.resource.getString("PrintReport02_Description");
    }

    public boolean print() {
        try {
            this.doc = new PrintDocument((Frame)this.frame, "PrintReport02");
        }
        catch (Exception exception) {
            this.doc = null;
            return false;
        }
        DBHotSpotGroup dBHotSpotGroup = ((JHotEdit)this.frame).hotSpotGroup;
        Calendar calendar = Calendar.getInstance();
        String string = calendar.getTime().toString();
        this.doc.setHeader(dBHotSpotGroup.name(), string);
        this.doc.setFooter("", "");
        this.doc.setApplicationName(this.resource.getString("PrintReport02_ApplicationName"));
        this.doc.newPage();
        this.doc.printHeader();
        Graphics graphics = this.doc.getGraphics();
        Rectangle rectangle = this.doc.getBounds();
        Font font = new Font("SansSerif", 0, 12);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.resource.getString("PrintReport02_Information"));
        vector.addElement("");
        vector.addElement(this.resource.getString("PrintReport02_ImageName"));
        vector.addElement("        " + dBHotSpotGroup.name());
        vector.addElement("");
        vector.addElement("");
        vector.addElement(this.resource.getString("PrintReport02_ImageDescription"));
        StringTokenizer stringTokenizer = new StringTokenizer(dBHotSpotGroup.description(), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement("        " + stringTokenizer.nextToken());
        }
        vector.addElement("");
        vector.addElement("");
        vector.addElement(this.resource.getString("PrintReport02_ImageFile"));
        vector.addElement("        " + dBHotSpotGroup.fileName());
        vector.addElement("");
        vector.addElement("");
        vector.addElement(this.resource.getString("PrintReport02_ImageWidth"));
        vector.addElement("        " + String.valueOf(((JHotEdit)this.frame).img.getWidth((ImageObserver)this.frame)));
        vector.addElement("");
        vector.addElement(this.resource.getString("PrintReport02_ImageHeight"));
        vector.addElement("        " + String.valueOf(((JHotEdit)this.frame).img.getHeight((ImageObserver)this.frame)));
        int n2 = 0;
        while (n2 < dBHotSpotGroup.size()) {
            DBHotSpotItem dBHotSpotItem = dBHotSpotGroup.itemAt(n2);
            vector.addElement("");
            vector.addElement(String.valueOf(this.resource.getString("PrintReport02_HotSpotNumber")) + (n2 + 1));
            vector.addElement(String.valueOf(this.resource.getString("PrintReport02_HotSpotType")) + dBHotSpotItem.type());
            vector.addElement(String.valueOf(this.resource.getString("PrintReport02_HotSpotPatch")) + dBHotSpotItem.patch());
            vector.addElement(String.valueOf(this.resource.getString("PrintReport02_HotSpotName")) + dBHotSpotItem.name());
            vector.addElement(String.valueOf(this.resource.getString("PrintReport02_HotSpotValue")) + "(" + Utility.intArrayToString(dBHotSpotItem.value()) + ")");
            vector.addElement(this.resource.getString("PrintReport02_HotSpotDescription"));
            StringTokenizer stringTokenizer2 = new StringTokenizer(dBHotSpotItem.description(), "\n");
            while (stringTokenizer2.hasMoreTokens()) {
                vector.addElement("                 " + stringTokenizer2.nextToken());
            }
            ++n2;
        }
        int n3 = 2 * n;
        int n4 = 0;
        while (n4 < vector.size()) {
            if (n3 + n > rectangle.height) {
                this.doc.printFooter();
                this.doc.formFeed();
                this.doc.newPage();
                this.doc.printHeader();
                graphics = this.doc.getGraphics();
                rectangle = this.doc.getBounds();
                font = new Font("SansSerif", 0, 12);
                graphics.setFont(font);
                graphics.setColor(Color.black);
                fontMetrics = graphics.getFontMetrics(font);
                n = fontMetrics.getHeight();
                n3 = 2 * n;
            }
            graphics.drawString((String)vector.elementAt(n4), rectangle.x, rectangle.y + n3);
            n3 += n;
            ++n4;
        }
        this.doc.printFooter();
        this.doc.formFeed();
        this.doc.print();
        return true;
    }
}

