/*******************************************************************************
  InetPowerServer/2 - Rexx startup script

  This script is the correct way to start IPS
*******************************************************************************/
parse arg par1 trash;

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
call SysLoadFuncs;

if ( par1 = 'DoStartup' ) then do
  do until ( rc = 0 )
    if ( stream( 'binaries\ips2upd.exe', 'c', 'query exist' ) <> '' )  then do
      call LogIt 'New IPS executable found, testing file';
      '@binaries\ips2upd checkexe';
      if ( rc = -1 ) then do
	call LogIt 'New file was ok, upgrading';
        '@COPY binaries\ips2.exe binaries\ips2old.exe >>log\upgrade.log';
        '@COPY binaries\ips2upd.exe binaries\ips2.exe >>log\upgrade.log';
        '@DEL  binaries\ips2upd.exe >>log\upgrade.log';
      end
      else
        call LogIt 'New file was corrupt, not upgrading' ;
    end;

    '@binaries\ips2';
    err = rc;
    if ( err > 0 ) then do
      call LogIt 'Error #'rc', restarting IPS';
    end;
  end;

  return 0;
end;

'@START "InetPowerServer/2" /C /MIN binaries\startos2.cmd DoStartup';
say;
say 'Starting InetPowerServer/2 minimized ...';
return 0;

LogIt:
parse arg logtxt;

log = 'log\ips.log';
rc = stream( log, 'c', 'open' );
rc = stream( log, 'c', 'seek <0' );
dt = ' 'substr( time( 'L' ), 1, 11 );
call lineout log, dt' 'logtxt;
rc = stream( log, 'c', 'close' );

return;
