/*============================================================================
InetPowerServer - Example RexxHook script                        Feb 26 2000

Description:
  This script let you limit the number for sessions to one FTPd service from
  one specific host.

Configuration:
  You need to set "LimitSameHost: 2" in the correct FTP section of your
  config file. This script will default to 2 connections if that variable
  is not set.
   
Returns:
  This script returns 0 if the host is allowed to continue the login or a 
  FTPd response if connection is denied.
------------------------------------------------------------------------------*/
PARSE ARG socket args;
PARSE VALUE IPSVAR( socket, "%(remoteip)|%(configfile)|%(configsection)|" ), 
  WITH hostid"|"configfile"|"configsection"|";
PARSE VALUE IPSCFG( socket, configfile, configsection, "LimitSameHost" ),
  WITH limith;
IF ( limith <= 0 ) THEN limith = 200;

currentsocket = IPSVAR( socket, "%(sock.first)" );
counthosts = 0
DO WHILE ( currentsocket > 0 )
  IF ( IPSVAR( currentsocket, "%(remoteip)" ) = hostid ) &, 
     ( currentsocket <> socket ) THEN counthosts = counthosts + 1
  currentsocket = IPSVAR( currentsocket, "%(sock.next)" );
END;

IF ( counthosts >= limith ) THEN 
  RETURN "421 No more connections accepted from "hostid", try again later."
ELSE RETURN 0;
