/******************************************************************************
* InetPowerServer - Example RexxHook script                        Feb 26 2000
* 
* Description:
*   This script will check the e-mail address given as password for anonymous
*   login and allow or deny access based on the e-mail address given.
* 
* Rules for valid e-mail addresses:
*   - ident must be 3 or more characters long
*   - top level of domain name must match between host and e-mail
*   - ident@ are allowed and will automatically add the domain name of the
*     connected host
*   
* Returns:
*   This script returns 0 if the user is allowed access or a FTPd response if
*   login is rejected.
*******************************************************************************/
PARSE ARG socket args;
PARSE VALUE IPSVAR( socket, "%(usr.anon)|%(password)|%(remotehost)|" ), 
  WITH anon"|"passanon"|"remotehost"|";
  
RETURN 0; /* Remove this line to activate */
  
emailnotvalid = "530 E-mail address is not valid, please try again.";

IF anon THEN DO
  IF ( LASTPOS( "@", passanon ) = LENGTH( passanon )) THEN
    passanon = passanon||remotehost;
    
  PARSE VAR passanon ident"@"domain;
  PARSE VALUE REVERSE( domain ) WITH toplev".";
  toplev = REVERSE( toplev );
  
  IF ( LENGTH( ident ) <= 2 ) THEN RETURN emailnotvalid;
  IF ( DATATYPE( toplev ) = "CHAR" ) THEN DO
    PARSE VALUE REVERSE( remotehost ) WITH topdns".";
    topdns = REVERSE( topdns );
    IF ( toplev \= topdns ) THEN RETURN emailnotvalid;
  END
  ELSE IF ( POS( ".", domain ) = 0 ) THEN RETURN emailnotvalid;
END;

RETURN 0;
