/******************************************************************************
* InetPowerServer - Example RexxHook script                        Jul 15 2000
* 
* Description:
*   With this script you can add your own "SITE" command, or change/disable the
*   of already implemented commands.
*   
* Returns:
*   This script returns 0 if IPS should handle the command internally, or a
*   result code/text if the script handeled/disabled the command.
*******************************************************************************/
PARSE ARG socket cmd1 pars;
PARSE UPPER VAR cmd1 cmd1;

PARSE VALUE IPSVAR( socket, "%(usr.anon)|%(usr.admin)|%(usr.username)|" ), 
  WITH anon"|"admin"|"username"|";
  
SELECT
  WHEN ( CHKCMD( "EXEC", cmd1 ) & admin ) THEN EXIT EXEC( pars );

/* Uncomment to disable SITE WHO access for guest users
  WHEN   CHKCMD( "WHO",  cmd1 ) THEN EXIT WHO( anon );
*/
  OTHERWISE EXIT 0;
END;

EXIT 0;

WHO:
PARSE ARG pars;
IF ( pars = 1 ) THEN RETURN "200 Unknown SITE command."
ELSE RETURN 0;

EXEC:
PARSE ARG pars;
PARSE VALUE IPSVAR( socket, "%(curdisk)" ) WITH curdisk;
drive = SUBSTR( curdisk, 1, 2 );
direc = SUBSTR( curdisk, 3 );
IF ( direc = "" ) THEN direc = "\";
tempfile = DIRECTORY()"\siteexec."socket;
cmdexe = VALUE( "COMSPEC",, "OS2ENVIRONMENT" );
cmdpar = '/C "'drive' & cd 'direc' & 'pars'" >'tempfile' 2>>'DIRECTORY()'\siteexec.err';
cmdexe cmdpar;
RETURN "202 SITE EXEC command completed.&"tempfile"!delete";

CHKCMD:
RETURN ABBREV( ARG( 1 ), ARG( 2 ), 2 );
