/******************************************************************************
* InetPowerServer - Example RexxHook script                        Feb 26 2000
* 
* Description:
*   This script check how many active anonymous sessions the FTPd service has, 
*   and deny  anonymous access if more than 16 sessions are already active.
*   
* Returns:
*   This script returns 0 if the user is allowed to continue the login or a
*   FTPd response if login is denied.
*******************************************************************************/
PARSE ARG socket args;
PARSE VALUE IPSVAR( socket, "%(usr.anon)" ) WITH anon;
  
currentsocket = IPSVAR( socket, '%(sock.first)' );
countanon = 0
DO WHILE ( currentsocket > 0 )
  PARSE VALUE IPSVAR( currentsocket, "%(usr.anon)|%(sock.next)|" ),
    WITH anon"|"currentsocket"|";
  IF anon THEN countanon = countanon + 1;
END;

IF anon & ( countanon > 16 ) THEN
  RETURN "421 No more anonymous logins accepted at this time, try again later."
ELSE RETURN 0;
