/*============================================================================
Description:
  IPS/2 Installation script for use in OS/2 Warp.

History:
  2000/07/16 - Initial history entry
  ----------------------------------------------------------------------------*/
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
CALL SysLoadFuncs;

ipsvers = 'InetPowerServer/2';
cur_dir = DIRECTORY();

SAY 'Checking directory structure:';
IF SysFileTree('.\config', ft) = 0 THEN
  IF ft.0 = 0 THEN DO
    IF SysMkDir('config') = 0 THEN DO
      SAY '- config\ subdirectory created';
      '@XCOPY .\documentation\config\* .\config\* /E /S >NUL';
      SAY '- example setup copied from .\documentation\config';
    END
    ELSE
      SAY 'X config\ subdirectory cannot be created';
  END;

IF SysFileTree('.\scripts', ft) = 0 THEN
  IF ft.0 = 0 THEN DO
    IF SysMkDir('scripts') = 0 THEN DO
      SAY '- scripts\ subdirectory created';
      '@XCOPY .\documentation\scripts\* .\scripts\* /E /S >NUL';
      SAY '- example RexxHook scripts copied from .\documentation\scripts';
    END
    ELSE
      SAY 'X scripts\ subdirectory cannot be created';
  END;

IF SysFileTree('.\messages', ft) = 0 THEN 
  IF ft.0 = 0 THEN DO
    IF SysMkDir('messages') = 0 THEN DO
      SAY '- messages\ subdirectory created';
      '@XCOPY .\documentation\messages\* .\messages\* /E /S >NUL';
      SAY '- example Multiline messages copied from .\documentation\messages';
    END
    ELSE
      SAY 'X scripts\ subdirectory cannot be created';
  END
ELSE
  DO
    '@XCOPY .\documentation\messages\ftp\*.res .\messages\ftp\ >NUL';
    '@XCOPY .\documentation\messages\http\*.res .\messages\http\ >NUL';
    '@XCOPY .\documentation\messages\pop3\*.res .\messages\pop3\ >NUL';
    '@XCOPY .\documentation\messages\smtp\*.res .\messages\smtp\ >NUL';
    SAY '- new response files copied from .\documentation\config';
    '@XCOPY .\documentation\messages\ftp\*.hlp .\messages\ftp\ >NUL';
    '@XCOPY .\documentation\messages\http\*.hlp .\messages\http\ >NUL';
    '@XCOPY .\documentation\messages\pop3\*.hlp .\messages\pop3\ >NUL';
    '@XCOPY .\documentation\messages\smtp\*.hlp .\messages\smtp\ >NUL';
    SAY '- new help files copied from .\documentation\config';
  END;  
  
IF SysFileTree('.\log', ft) = 0 THEN
  IF ft.0 = 0 THEN DO
    IF SysMkDir('log') = 0 THEN
      SAY '- log\ subdirectory created';
    ELSE
      SAY 'X log\ subdirectory cannot be created';
  END;

SAY 'Creating IPS WPS folder:';
CALL SysMoveObject '<IPSFOLDER>', '<WP_DESKTOP>';
CALL SysDestroyObject '<IPSFOLDER>';
IF SysCreateObject( 'WPFolder', ipsvers, '<WP_DESKTOP>',,
                    'OBJECTID=<IPSFOLDER>;ICONFILE='cur_dir'\binaries\ico\ipsfldr1.ico;ICONNFILE=1,'cur_dir'\binaries\ico\ipsfldr2.ico;ICONVIEWPOS=25 50 50 25;BACKGROUND='cur_dir'\documentation\img\firering.jpg,,,I' ) THEN DO
  SAY '- IPS folder created';
END;

SAY 'Creating IPS WPS objects:';

CALL SysDestroyObject '<STARTIPS>';
IF SysCreateObject('WPProgram', 'Start IPS daemon', '<IPSFOLDER>',,
                   'OBJECTID=<STARTIPS>;EXENAME='cur_dir'\binaries\startos2.cmd;PARAMETERS=DoStartup;STARTUPDIR='cur_dir';ICONFILE='cur_dir'\binaries\ico\ips2.ico;MINIMIZED=YES') THEN
  SAY '- Startup object created';

IF SysFileTree('*', ft, 'DS') = 0 THEN DO
  DO curd = 1 to ft.0
    PARSE VALUE ft.curd WITH date time size attr name;
    name = STRIP(name);
    CALL SysSetObjectData name, 'ICONFILE='cur_dir'\binaries\ico\ipsfldr1.ico;ICONNFILE=1,'cur_dir'\binaries\ico\ipsfldr2.ico;BACKGROUND='cur_dir'\documentation\img\firering.jpg,,,I;ALWAYSSORT=YES;SHOWALLINTREEVIEW=YES;DEFAULTVIEW=TREE';
  END curd;
END;

longname = 'Configure IPS';
CALL SysPutEA cur_dir'\config', '.LONGNAME', 'FDFF'x || D2C(LENGTH(longname)) || '00'x || longname;
IF SysCreateShadow(cur_dir'\config', '<IPSFOLDER>') THEN
  SAY '- Configuration shadow folder created';

longname = 'RexxHook scripts';
CALL SysPutEA cur_dir'\scripts', '.LONGNAME', 'FDFF'x || D2C(LENGTH(longname)) || '00'x || longname;
IF SysCreateShadow( cur_dir'\scripts', '<IPSFOLDER>'  ) THEN
  SAY '- RexxHook script shadow folder created';

longname = 'Response messages';
CALL SysPutEA cur_dir'\messages', '.LONGNAME', 'FDFF'x || D2C(LENGTH(longname)) || '00'x || longname;
IF SysCreateShadow( cur_dir'\messages', '<IPSFOLDER>'  ) THEN
  SAY '- Response messages shadow folder created';

longname = 'Documentation';
CALL SysPutEA cur_dir'\documentation', '.LONGNAME', 'FDFF'x || D2C(LENGTH(longname)) || '00'x || longname;
IF SysCreateShadow(cur_dir'\documentation', '<IPSFOLDER>') THEN
  SAY '- Documentation shadow folder created';

longname = 'Log files';
CALL SysPutEA cur_dir'\log', '.LONGNAME', 'FDFF'x || D2C(LENGTH(longname)) || '00'x || longname;
IF SysCreateShadow(cur_dir'\log', '<IPSFOLDER>') THEN
  SAY '- Log files shadow folder created';

CALL SysOpenObject '<IPSFOLDER>', 'ICON', 0;
