/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.RemoteNode;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.sorter.Sorter;

public class RemoteResourceWrapperNode
implements MutableTreeNode,
RemoteNode {
    protected RemoteResourceWrapper rrw = null;
    protected RemoteResourceWrapperNode parent = null;
    protected String name = null;
    protected Vector children = null;

    protected RemoteResourceWrapperNode(RemoteResourceWrapper remoteResourceWrapper, String string) {
        this.rrw = remoteResourceWrapper;
        this.name = string;
    }

    protected RemoteResourceWrapperNode(RemoteResourceWrapperNode remoteResourceWrapperNode, RemoteResourceWrapper remoteResourceWrapper, String string) {
        this.parent = remoteResourceWrapperNode;
        this.name = string;
        this.rrw = remoteResourceWrapper;
    }

    protected void acquireChildren() {
        this.rrw.getServerBrowser().setCursor(3);
        if (this.children == null) {
            this.loadChildren();
        }
        this.rrw.getServerBrowser().setCursor(0);
    }

    public Enumeration children() {
        this.acquireChildren();
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        try {
            return this.rrw.getResource().isContainer();
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage(this.rrw, remoteAccessException);
            return false;
        }
    }

    public TreeNode getChildAt(int n) {
        this.acquireChildren();
        return (TreeNode)this.children.elementAt(n);
    }

    public int getChildCount() {
        this.acquireChildren();
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        this.acquireChildren();
        return this.children.indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public RemoteResourceWrapper getResourceWrapper() {
        return this.rrw;
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        this.acquireChildren();
        this.children.insertElementAt(mutableTreeNode, n);
    }

    public boolean isLeaf() {
        return this.getAllowsChildren() ^ true;
    }

    protected synchronized void loadChildren() {
        String[] stringArray = null;
        RemoteResourceWrapper remoteResourceWrapper = null;
        this.children = new Vector();
        try {
            stringArray = this.rrw.getResource().enumerateResourceIdentifiers();
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage(this.rrw, remoteAccessException);
        }
        if (stringArray == null) {
            return;
        }
        Sorter.sortStringArray((String[])stringArray, (boolean)true);
        int n = 0;
        while (n < stringArray.length) {
            try {
                remoteResourceWrapper = this.rrw.getChildResource(stringArray[n]);
            }
            catch (RemoteAccessException remoteAccessException) {
                Message.showErrorMessage(this.rrw, (Exception)((Object)remoteAccessException), stringArray[n]);
            }
            if (remoteResourceWrapper != null) {
                RemoteResourceWrapperNode remoteResourceWrapperNode = new RemoteResourceWrapperNode(this, remoteResourceWrapper, stringArray[n]);
                this.children.add(remoteResourceWrapperNode);
            }
            ++n;
        }
    }

    public void nodeWillCollapse() {
    }

    public void nodeWillExpand() {
        this.children = null;
    }

    public void remove(int n) {
        this.acquireChildren();
        this.children.remove(n);
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        this.children.remove(mutableTreeNode);
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = (RemoteResourceWrapperNode)mutableTreeNode;
    }

    public void setUserObject(Object object) {
        block2: {
            PropertyManager propertyManager;
            if (!(object instanceof String) || !(propertyManager = PropertyManager.getPropertyManager()).isEditable(this.rrw)) break block2;
            try {
                this.rrw.getResource().setValue("identifier", (Object)((String)object));
                this.name = (String)object;
            }
            catch (RemoteAccessException remoteAccessException) {
                Message.showErrorMessage(this.rrw, remoteAccessException);
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

