// CvsStatusHandler.java
// $Id: CvsStatusHandler.java,v 1.2 1998/03/16 11:05:32 bmahe Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.cvs;

import java.io.*;
import java.util.*;

class CvsStatusHandler extends StatusHandler {

    class RevisionEntry {
        String file = null;
        String rev  = null;

        RevisionEntry (String file, String rev) {
	    this.file = file;
	    this.rev  = rev;
	}
    }

    CvsDirectory cvs         = null;
    Vector       rentries     = null;

    void notifyEnd() {
	Enumeration enum = rentries.elements();
	while (enum.hasMoreElements()) {
	    RevisionEntry rentry = (RevisionEntry) enum.nextElement();
	    // Add an entry for the file:
	    CvsEntry entry = cvs.getFileEntry(rentry.file);
	    if ( entry != null )
		entry.setRevision(rentry.rev);
	}
    }

    void notifyEntry(String filename, String revision) {
	rentries.addElement( new RevisionEntry(filename, revision));
    }

    CvsStatusHandler(CvsDirectory cvs) {
	this.cvs   = cvs;
	rentries   = new Vector(10);
    }
}
