/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.ESArguments;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESClosure;
import com.caucho.es.ESDate;
import com.caucho.es.ESGlobal;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESUndefinedException;
import com.caucho.es.Global;
import com.caucho.es.Printf;
import java.util.Enumeration;
import java.util.Iterator;

public final class Call
extends ESBase {
    static ESId ARGUMENTS = ESId.intern("arguments");
    static ESId ARRAY = ESId.intern("Array");
    Call caller;
    ESObject callThis;
    int callLength;
    ESBase callee;
    public ESBase[] stack;
    int top;
    public ESGlobal global;
    ESBase[] scope;
    int scopeLength;
    public ESBase[] values;
    ESObject aux;
    Call child;

    void clear() {
        this.aux = null;
        this.child = null;
        this.top = 0;
    }

    public Call getCall() {
        Call call = this.child;
        if (call == null) {
            call = this.child = new Call();
        }
        call.caller = this;
        call.global = this.global;
        return call;
    }

    Global getGlobalProto() {
        return Global.getGlobalProto();
    }

    public ESBase wrap(Object object) {
        return Global.wrap(object);
    }

    final ESBase getArg(int n) {
        return this.stack[this.top + n];
    }

    public final ESBase getArg(int n, int n2) {
        return n < n2 ? this.stack[this.top + n] : ESBase.esUndefined;
    }

    public final int getArgInt32(int n, int n2) throws Exception {
        return n < n2 ? this.stack[this.top + n].toInt32() : 0;
    }

    public final double getArgNum(int n, int n2) throws Exception {
        return n < n2 ? this.stack[this.top + n].toNum() : Double.NaN;
    }

    public final String getArgString(int n, int n2) throws Exception {
        return n < n2 ? this.stack[this.top + n].toJavaString() : null;
    }

    public final Object getArgObject(int n, int n2) throws Exception {
        return n < n2 ? this.stack[this.top + n].toJavaObject() : null;
    }

    public ESObject createObject() {
        return new ESObject("Object", this.getGlobalProto().objProto);
    }

    public ESBase createDate(long l) {
        return new ESDate(l, (ESBase)this.getGlobalProto().dateProto);
    }

    public String printf(int n) throws Exception {
        return Printf.sprintf(this, n);
    }

    void setArg(int n, ESBase eSBase) {
        this.stack[this.top + n] = eSBase;
    }

    public final ESObject getThis() throws Exception {
        return this.stack[this.top - 1].toObject();
    }

    public final Object getThisWrapper() throws Exception {
        return this.stack[this.top - 1].toJavaObject();
    }

    void setThis(ESBase eSBase) {
        this.stack[this.top - 1] = eSBase;
    }

    public ESGlobal getGlobal() {
        return this.global;
    }

    public final ESObject getCallThis() throws Exception {
        ESBase eSBase = this.caller.stack[this.caller.top - 1];
        return eSBase.toObject();
    }

    ESBase getContext() {
        return this.scope[this.scopeLength - 1];
    }

    ESBase getFunctionContext() {
        if (this.caller == null || this.caller.scopeLength == 0) {
            return this.global;
        }
        return this.caller.scope[this.caller.scopeLength - 1];
    }

    public void pushScope(ESBase eSBase) {
        this.scope[this.scopeLength++] = eSBase;
    }

    public void popScope() {
        --this.scopeLength;
    }

    public ESObject getEval() {
        return (ESObject)this.scope[this.scopeLength - 1];
    }

    public ESObject createArg(ESId[] eSIdArray, int n) throws Exception {
        ESObject eSObject = ESArguments.create(eSIdArray, this, n);
        this.scope[this.scopeLength++] = eSObject;
        return eSObject;
    }

    public void setProperty(ESString eSString, ESBase eSBase) throws Exception {
    }

    public ESBase delete(ESString eSString) throws Exception {
        return this.aux == null ? ESBoolean.FALSE : this.aux.delete(eSString);
    }

    public ESBase findScopeProperty(ESString eSString) throws Exception {
        int n = this.scopeLength - 1;
        while (n > 0) {
            if (this.scope[n].getProperty(eSString) != ESBase.esEmpty) {
                return this.scope[n];
            }
            --n;
        }
        return this.global;
    }

    public ESBase scopeTypeof(ESString eSString) throws Exception {
        int n = this.scopeLength - 1;
        while (n >= 0) {
            ESBase eSBase = this.scope[n].getProperty(eSString);
            if (eSBase != ESBase.esEmpty) {
                return eSBase.typeof();
            }
            --n;
        }
        return ESBase.esEmpty.typeof();
    }

    public static ESBase setProperty(ESBase eSBase, ESString eSString, ESBase eSBase2) throws Exception {
        eSBase.setProperty(eSString, eSBase2);
        return eSBase2;
    }

    public static ESBase doVoid(ESBase eSBase) {
        return ESBase.esUndefined;
    }

    public ESBase array(ESBase eSBase) throws Exception {
        ESBase eSBase2 = this.call((ESBase)this.global, ARRAY, 0);
        eSBase2.setProperty(0, eSBase);
        return eSBase2;
    }

    public static ESBase comma(ESBase eSBase, ESBase eSBase2) {
        return eSBase2;
    }

    public static ESBase _first(ESBase eSBase, ESBase eSBase2) throws Exception {
        if (!(eSBase instanceof ESNumber)) {
            return ESNumber.create(eSBase.toNum());
        }
        return eSBase;
    }

    public static double _first(double d, double d2) throws Exception {
        return d;
    }

    public static double _pre(ESBase eSBase, ESString eSString, int n) throws Exception {
        double d = eSBase.getProperty(eSString).toNum();
        ESNumber eSNumber = ESNumber.create(d + (double)n);
        eSBase.setProperty(eSString, (ESBase)eSNumber);
        return d + (double)n;
    }

    public static double _post(ESBase eSBase, ESString eSString, int n) throws Exception {
        double d = eSBase.getProperty(eSString).toNum();
        ESNumber eSNumber = ESNumber.create(d + (double)n);
        eSBase.setProperty(eSString, (ESBase)eSNumber);
        return d;
    }

    public double _pre(ESString eSString, int n) throws Exception {
        double d = this.getScopeProperty(eSString).toNum();
        ESNumber eSNumber = ESNumber.create(d + (double)n);
        this.setScopeProperty(eSString, eSNumber);
        return d + (double)n;
    }

    public double _post(ESString eSString, int n) throws Exception {
        double d = this.getScopeProperty(eSString).toNum();
        ESNumber eSNumber = ESNumber.create(d + (double)n);
        this.setScopeProperty(eSString, eSNumber);
        return d;
    }

    public ESBase setGlobalProperty(ESString eSString, ESBase eSBase) throws Exception {
        this.global.setProperty(eSString, eSBase);
        return eSBase;
    }

    public ESBase getGlobalVariable(ESString eSString) throws Exception {
        ESBase eSBase = this.global.getProperty(eSString);
        if (eSBase == ESBase.esEmpty) {
            throw new ESUndefinedException("undefined variable `" + eSString + "'");
        }
        return eSBase;
    }

    public ESBase getScopeProperty(ESString eSString) throws Exception {
        int n = this.scopeLength - 1;
        while (n >= 0) {
            ESBase eSBase = this.scope[n].getProperty(eSString);
            if (eSBase != ESBase.esEmpty) {
                return eSBase;
            }
            --n;
        }
        throw new ESUndefinedException("undefined variable `" + eSString + "'");
    }

    public void fillScope() {
        if (this.callee instanceof ESClosure) {
            ESClosure eSClosure = (ESClosure)this.callee;
            if (eSClosure.scopeLength == 0) {
                this.scope[0] = this.caller.global;
                this.scopeLength = 1;
                return;
            }
            int n = 0;
            while (n < eSClosure.scopeLength) {
                this.scope[n] = eSClosure.scope[n];
                ++n;
            }
            this.scopeLength = eSClosure.scopeLength;
        } else {
            this.scope[0] = this.caller.global;
            this.scopeLength = 1;
        }
    }

    public ESBase hasScopeProperty(ESString eSString) throws Exception {
        int n = this.scopeLength - 1;
        while (n >= 0) {
            ESBase eSBase = this.scope[n].getProperty(eSString);
            if (eSBase != ESBase.esEmpty) {
                return eSBase;
            }
            --n;
        }
        return ESBase.esEmpty;
    }

    public ESBase setScopeProperty(ESString eSString, ESBase eSBase) throws Exception {
        if (eSBase == ESBase.esEmpty) {
            eSBase = ESBase.esUndefined;
        }
        int n = this.scopeLength - 1;
        while (n > 0) {
            if (this.scope[n].getProperty(eSString) != ESBase.esEmpty) {
                this.scope[n].setProperty(eSString, eSBase);
                return eSBase;
            }
            --n;
        }
        this.global.setProperty(eSString, eSBase);
        return eSBase;
    }

    public ESBase deleteScopeProperty(ESString eSString) throws Exception {
        int n = this.scopeLength - 1;
        while (n > 0) {
            if (this.scope[n].getProperty(eSString) != ESBase.esEmpty) {
                return this.scope[n].delete(eSString);
            }
            --n;
        }
        return this.global.delete(eSString);
    }

    public int arg(int n, ESBase eSBase) {
        this.stack[n + 1] = eSBase;
        return 1;
    }

    public ESBase callScope(ESString eSString, int n) throws Exception {
        this.top = n + 1;
        int n2 = this.caller.scopeLength;
        ESBase[] eSBaseArray = this.caller.scope;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            ESBase eSBase = eSBaseArray[n3].getProperty(eSString);
            if (eSBase != ESBase.esEmpty) {
                this.callee = eSBase;
                this.stack[n] = this.global;
                return eSBase.call(this, 0);
            }
            --n3;
        }
        throw new ESUndefinedException("undefined call `" + eSString + "'");
    }

    public ESBase callScope(ESString eSString, int n, ESBase eSBase) throws Exception {
        this.top = n + 1;
        int n2 = this.caller.scopeLength;
        ESBase[] eSBaseArray = this.caller.scope;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            ESBase eSBase2 = eSBaseArray[n3].getProperty(eSString);
            if (eSBase2 != ESBase.esEmpty) {
                this.callee = eSBase2;
                this.stack[n] = this.global;
                this.stack[n + 1] = eSBase;
                return eSBase2.call(this, 1);
            }
            --n3;
        }
        throw new ESUndefinedException("undefined call `" + eSString + "'");
    }

    public ESBase callScope(ESString eSString, int n, ESBase eSBase, ESBase eSBase2) throws Exception {
        this.top = n + 1;
        int n2 = this.caller.scopeLength;
        ESBase[] eSBaseArray = this.caller.scope;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            ESBase eSBase3 = eSBaseArray[n3].getProperty(eSString);
            if (eSBase3 != ESBase.esEmpty) {
                this.callee = eSBase3;
                this.stack[n] = this.global;
                this.stack[n + 1] = eSBase;
                this.stack[n + 2] = eSBase2;
                return eSBase3.call(this, 2);
            }
            --n3;
        }
        throw new ESUndefinedException("undefined call `" + eSString + "'");
    }

    public ESBase callScope(ESString eSString, int n, ESBase eSBase, ESBase eSBase2, ESBase eSBase3, int n2) throws Exception {
        this.top = n + 1;
        int n3 = this.caller.scopeLength;
        ESBase[] eSBaseArray = this.caller.scope;
        int n4 = n3 - 1;
        while (n4 >= 0) {
            ESBase eSBase4 = eSBaseArray[n4].getProperty(eSString);
            if (eSBase4 != ESBase.esEmpty) {
                this.callee = eSBase4;
                this.stack[n] = this.global;
                this.stack[n + 1] = eSBase;
                this.stack[n + 2] = eSBase2;
                this.stack[n + 3] = eSBase3;
                return eSBase4.call(this, n2);
            }
            --n4;
        }
        throw new ESUndefinedException("undefined call `" + eSString + "'");
    }

    public ESBase call(ESBase eSBase, ESString eSString, int n) throws Exception {
        this.top = n + 1;
        this.stack[n] = eSBase;
        return eSBase.call(this, 0, eSString);
    }

    public ESBase call(ESBase eSBase, ESString eSString, int n, ESBase eSBase2) throws Exception {
        this.top = n + 1;
        this.stack[n] = eSBase;
        this.stack[n + 1] = eSBase2;
        return eSBase.call(this, 1, eSString);
    }

    public ESBase call(ESBase eSBase, ESString eSString, int n, ESBase eSBase2, ESBase eSBase3) throws Exception {
        this.top = n + 1;
        this.stack[n] = eSBase;
        this.stack[n + 1] = eSBase2;
        this.stack[n + 2] = eSBase3;
        return eSBase.call(this, 2, eSString);
    }

    public ESBase call(ESBase eSBase, ESString eSString, int n, ESBase eSBase2, ESBase eSBase3, ESBase eSBase4, int n2) throws Exception {
        this.top = n + 1;
        this.stack[n] = eSBase;
        this.stack[n + 1] = eSBase2;
        this.stack[n + 2] = eSBase3;
        this.stack[n + 3] = eSBase4;
        return eSBase.call(this, n2, eSString);
    }

    public ESBase call(ESBase eSBase, int n) throws Exception {
        this.top = n + 1;
        this.stack[n] = this.global;
        this.callee = eSBase;
        return eSBase.call(this, 0);
    }

    public ESBase call(ESBase eSBase, int n, ESBase eSBase2) throws Exception {
        this.top = n + 1;
        this.stack[n + 1] = eSBase2;
        this.stack[n] = this.global;
        this.callee = eSBase;
        return eSBase.call(this, 1);
    }

    public ESBase call(ESBase eSBase, int n, ESBase eSBase2, ESBase eSBase3) throws Exception {
        this.top = n + 1;
        this.stack[n] = eSBase;
        this.stack[n + 1] = eSBase2;
        this.stack[n + 2] = eSBase3;
        this.stack[n] = this.global;
        this.callee = eSBase;
        return eSBase.call(this, 2);
    }

    public ESBase call(ESBase eSBase, int n, ESBase eSBase2, ESBase eSBase3, ESBase eSBase4, int n2) throws Exception {
        this.top = n + 1;
        this.stack[n] = eSBase;
        this.stack[n + 1] = eSBase2;
        this.stack[n + 2] = eSBase3;
        this.stack[n + 3] = eSBase4;
        this.stack[n] = this.global;
        this.callee = eSBase;
        return eSBase.call(this, n2);
    }

    public ESBase newScope(ESString eSString, int n) throws Exception {
        this.top = n + 1;
        int n2 = this.caller.scopeLength;
        ESBase[] eSBaseArray = this.caller.scope;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            ESBase eSBase = eSBaseArray[n3].getProperty(eSString);
            if (eSBase != ESBase.esEmpty) {
                this.callee = eSBase;
                this.stack[n] = this.global;
                return eSBase.construct(this, 0);
            }
            --n3;
        }
        throw new ESUndefinedException("undefined constructor `" + eSString + "'");
    }

    public ESBase newScope(ESString eSString, int n, ESBase eSBase) throws Exception {
        this.top = n + 1;
        int n2 = this.caller.scopeLength;
        ESBase[] eSBaseArray = this.caller.scope;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            ESBase eSBase2 = eSBaseArray[n3].getProperty(eSString);
            if (eSBase2 != ESBase.esEmpty) {
                this.callee = eSBase2;
                this.stack[n] = this.global;
                this.stack[n + 1] = eSBase;
                return eSBase2.construct(this, 1);
            }
            --n3;
        }
        throw new ESUndefinedException("undefined constructor `" + eSString + "'");
    }

    public ESBase newScope(ESString eSString, int n, ESBase eSBase, ESBase eSBase2) throws Exception {
        this.top = n + 1;
        int n2 = this.caller.scopeLength;
        ESBase[] eSBaseArray = this.caller.scope;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            ESBase eSBase3 = eSBaseArray[n3].getProperty(eSString);
            if (eSBase3 != ESBase.esEmpty) {
                this.callee = eSBase3;
                this.stack[n] = this.global;
                this.stack[n + 1] = eSBase;
                this.stack[n + 2] = eSBase2;
                return eSBase3.construct(this, 2);
            }
            --n3;
        }
        throw new ESUndefinedException("undefined constructor `" + eSString + "'");
    }

    public ESBase newScope(ESString eSString, int n, ESBase eSBase, ESBase eSBase2, ESBase eSBase3, int n2) throws Exception {
        this.top = n + 1;
        int n3 = this.caller.scopeLength;
        ESBase[] eSBaseArray = this.caller.scope;
        int n4 = n3 - 1;
        while (n4 >= 0) {
            ESBase eSBase4 = eSBaseArray[n4].getProperty(eSString);
            if (eSBase4 != ESBase.esEmpty) {
                this.callee = eSBase4;
                this.stack[n] = this.global;
                this.stack[n + 1] = eSBase;
                this.stack[n + 2] = eSBase2;
                this.stack[n + 3] = eSBase3;
                return eSBase4.construct(this, n2);
            }
            --n4;
        }
        throw new ESUndefinedException("undefined constructor `" + eSString + "'");
    }

    public ESBase doNew(ESBase eSBase, ESString eSString, int n) throws Exception {
        this.top = n + 1;
        ESBase eSBase2 = eSBase.getProperty(eSString);
        this.stack[n] = eSBase;
        this.callee = eSBase2;
        if (eSBase2 != ESBase.esEmpty) {
            return eSBase2.construct(this, 0);
        }
        throw new ESUndefinedException("undefined constructor `" + eSString + "'");
    }

    public ESBase doNew(ESBase eSBase, ESString eSString, int n, ESBase eSBase2) throws Exception {
        ESBase eSBase3;
        this.top = n + 1;
        this.stack[n] = eSBase;
        this.stack[n + 1] = eSBase2;
        this.callee = eSBase3 = eSBase.getProperty(eSString);
        if (eSBase3 != ESBase.esEmpty) {
            return eSBase3.construct(this, 1);
        }
        throw new ESUndefinedException("undefined constructor `" + eSString + "'");
    }

    public ESBase doNew(ESBase eSBase, ESString eSString, int n, ESBase eSBase2, ESBase eSBase3) throws Exception {
        ESBase eSBase4;
        this.top = n + 1;
        this.stack[n] = eSBase;
        this.stack[n + 1] = eSBase2;
        this.stack[n + 2] = eSBase3;
        this.callee = eSBase4 = eSBase.getProperty(eSString);
        if (eSBase4 != ESBase.esEmpty) {
            return eSBase4.construct(this, 2);
        }
        throw new ESUndefinedException("undefined constructor `" + eSString + "'");
    }

    public ESBase doNew(ESBase eSBase, ESString eSString, int n, ESBase eSBase2, ESBase eSBase3, ESBase eSBase4, int n2) throws Exception {
        ESBase eSBase5;
        this.top = n + 1;
        this.stack[n] = eSBase;
        this.stack[n + 1] = eSBase2;
        this.stack[n + 2] = eSBase3;
        this.stack[n + 3] = eSBase4;
        this.callee = eSBase5 = eSBase.getProperty(eSString);
        if (eSBase5 != ESBase.esEmpty) {
            return eSBase5.construct(this, n2);
        }
        throw new ESUndefinedException("undefined constructor `" + eSString + "'");
    }

    public ESBase doNew(ESBase eSBase, int n) throws Exception {
        this.top = n + 1;
        this.stack[n] = this.global;
        this.callee = eSBase;
        return eSBase.construct(this, 0);
    }

    public ESBase doNew(ESBase eSBase, int n, ESBase eSBase2) throws Exception {
        this.top = n + 1;
        this.stack[n] = this.global;
        this.stack[n + 1] = eSBase2;
        this.callee = eSBase;
        return eSBase.construct(this, 1);
    }

    public ESBase doNew(ESBase eSBase, int n, ESBase eSBase2, ESBase eSBase3) throws Exception {
        this.top = n + 1;
        this.stack[n] = this.global;
        this.stack[n + 1] = eSBase2;
        this.stack[n + 2] = eSBase3;
        this.callee = eSBase;
        return eSBase.construct(this, 2);
    }

    public ESBase doNew(ESBase eSBase, int n, ESBase eSBase2, ESBase eSBase3, ESBase eSBase4, int n2) throws Exception {
        this.top = n + 1;
        this.stack[n] = this.global;
        this.stack[n + 1] = eSBase2;
        this.stack[n + 2] = eSBase3;
        this.stack[n + 3] = eSBase4;
        this.callee = eSBase;
        return eSBase.construct(this, n2);
    }

    public static Iterator toESIterator(Iterator iterator) {
        return new ESIterator(iterator);
    }

    public static Iterator toESIterator(Enumeration enumeration) {
        return new ESEnumIterator(enumeration);
    }

    public static boolean matchException(ESBase eSBase, Exception exception) {
        String string;
        try {
            string = eSBase.toStr().toString();
        }
        catch (Exception exception2) {
            string = "undefined";
        }
        Class<?> clazz = exception.getClass();
        String string2 = "." + eSBase;
        while (clazz != null) {
            String string3 = clazz.getName();
            if (string.equals(string3) || string3.endsWith(string2)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    Call() {
        this.prototype = ESBase.esBase;
        this.stack = new ESBase[64];
        this.scope = new ESBase[16];
        this.values = new ESBase[64];
        this.top = 0;
    }

    static class ESIterator
    implements Iterator {
        Global resin;
        Iterator i;

        public boolean hasNext() {
            return this.i != null && this.i.hasNext();
        }

        public Object next() {
            Object var1_1 = this.i == null ? null : this.i.next();
            ESBase eSBase = var1_1 == null ? ESBase.esNull : this.resin.objectWrap(var1_1);
            return eSBase;
        }

        public void remove() {
            throw new RuntimeException();
        }

        ESIterator(Iterator iterator) {
            this.i = iterator;
            this.resin = Global.getGlobalProto();
        }
    }

    static class ESEnumIterator
    implements Iterator {
        Global resin;
        Enumeration e;

        public boolean hasNext() {
            return this.e != null && this.e.hasMoreElements();
        }

        public Object next() {
            Object var1_1;
            Object v0 = var1_1 = this.e != null ? this.e.nextElement() : null;
            if (var1_1 == null) {
                return ESBase.esNull;
            }
            return this.resin.objectWrap(var1_1);
        }

        public void remove() {
            throw new RuntimeException();
        }

        ESEnumIterator(Enumeration enumeration) {
            this.e = enumeration;
            this.resin = Global.getGlobalProto();
        }
    }
}

