/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

class NativeFile
extends Native {
    static ESId IN = ESId.intern("in");
    static ESId OUT = ESId.intern("out");
    static final int WRITE = 2;
    static final int WRITELN = 3;
    static final int FLUSH = 4;
    static final int CLOSE = 5;

    static void create(Global global) {
        NativeFile.put(global, "write", 2, 0, 4);
        NativeFile.put(global, "writeln", 3, 0, 4);
        NativeFile.put(global, "flush", 4, 0, 4);
        NativeFile.put(global, "close", 5, 0, 4);
    }

    private static void put(Global global, String string, int n, int n2, int n3) {
        ESId eSId = ESId.intern(string);
        global.addProperty(eSId, new NativeFile(string, n, n2));
    }

    public ESBase call(Call call, int n) throws Exception {
        switch (this.n) {
            case 2: {
                return NativeFile.write(call, n);
            }
            case 3: {
                return NativeFile.writeln(call, n);
            }
            case 4: {
                return NativeFile.flush(call, n);
            }
            case 5: {
                return NativeFile.close(call, n);
            }
        }
        throw new ESException("Unknown file function");
    }

    private static WriteStream getWriteStream(Call call) throws Exception {
        ESBase eSBase = call.getArg(-1);
        WriteStream writeStream = null;
        try {
            writeStream = (WriteStream)eSBase.toJavaObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (writeStream != null) {
            return writeStream;
        }
        ESBase eSBase2 = eSBase.hasProperty(OUT);
        try {
            writeStream = (WriteStream)eSBase2.toJavaObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        eSBase2 = Global.getGlobalProto().getGlobal().hasProperty(OUT);
        try {
            writeStream = (WriteStream)eSBase2.toJavaObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (writeStream == null) {
            throw new ESException("expected file as `this' or as value of `" + OUT + "'");
        }
        return writeStream;
    }

    public static ESBase write(Call call, int n) throws Exception {
        WriteStream writeStream = NativeFile.getWriteStream(call);
        try {
            int n2 = 0;
            while (n2 < n) {
                writeStream.print(call.getArg(n2).toString());
                ++n2;
            }
        }
        catch (IOException iOException) {
            return ESBoolean.FALSE;
        }
        return call.getArg(-1);
    }

    public static ESBase writeln(Call call, int n) throws Exception {
        WriteStream writeStream = NativeFile.getWriteStream(call);
        try {
            int n2 = 0;
            while (n2 < n) {
                writeStream.print(call.getArg(n2).toString());
                ++n2;
            }
            writeStream.println();
        }
        catch (IOException iOException) {
            return ESBoolean.FALSE;
        }
        return call.getArg(-1);
    }

    public static ESBase flush(Call call, int n) throws Exception {
        WriteStream writeStream = NativeFile.getWriteStream(call);
        try {
            writeStream.flush();
        }
        catch (IOException iOException) {
            return ESBoolean.FALSE;
        }
        return call.getArg(-1);
    }

    public static ESBase close(Call call, int n) throws Exception {
        WriteStream writeStream = NativeFile.getWriteStream(call);
        try {
            writeStream.close();
        }
        catch (IOException iOException) {
            return ESBoolean.FALSE;
        }
        return call.getArg(-1);
    }

    private NativeFile(String string, int n, int n2) {
        super(string, n2);
        this.n = n;
    }
}

