/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESClosure;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESString;
import com.caucho.es.ESWrapperException;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.Script;
import com.caucho.es.parser.Parser;
import java.io.IOException;

class NativeGlobal
extends Native {
    static final int EVAL = 2;
    static final int PARSE_INT = 3;
    static final int PARSE_FLOAT = 4;
    static final int ESCAPE = 5;
    static final int UNESCAPE = 6;
    static final int IS_NAN = 7;
    static final int IS_FINITE = 8;
    static final int PRINT = 9;
    static final int SYSTEM = 10;

    static void create(Global global) {
        NativeGlobal.put(global, "eval", 2, 1);
        NativeGlobal.put(global, "parseInt", 3, 2);
        NativeGlobal.put(global, "parseFloat", 4, 1);
        NativeGlobal.put(global, "escape", 5, 1);
        NativeGlobal.put(global, "unescape", 6, 1);
        NativeGlobal.put(global, "isNaN", 7, 1);
        NativeGlobal.put(global, "isFinite", 8, 1);
        NativeGlobal.put(global, "print", 9, 1);
        NativeGlobal.put(global, "system", 10, 1);
    }

    private static void put(Global global, String string, int n, int n2) {
        ESId eSId = ESId.intern(string);
        global.addProperty(eSId, new NativeGlobal(string, n, n2));
    }

    public ESBase call(Call call, int n) throws Exception {
        switch (this.n) {
            case 2: {
                return this.eval(call, n);
            }
            case 3: {
                return this.parseInt(call, n);
            }
            case 4: {
                if (n < 1) {
                    return ESNumber.NaN;
                }
                return ESNumber.create(ESString.parseFloat(call.getArg(0).toStr()));
            }
            case 5: {
                return NativeGlobal.escape(call, n);
            }
            case 6: {
                return NativeGlobal.unescape(call, n);
            }
            case 7: {
                if (n < 1) {
                    return ESBase.esUndefined;
                }
                return ESBoolean.create(Double.isNaN(call.getArg(0).toNum()));
            }
            case 8: {
                if (n < 1) {
                    return ESBase.esUndefined;
                }
                double d = call.getArg(0).toNum();
                if (Double.isNaN(d)) {
                    return ESBoolean.create(false);
                }
                if (d == Double.POSITIVE_INFINITY) {
                    return ESBoolean.create(false);
                }
                if (d == Double.NEGATIVE_INFINITY) {
                    return ESBoolean.create(false);
                }
                return ESBoolean.create(true);
            }
            case 9: {
                System.out.print(call.getArg(0).toStr().toString());
                return ESBase.esNull;
            }
            case 10: {
                String string = call.getArg(0).toStr().toString();
                String[] stringArray = new String[3];
                try {
                    stringArray[0] = "sh";
                    stringArray[1] = "-c";
                    stringArray[2] = string;
                    Process process = Runtime.getRuntime().exec(stringArray);
                    return ESNumber.create(process.waitFor());
                }
                catch (Exception exception) {
                    throw new ESWrapperException(exception);
                }
            }
        }
        throw new ESException("Unknown object function");
    }

    private ESBase eval(Call call, int n) throws Exception {
        if (n < 1) {
            return ESBase.esUndefined;
        }
        ESBase eSBase = call.getArg(0);
        if (!(eSBase instanceof ESString)) {
            return eSBase;
        }
        String string = eSBase.toString();
        Global global = Global.getGlobalProto();
        ESBase eSBase2 = call.getFunctionContext();
        Script script = null;
        try {
            script = Parser.parseEval(global, eSBase2, call.getGlobal(), string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ESClosure eSClosure = new ESClosure(ESId.intern("eval"), script, null, 2, new ESId[0], call.getGlobal());
        return eSClosure.call(call.caller, 0);
    }

    private ESBase parseInt(Call call, int n) throws Exception {
        if (n < 1) {
            return ESNumber.NaN;
        }
        ESString eSString = call.getArg(0).toStr();
        int n2 = eSString.length();
        int n3 = 0;
        while (n3 < n2 && Character.isSpaceChar(eSString.charAt(n3))) {
            ++n3;
        }
        int n4 = 1;
        if (n3 < n2 && eSString.charAt(n3) == '+') {
            ++n3;
        } else if (n3 < n2 && eSString.charAt(n3) == '-') {
            n4 = -1;
            ++n3;
        }
        int n5 = 0;
        if (n > 1 && (n5 = call.getArg(1).toInt32()) != 0) {
            if (n5 < 2 || n5 > 36) {
                return ESNumber.NaN;
            }
            if (n5 == 16 && n3 + 1 < n && eSString.charAt(n3) == '0' && (eSString.charAt(n3 + 1) == 'x' || eSString.charAt(n3 + 1) == 'X')) {
                n3 += 2;
            }
        }
        if (n5 == 0) {
            if (n3 >= n2) {
                n5 = 10;
            } else if (eSString.charAt(n3) != '0') {
                n5 = 10;
            } else if (n3 + 1 < n2 && (eSString.charAt(n3 + 1) == 'x' || eSString.charAt(n3 + 1) == 'X')) {
                n5 = 16;
                n3 += 2;
            } else {
                n5 = 8;
            }
        }
        long l = 0L;
        boolean bl = false;
        while (n3 < n2) {
            char c = eSString.charAt(n3);
            if (n5 <= 10 && '0' <= c && c <= 48 + n5 - 1) {
                l = (long)n5 * l + (long)eSString.charAt(n3) - 48L;
                bl = true;
            } else if (n5 > 10 && '0' <= c && c <= '9') {
                l = (long)n5 * l + (long)eSString.charAt(n3) - 48L;
                bl = true;
            } else if (n5 > 10 && 'a' <= c && c <= 97 + n5 - 11) {
                l = (long)n5 * l + (long)eSString.charAt(n3) - 97L + 10L;
                bl = true;
            } else {
                if (n5 <= 10 || 'A' > c || c > 65 + n5 - 11) break;
                l = (long)n5 * l + (long)eSString.charAt(n3) - 65L + 10L;
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            return ESNumber.create((double)n4 * (double)l);
        }
        return ESNumber.NaN;
    }

    static ESBase escape(Call call, int n) throws Exception {
        if (n < 1) {
            return ESBase.esUndefined;
        }
        ESString eSString = call.getArg(0).toStr();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < eSString.length()) {
            char c = eSString.charAt(n2);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '@' || c == '*' || c == '.' || c == '_' || c == '+' || c == '-' || c == '/') {
                stringBuffer.append(c);
            } else if (c < '\u0100') {
                stringBuffer.append('%');
                stringBuffer.append(Integer.toHexString(c >> 4));
                stringBuffer.append(Integer.toHexString(c & 0xF));
            } else {
                stringBuffer.append("%u");
                stringBuffer.append(Integer.toHexString(c >> 12));
                stringBuffer.append(Integer.toHexString(c >> 8 & 0xF));
                stringBuffer.append(Integer.toHexString(c >> 4 & 0xF));
                stringBuffer.append(Integer.toHexString(c & 0xF));
            }
            ++n2;
        }
        return ESString.create(stringBuffer.toString());
    }

    static ESBase unescape(Call call, int n) throws Exception {
        if (n < 1) {
            return ESBase.esUndefined;
        }
        ESString eSString = call.getArg(0).toStr();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < eSString.length()) {
            char c = eSString.charAt(n2);
            if (c == '%' && n2 + 2 < eSString.length()) {
                int n3 = 2;
                int n4 = 1;
                if (eSString.charAt(n2 + 1) == 'u') {
                    n3 = 4;
                    n4 = 2;
                }
                int n5 = 0;
                int n6 = 0;
                while (n6 < n3 && n2 + n6 + n4 < eSString.length()) {
                    c = eSString.charAt(n2 + n6 + n4);
                    if (c >= '0' && c <= '9') {
                        n5 = 16 * n5 + c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        n5 = 16 * n5 + c - 97 + 10;
                    } else {
                        if (c < 'A' || c > 'F') break;
                        n5 = 16 * n5 + c - 65 + 10;
                    }
                    ++n6;
                }
                if (n6 != n3) {
                    stringBuffer.append('%');
                } else {
                    stringBuffer.append((char)n5);
                    n2 += n3 + n4 - 1;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return ESString.create(stringBuffer.toString());
    }

    NativeGlobal(String string, int n, int n2) {
        super(string, n2);
        this.n = n;
    }
}

