/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.parser.BinaryExpr;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.BooleanBinaryExpr;
import com.caucho.es.parser.BooleanExpr;
import com.caucho.es.parser.CallExpr;
import com.caucho.es.parser.ConditionalExpr;
import com.caucho.es.parser.FieldExpr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.LiteralExpr;
import com.caucho.es.parser.ParseClass;
import com.caucho.es.parser.PlusExpr;
import com.caucho.es.parser.SpecialExpr;
import com.caucho.es.parser.UnaryExpr;
import java.io.IOException;

class Expr {
    protected static final int TYPE_UNKNOWN = 0;
    protected static final int TYPE_ES = 1;
    protected static final int TYPE_STRING = 2;
    protected static final int TYPE_NUMBER = 3;
    protected static final int TYPE_INTEGER = 4;
    protected static final int TYPE_BOOLEAN = 5;
    protected ParseClass cl;
    protected Block block;
    protected Function function;
    protected int type;
    protected boolean isTop;
    protected boolean noValue;
    private String filename;
    private int line;

    String getFilename() {
        return this.filename;
    }

    int getLine() {
        return this.line;
    }

    void killValue() {
        this.noValue = true;
    }

    void setTop() {
        this.noValue = true;
        this.isTop = true;
    }

    int getType() {
        return this.type;
    }

    boolean isSimple() {
        return false;
    }

    boolean isNumeric() {
        int n = this.getType();
        return n >= 3 && n <= 5;
    }

    boolean isNum() {
        int n = this.getType();
        return n == 3 || n == 4;
    }

    Expr setBoolean() {
        return new BooleanExpr(this.block, this);
    }

    Expr next(String string, Expr expr) throws ESException {
        return expr.assign(new SpecialExpr(this.block, 110, string));
    }

    Expr fieldReference(Expr expr) {
        return new FieldExpr(this.block, this, expr);
    }

    Expr fieldReference(ESId eSId) throws ESException {
        return new FieldExpr(this.block, this, new LiteralExpr(this.block, eSId));
    }

    Expr unaryOp(int n) {
        return new UnaryExpr(this.block, this, n);
    }

    Expr doVoid() {
        return new UnaryExpr(this.block, this, 118);
    }

    Expr typeof() {
        return new UnaryExpr(this.block, this, 116);
    }

    Expr delete() throws ESException {
        return BinaryExpr.create(this.block, this, new LiteralExpr(this.block, ESBoolean.TRUE), 44);
    }

    Expr assign(Expr expr) throws ESException {
        throw this.error("illegal left-hand-side of assignment");
    }

    CallExpr startCall() throws ESException {
        return new CallExpr(this.block, this, null, false);
    }

    CallExpr startNew() throws ESException {
        return new CallExpr(this.block, this, null, true);
    }

    Expr prefix(int n) throws ESException {
        return this.unaryOp(43).binaryOp(n, n, new LiteralExpr(this.block, ESNumber.create(1.0)));
    }

    Expr postfix(int n) {
        return this.unaryOp(43);
    }

    Expr binaryOp(int n, int n2, Expr expr) throws ESException {
        if (n != 61) {
            switch (n2) {
                case 60: 
                case 62: 
                case 271: 
                case 272: 
                case 273: 
                case 274: 
                case 275: 
                case 276: {
                    return BooleanBinaryExpr.create(this.block, this, expr, n2);
                }
                case 43: {
                    return PlusExpr.create(this.block, this, expr);
                }
            }
            return BinaryExpr.create(this.block, this, expr, n2);
        }
        if (n2 == 61) {
            return this.assign(expr);
        }
        return this.assign(this.binaryOp(n2, n2, expr));
    }

    Expr conditional(Expr expr, Expr expr2) {
        return new ConditionalExpr(this.block, this, expr, expr2);
    }

    void printExpr() throws IOException {
        this.print();
    }

    void print() throws IOException {
        switch (this.getType()) {
            case 3: {
                if (!this.noValue) {
                    this.cl.print("ESNumber.create(");
                }
                this.printNumImpl();
                if (this.noValue) break;
                this.cl.print(")");
                break;
            }
            case 4: {
                if (!this.noValue) {
                    this.cl.print("ESNumber.create(");
                }
                this.printInt32Impl();
                if (this.noValue) break;
                this.cl.print(")");
                break;
            }
            case 5: {
                if (!this.noValue) {
                    this.cl.print("(");
                }
                this.printBooleanImpl();
                if (this.noValue) break;
                this.cl.print("?ESBoolean.TRUE:ESBoolean.FALSE)");
                break;
            }
            case 2: {
                if (!this.noValue) {
                    this.cl.print("ESString.create(");
                }
                this.printStringImpl();
                this.cl.print(".close()");
                if (this.noValue) break;
                this.cl.print(")");
                break;
            }
            default: {
                this.printImpl();
            }
        }
        if (this.isTop) {
            this.cl.println(";");
        }
    }

    void printBoolean() throws IOException {
        switch (this.getType()) {
            case 3: {
                this.cl.print("(");
                this.printNumImpl();
                this.cl.print("!=0.0)");
                break;
            }
            case 4: {
                this.cl.print("(");
                this.printInt32Impl();
                this.cl.print("!=0)");
                break;
            }
            case 5: {
                this.printBooleanImpl();
                break;
            }
            default: {
                this.printImpl();
                this.cl.print(".toBoolean()");
            }
        }
        if (this.isTop) {
            this.cl.println(";");
        }
    }

    void printInt32() throws IOException {
        switch (this.getType()) {
            case 4: {
                this.printInt32Impl();
                break;
            }
            case 3: {
                this.cl.print("((int)");
                this.printNumImpl();
                this.cl.print(")");
                break;
            }
            case 5: {
                this.cl.print("(");
                this.printBooleanImpl();
                this.cl.print("?1:0)");
                break;
            }
            default: {
                this.printImpl();
                this.cl.print(".toInt32()");
            }
        }
    }

    void printNum() throws IOException {
        switch (this.getType()) {
            case 3: {
                this.printNumImpl();
                break;
            }
            case 4: {
                this.cl.print("((double)");
                this.printInt32Impl();
                this.cl.print(")");
                break;
            }
            case 5: {
                this.cl.print("(");
                this.printBooleanImpl();
                this.cl.print("?1.0:0.0)");
                break;
            }
            default: {
                this.printImpl();
                this.cl.print(".toNum()");
            }
        }
    }

    void printStr() throws IOException {
        this.print();
        this.cl.print(".toStr()");
    }

    void printString() throws IOException {
        switch (this.getType()) {
            case 4: {
                this.printInt32Impl();
                break;
            }
            case 5: {
                this.printBooleanImpl();
                break;
            }
            case 2: {
                this.printStringImpl();
                break;
            }
            default: {
                this.print();
                this.cl.print(".valueOf()");
                break;
            }
        }
    }

    void printImpl() throws IOException {
        throw new RuntimeException("" + this);
    }

    void printBooleanImpl() throws IOException {
        throw new RuntimeException("" + this);
    }

    void printNumImpl() throws IOException {
        throw new RuntimeException();
    }

    void printInt32Impl() throws IOException {
        throw new RuntimeException();
    }

    void printStringImpl() throws IOException {
        throw new RuntimeException("no string impl for " + this.getClass());
    }

    void printLiteral(ESBase eSBase) throws IOException {
        this.cl.printLiteral(eSBase);
    }

    void exprStatement(Function function) throws ESException {
    }

    private ESException error(String string) {
        return this.block.error(string);
    }

    Expr(Block block) {
        this.block = block;
        this.function = block.function;
        this.cl = this.function.cl;
        this.filename = block.getFilename();
        this.line = block.getLine();
        this.type = 0;
    }
}

