/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.eswrap.com.caucho.vfs;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.eswrap.com.caucho.vfs.PathEcmaWrap;
import com.caucho.util.Exit;
import com.caucho.util.ExitListener;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class PathEcmaWrap {
    private static ExitListener exitStream = new 1();
    private static ExitListener exitInputStream = new 2();
    private static ExitListener exitOutputStream = new 3();

    public static ReadStream openRead(Path path) throws IOException {
        ReadStream readStream = path.openRead();
        Exit.addExit(exitInputStream, readStream);
        return readStream;
    }

    public static WriteStream openWrite(Path path) throws IOException {
        WriteStream writeStream = path.openWrite();
        Exit.addExit(exitOutputStream, writeStream);
        return writeStream;
    }

    public static ReadWritePair openReadWrite(Path path) throws IOException {
        ReadWritePair readWritePair = path.openReadWrite();
        Exit.addExit(exitStream, readWritePair);
        return readWritePair;
    }

    public static WriteStream openAppend(Path path) throws IOException {
        WriteStream writeStream = path.openAppend();
        Exit.addExit(exitOutputStream, writeStream);
        return writeStream;
    }

    public static boolean remove(Path path) throws IOException {
        return path.remove();
    }

    public static boolean renameTo(Path path, ESBase eSBase) throws IOException {
        Object object;
        try {
            object = eSBase.toJavaObject();
        }
        catch (ESException eSException) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Path) {
            return path.renameTo((Path)object);
        }
        Path path2 = path.getParent().lookup(object.toString());
        return path.renameTo(path2);
    }

    public static Path call(Path path, String string) throws IOException {
        Path path2 = path.lookup(string);
        return path2;
    }

    public static Path call(Path path) throws IOException {
        return path;
    }

    public static Iterator keys(Path path) {
        try {
            return path.iterator();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void write(Path path, Call call, int n) throws Exception {
        WriteStream writeStream = path.openWrite();
        try {
            int n2 = 0;
            while (n2 < n) {
                String string = call.getArgString(n2, n);
                writeStream.print(string);
                ++n2;
            }
        }
        finally {
            Object var5_6 = null;
            writeStream.close();
        }
    }

    public static void writeln(Path path, Call call, int n) throws Exception {
        WriteStream writeStream = path.openWrite();
        try {
            int n2 = 0;
            while (n2 < n) {
                String string = call.getArgString(n2, n);
                writeStream.print(string);
                ++n2;
            }
            writeStream.print('\n');
        }
        finally {
            Object var5_6 = null;
            writeStream.close();
        }
    }

    public static void writeStream(Path path, InputStream inputStream) throws Exception {
        WriteStream writeStream = path.openWrite();
        try {
            writeStream.writeStream(inputStream);
        }
        finally {
            Object var4_3 = null;
            writeStream.close();
        }
    }

    public static void writeFile(Path path, Path path2) throws Exception {
        WriteStream writeStream = path.openWrite();
        try {
            writeStream.writeFile(path2);
        }
        finally {
            Object var4_3 = null;
            writeStream.close();
        }
    }

    public static void append(Path path, Call call, int n) throws Exception {
        WriteStream writeStream = path.openAppend();
        try {
            int n2 = 0;
            while (n2 < n) {
                String string = call.getArgString(n2, n);
                writeStream.print(string);
                ++n2;
            }
        }
        finally {
            Object var5_6 = null;
            writeStream.close();
        }
    }

    public static void appendln(Path path, Call call, int n) throws Exception {
        WriteStream writeStream = path.openAppend();
        try {
            int n2 = 0;
            while (n2 < n) {
                String string = call.getArgString(n2, n);
                writeStream.print(string);
                ++n2;
            }
            writeStream.print('\n');
        }
        finally {
            Object var5_6 = null;
            writeStream.close();
        }
    }

    public static void appendStream(Path path, InputStream inputStream) throws Exception {
        WriteStream writeStream = path.openAppend();
        try {
            writeStream.writeStream(inputStream);
        }
        finally {
            Object var4_3 = null;
            writeStream.close();
        }
    }

    public static void appendFile(Path path, Path path2) throws Exception {
        WriteStream writeStream = path.openAppend();
        try {
            writeStream.writeFile(path2);
        }
        finally {
            Object var4_3 = null;
            writeStream.close();
        }
    }
}

