/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.JavaCompiler;
import com.caucho.jsp.Page;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Http;
import com.caucho.util.Alarm;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletContext;

public abstract class PageManager {
    private static WriteStream dbg = LogStream.open("/caucho.com/jsp");
    private CauchoApplication application;
    private HashMap cache = new HashMap();
    private long updateInterval = 1000L;
    private boolean isAdapter;

    CauchoApplication getApplication() {
        return this.application;
    }

    Page getPage(CauchoRequest cauchoRequest, CauchoResponse cauchoResponse) throws Exception {
        Cache cache = this.getCacheEntry(cauchoRequest);
        Page page = null;
        if (cache == null) {
            cauchoResponse.sendError(404);
            return null;
        }
        Cache cache2 = cache;
        synchronized (cache2) {
            Cache cache3 = cache.getSubCache(cauchoRequest);
            if (cache3 != null) {
                if (!cache3.isModified()) {
                    Page page2 = cache3.getPage();
                    Object var6_8 = null;
                    return page2;
                }
                cache3.clear();
            }
            if (dbg.canWrite()) {
                dbg.println("uri:" + cauchoRequest.getPageURI() + "(cp:" + this.application.getContextPath() + ",sp:" + cauchoRequest.getPageServletPath() + ",pi:" + cauchoRequest.getPagePathInfo() + ",app:" + this.application.getAppDir() + ") -> " + cache.getPath());
            }
            if ((page = this.getPage(cache.getPath(), this.application.getContextPath() + cache.getName(), cauchoRequest, cauchoResponse)) != null) {
                cache.setPage(page, this.updateInterval);
            }
        }
        return page;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cache getCacheEntry(CauchoRequest cauchoRequest) {
        String string = cauchoRequest.getPageServletPath();
        if (string == null) {
            string = "/";
        }
        boolean bl = true;
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            Cache cache = (Cache)this.cache.get(string);
            if (cache != null) {
                return cache;
            }
            String string2 = cauchoRequest.getPageURI();
            cache = (Cache)this.cache.get(string2);
            if (cache != null) {
                return cache;
            }
            Path path = this.application.getAppDir();
            String string3 = (String)cauchoRequest.getAttribute("caucho.jsp.jsp-file");
            if (string3 != null) {
                cauchoRequest.removeAttribute("caucho.jsp.jsp-file");
                Path path2 = this.getPagePath(string3, bl);
                if (path2 == null) return null;
                if (!path2.isFile()) return null;
                cache = (Cache)this.cache.get(string3);
                if (cache == null) {
                    cache = new Cache(string3, path2);
                    this.cache.put(string3, cache);
                }
                this.cache.put(string, cache);
                return cache;
            }
            Path path3 = this.getPagePath(string, bl);
            if (path3 != null) {
                cache = new Cache(string, path3);
                this.cache.put(string, cache);
                return cache;
            }
            String string4 = cauchoRequest.getPagePathInfo();
            if (string4 == null) {
                return null;
            }
            String string5 = this.application.getRealPath(string + string4);
            path3 = path.lookupNative(string5);
            if (path3.isFile()) {
                cache = new Cache(string2, path3);
                this.cache.put(string2, cache);
                return cache;
            }
            string5 = this.application.getRealPath(string4);
            path3 = path.lookupNative(string5);
            if (path3.isFile()) {
                cache = new Cache(string2, path3);
                this.cache.put(string2, cache);
                return cache;
            }
            string5 = cauchoRequest.getPathTranslated();
            path3 = path.lookupNative(string5);
            if (!path3.isFile()) return null;
            cache = new Cache(string2, path3);
            this.cache.put(string2, cache);
            return cache;
        }
    }

    private Path getPagePath(String string, boolean bl) {
        String string2;
        URL uRL;
        String string3;
        Path path = this.application.getAppDir();
        Path path2 = path.lookupNative(string3 = this.application.getRealPath(string));
        if (path2.isFile() && path2.canRead()) {
            return path2;
        }
        if (!bl) {
            return null;
        }
        DynamicClassLoader dynamicClassLoader = this.application.getClassLoader();
        if (dynamicClassLoader != null) {
            uRL = this.application.getClassLoader().getResource(string);
            string2 = uRL != null ? uRL.toString() : null;
            path2 = null;
            if (uRL != null && (string2.endsWith(".jar") || string2.endsWith(".zip"))) {
                path2 = new JarPath(Vfs.lookup(uRL.toString())).lookup(string);
            } else if (uRL != null) {
                path2 = Vfs.lookup(uRL.toString());
            }
            if (path2 != null && path2.isFile() && path2.canRead()) {
                return path2;
            }
        }
        string2 = (uRL = ClassLoader.getSystemResource(string)) != null ? uRL.toString() : null;
        path2 = null;
        if (uRL != null && (string2.endsWith(".jar") || string2.endsWith(".zip"))) {
            path2 = new JarPath(Vfs.lookup(uRL.toString())).lookup(string);
        } else if (uRL != null) {
            path2 = Vfs.lookup(uRL.toString());
        }
        if (path2 != null && path2.isFile() && path2.canRead()) {
            return path2;
        }
        return null;
    }

    private Page getPage(Path path, String string, CauchoRequest cauchoRequest, CauchoResponse cauchoResponse) throws Exception {
        String string2;
        String string3;
        int n;
        Path path2 = this.getApplication().getAppDir();
        Path path3 = path.getParent();
        string3 = string != null ? ((n = (string3 = string.substring((string2 = this.getApplication().getContextPath()).length())).lastIndexOf(47)) <= 0 ? "/" : string3.substring(0, n + 1)) : "/";
        string2 = PageManager.uriToClassName(this.getApplication(), string);
        if (!path.canRead() || path.isDirectory()) {
            if (cauchoRequest.getRequestDepth(0) > 1) {
                throw new FileNotFoundException(string);
            }
            cauchoResponse.sendError(404);
            return null;
        }
        return this.createPage(path, string, string2, string3, cauchoRequest);
    }

    static String uriToClassName(CauchoApplication cauchoApplication, String string) {
        String string2;
        String string3 = string2 = cauchoApplication == null ? null : cauchoApplication.getHost();
        if (string2 != null && !string2.equals("")) {
            string = cauchoApplication.getHost() + "_" + string;
        }
        return JavaCompiler.mangleName(string);
    }

    abstract Page createPage(Path var1, String var2, String var3, String var4, CauchoRequest var5) throws Exception;

    synchronized void destroy() {
        Iterator iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            Cache cache = (Cache)iterator.next();
            Page page = cache.getPage();
            cache.setPage(null, 0L);
            if (page == null) continue;
            page.destroy();
        }
        this.cache.clear();
    }

    PageManager(ServletContext servletContext) {
        this.application = servletContext instanceof CauchoApplication ? (CauchoApplication)servletContext : Http.createApplicationAdapter(servletContext);
        RegistryNode registryNode = this.application.getRegistry();
        long l = 15000L;
        if (registryNode != null) {
            l = registryNode.getPeriod("class-update-interval", 15000L);
        }
        if (l < 0L) {
            l = 0L;
        }
        this.updateInterval = l;
    }

    static class Cache {
        Path path;
        String cachePath;
        Page page;
        long lastUpdateCheck;
        long updateInterval;
        boolean hasSubCache;
        boolean isAdapter;
        HashMap subCache;

        String getName() {
            return this.cachePath;
        }

        void setPage(Page page, long l) {
            this.page = page;
            this.updateInterval = l;
            this.lastUpdateCheck = Alarm.getCurrentTime();
        }

        Cache getSubCache(CauchoRequest cauchoRequest) {
            if (this.hasSubCache) {
                return (Cache)this.subCache.get(cauchoRequest.getMedia());
            }
            return this;
        }

        boolean isModified() {
            if (this.page == null) {
                return true;
            }
            long l = Alarm.getCurrentTime();
            if (this.lastUpdateCheck + this.updateInterval > l) {
                return false;
            }
            this.lastUpdateCheck = l;
            return this.page._caucho_isModified();
        }

        boolean isAdapter() {
            return this.isAdapter;
        }

        void setAdapter(boolean bl) {
            this.isAdapter = bl;
        }

        void clear() {
            this.page = null;
            this.updateInterval = 0L;
            this.lastUpdateCheck = 0L;
        }

        Path getPath() {
            return this.path;
        }

        Page getPage() {
            return this.page;
        }

        Cache(String string, Path path) {
            this.path = path;
            path.setUserPath(string);
            this.cachePath = string;
        }
    }
}

