/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server;

import com.caucho.util.Alarm;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.net.InetAddress;

public abstract class Connection {
    private static int connectionCount;
    private int connectionId = connectionCount++;
    private long accessTime;
    private boolean isIdle;

    public int getId() {
        return this.connectionId;
    }

    public abstract ReadStream getReadStream() throws IOException;

    public abstract WriteStream getWriteStream() throws IOException;

    public abstract InetAddress getLocalAddress();

    public abstract int getLocalPort();

    public abstract InetAddress getRemoteAddress();

    public abstract int getRemotePort();

    public void setAccessTime(long l) {
        this.accessTime = l;
    }

    public void resetTimeout() {
        this.accessTime = Alarm.getCurrentTime();
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setIdle() {
        this.isIdle = true;
    }

    public boolean isIdle() {
        return this.isIdle;
    }

    public void setActive() {
        this.isIdle = false;
    }

    public boolean allocateKeepalive() {
        return false;
    }

    public boolean isInterrupted() {
        return false;
    }

    protected Connection() {
    }
}

