/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server;

import com.caucho.server.Connection;
import com.caucho.server.ServerRequest;
import com.caucho.server.TcpServer;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CpuUsage;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class TcpConnection
extends Connection
implements Runnable {
    private static WriteStream dbg = LogStream.open("/caucho.com/tcp-server");
    public static int connOpened;
    public static int connClosed;
    private Thread thread;
    private TcpServer server;
    private ServerRequest request;
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private VfsStream streamImpl;
    private ReadStream readStream;
    private WriteStream writeStream;
    private int interruptCount;
    private boolean isListening;
    private boolean isClosed;
    private boolean isKeepalive;
    private CpuUsage cpuUsage;
    private CpuUsage baseUsage;
    private long lastUsageTime;

    void setThread(Thread thread) {
        this.thread = thread;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block42: {
            this.thread = Thread.currentThread();
            this.isClosed = false;
            this.isKeepalive = false;
            try {
                try {
                    if (true) ** GOTO lbl110
                    do {
                        block36: {
                            block35: {
                                block34: {
                                    ++TcpConnection.connOpened;
                                    this.is = null;
                                    this.os = null;
                                    this.is = this.socket.getInputStream();
                                    this.os = this.socket.getOutputStream();
                                    try {
                                        this.streamImpl.init(this.is, this.os);
                                        this.writeStream.init(this.streamImpl);
                                        this.readStream.init(this.streamImpl, this.writeStream);
                                        var7_6 = CauchoSystem.getStaticClassLoader();
                                        CauchoSystem.setContextClassLoader(var7_6);
                                        this.request.handleConnection(this);
                                    }
                                    finally {
                                        var6_5 = null;
                                        this.writeStream.close();
                                        this.readStream.close();
                                    }
                                    var4_1 = null;
                                    if (this.is == null) break block34;
                                    try {
                                        this.readStream.setDisableClose(false);
                                        this.readStream.close();
                                        this.is.close();
                                    }
                                    catch (Exception var5_2) {
                                        if (!TcpConnection.dbg.canWrite()) break block34;
                                        TcpConnection.dbg.log(var5_2);
                                    }
                                }
                                if (this.os != null) {
                                    try {
                                        this.writeStream.setDisableClose(false);
                                        this.writeStream.close();
                                        this.os.close();
                                    }
                                    catch (Exception var5_2) {
                                        if (!TcpConnection.dbg.canWrite()) break block35;
                                        TcpConnection.dbg.log(var5_2);
                                    }
                                }
                            }
                            this.socket.close();
                            ++TcpConnection.connClosed;
                            {
                                break block36;
                                catch (IOException var5_4) {
                                    block38: {
                                        block37: {
                                            this.isClosed = true;
                                            if (TcpConnection.dbg.canWrite()) {
                                                TcpConnection.dbg.log("[" + this.getId() + "] " + var5_4);
                                                TcpConnection.dbg.log(var5_4);
                                            }
                                            var4_1 = null;
                                            if (this.is != null) {
                                                try {
                                                    this.readStream.setDisableClose(false);
                                                    this.readStream.close();
                                                    this.is.close();
                                                }
                                                catch (Exception var5_2) {
                                                    if (!TcpConnection.dbg.canWrite()) break block37;
                                                    TcpConnection.dbg.log(var5_2);
                                                }
                                            }
                                        }
                                        if (this.os != null) {
                                            try {
                                                this.writeStream.setDisableClose(false);
                                                this.writeStream.close();
                                                this.os.close();
                                            }
                                            catch (Exception var5_2) {
                                                if (!TcpConnection.dbg.canWrite()) break block38;
                                                TcpConnection.dbg.log(var5_2);
                                            }
                                        }
                                    }
                                    this.socket.close();
                                    ++TcpConnection.connClosed;
                                }
                            }
                            catch (Throwable var3_7) {
                                block40: {
                                    block39: {
                                        var4_1 = null;
                                        if (this.is != null) {
                                            try {
                                                this.readStream.setDisableClose(false);
                                                this.readStream.close();
                                                this.is.close();
                                            }
                                            catch (Exception var5_2) {
                                                if (!TcpConnection.dbg.canWrite()) break block39;
                                                TcpConnection.dbg.log(var5_2);
                                            }
                                        }
                                    }
                                    if (this.os != null) {
                                        try {
                                            this.writeStream.setDisableClose(false);
                                            this.writeStream.close();
                                            this.os.close();
                                        }
                                        catch (Exception var5_2) {
                                            if (!TcpConnection.dbg.canWrite()) break block40;
                                            TcpConnection.dbg.log(var5_2);
                                        }
                                    }
                                }
                                this.socket.close();
                                ++TcpConnection.connClosed;
                                throw var3_7;
                            }
                        }
                        if (this.isClosed) break;
                    } while ((this.socket = this.accept()) != null);
                }
                catch (OutOfMemoryError var3_8) {
                    if (TcpConnection.dbg.canWrite()) {
                        TcpConnection.dbg.log(var3_8);
                    }
                    this.server.close();
                    var2_11 = null;
                    this.thread = null;
                    if (this.isKeepalive) {
                        this.isKeepalive = false;
                        this.server.freeKeepalive();
                    }
                    this.server.stopConnection(this);
                    break block42;
                }
                catch (Throwable var3_9) {
                    if (TcpConnection.dbg.canWrite()) {
                        TcpConnection.dbg.log(var3_9);
                    }
                    this.isClosed = true;
                    var2_12 = null;
                    this.thread = null;
                    if (this.isKeepalive) {
                        this.isKeepalive = false;
                        this.server.freeKeepalive();
                    }
                    this.server.stopConnection(this);
                }
                var2_10 = null;
                this.thread = null;
                if (this.isKeepalive) {
                    this.isKeepalive = false;
                    this.server.freeKeepalive();
                }
                this.server.stopConnection(this);
            }
            catch (Throwable var1_14) {
                var2_13 = null;
                this.thread = null;
                if (this.isKeepalive) {
                    this.isKeepalive = false;
                    this.server.freeKeepalive();
                }
                this.server.stopConnection(this);
                throw var1_14;
            }
        }
    }

    private Socket accept() {
        super.setIdle();
        if (this.isKeepalive) {
            this.isKeepalive = false;
            this.server.freeKeepalive();
        }
        this.interruptCount = 0;
        this.isListening = true;
        this.socket = null;
        this.setAccessTime(-1L);
        long l = Alarm.getCurrentTime();
        if (this.lastUsageTime + 5000L < l) {
            this.lastUsageTime = l;
            this.cpuUsage.update(l);
        }
        Socket socket = this.server.accept(this);
        l = Alarm.getCurrentTime();
        this.isListening = false;
        this.setAccessTime(l);
        return socket;
    }

    public boolean allocateKeepalive() {
        this.isKeepalive = this.interruptCount == 0 && this.server.allocateKeepalive();
        return this.isKeepalive;
    }

    public void setActive() {
        super.setActive();
        if (this.isKeepalive) {
            this.isKeepalive = false;
            this.server.freeKeepalive();
        }
    }

    void setSocket(Socket socket) throws IOException {
        if (socket != null) {
            this.is = socket.getInputStream();
            this.os = socket.getOutputStream();
        }
        this.socket = socket;
    }

    Socket getSocket() {
        return this.socket;
    }

    boolean isListening() {
        return this.isListening;
    }

    void updateUsage(CpuUsage cpuUsage) {
        cpuUsage.add(this.baseUsage, this.cpuUsage);
    }

    void interrupt() {
        Thread thread = this.getThread();
        this.isClosed = true;
        if (thread != null && thread.isAlive()) {
            Closeable closeable;
            if (!thread.isInterrupted()) {
                thread.interrupt();
                if (dbg.canWrite()) {
                    dbg.log("timeout: " + thread + " interrupt " + this.interruptCount);
                }
            }
            ++this.interruptCount;
            if (this.interruptCount >= 4) {
                if (dbg.canWrite()) {
                    dbg.log("timeout input: " + thread + " interrupt " + this.interruptCount);
                }
                try {
                    if (this.is != null) {
                        closeable = this.is;
                        this.is = null;
                        ((InputStream)closeable).close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.interruptCount >= 6) {
                if (dbg.canWrite()) {
                    dbg.log("timeout socket: " + thread + " interrupt " + this.interruptCount);
                }
                try {
                    if (this.os != null) {
                        closeable = this.os;
                        this.os = null;
                        ((OutputStream)closeable).close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.interruptCount > 8) {
                if (dbg.canWrite()) {
                    dbg.log("timeout stop: " + thread + " interrupt " + this.interruptCount);
                }
                thread.stop();
            }
        }
    }

    int getInterrupts() {
        return this.interruptCount;
    }

    void setClosed() {
    }

    boolean isClosed() {
        return this.isClosed;
    }

    public boolean isInterrupted() {
        return this.interruptCount > 0;
    }

    public ReadStream getReadStream() throws IOException {
        return this.readStream;
    }

    public WriteStream getWriteStream() throws IOException {
        return this.writeStream;
    }

    public InetAddress getLocalAddress() {
        try {
            return this.socket.getLocalAddress();
        }
        catch (Exception exception) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (Exception exception2) {
                try {
                    return InetAddress.getByName("127.0.0.1");
                }
                catch (Exception exception3) {
                    return null;
                }
            }
        }
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this.socket.getInetAddress();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }

    Thread getThread() {
        return this.thread;
    }

    TcpConnection(TcpServer tcpServer, ServerRequest serverRequest) {
        this.server = tcpServer;
        this.request = serverRequest;
        this.readStream = new ReadStream();
        this.writeStream = new WriteStream();
        this.streamImpl = new VfsStream(null, null);
        this.cpuUsage = CpuUsage.create();
        this.baseUsage = CpuUsage.create();
    }
}

