/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server;

import com.caucho.server.Server;
import com.caucho.server.ServerStat;
import com.caucho.server.TcpConnection;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CpuUsage;
import com.caucho.util.Cron;
import com.caucho.util.CronListener;
import com.caucho.util.FreeList;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.AbstractCollection;
import java.util.ArrayList;

public class TcpServer
implements AlarmListener,
CronListener,
Runnable {
    private static WriteStream dbg = LogStream.open("/caucho.com/tcp-server");
    private static long MS_PER_MINUTE = 60000L;
    private static long MS_PER_HOUR = 60L * MS_PER_MINUTE;
    private static long MS_PER_DAY = 24L * MS_PER_HOUR;
    private Server server;
    private ServerSocket serverSocket;
    private FreeList freeConnections = new FreeList(8);
    private int connectionMin;
    private int connectionMax;
    private int connectionMaxKeepalive;
    private ArrayList connections;
    private ArrayList connectionInterrupts;
    private int connectionCount;
    private int connectionKeepalive;
    private int connectionListen;
    private Socket[] socketQueue;
    private int queueHead;
    private int queueTail;
    private Thread thread;
    private boolean acceptIsBlocked;
    private long connectionTimeout;
    private long reaperInterval;
    private long timerInterval;
    private Alarm alarm;
    private Cron cron;
    private boolean isClosed;
    private boolean isDead;
    private boolean allowExit;
    private long threadInterval = 5000L;
    private long lastReaper;
    private CpuUsage baseUsage;
    private CpuUsage cpuUsage;
    private CpuUsage sumUsage;
    private ServerStat minuteStat;
    private ServerStat hourStat;
    private ServerStat dayStat;
    private long slowThreadTime = 120000L;
    private int slowThreadCount;
    private long statCount;
    private long activeThreadCount;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                block17: while (!this.isClosed) {
                    var3_1 = null;
                    try {
                        var3_1 = this.serverSocket.accept();
                        var3_1.setTcpNoDelay(true);
                        var4_5 = this.socketQueue;
                        synchronized (var4_5) {
                            var6_8 = (this.queueTail + 1) % this.socketQueue.length;
                            while (true) {
                                if (var6_8 != this.queueHead) {
                                    this.socketQueue[this.queueTail] = var3_1;
                                    this.queueTail = var6_8;
                                    this.socketQueue.notify();
                                    continue block17;
                                }
                                try {
                                    this.acceptIsBlocked = true;
                                    this.socketQueue.wait();
                                }
                                catch (Exception var7_9) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    catch (Exception var4_6) {
                        try {
                            if (var3_1 != null) {
                                var3_1.close();
                            }
                        }
                        catch (Exception var5_7) {
                            // empty catch block
                        }
                        if (!TcpServer.dbg.canWrite()) continue;
                        TcpServer.dbg.log(var4_6);
                    }
                }
            }
            catch (Throwable var3_2) {
                if (TcpServer.dbg.canWrite()) {
                    TcpServer.dbg.log(var3_2);
                }
                var2_11 = null;
                this.isClosed = true;
                try {
                    if (this.serverSocket == null) return;
                    this.serverSocket.close();
                    return;
                }
                catch (IOException var3_3) {
                    return;
                }
            }
            var2_10 = null;
            this.isClosed = true;
        }
        catch (Throwable var1_13) {
            var2_12 = null;
            this.isClosed = true;
            ** try [egrp 6[TRYBLOCK] [6 : 193->210)] { 
lbl58:
            // 1 sources

            if (this.serverSocket == null) throw var1_13;
            this.serverSocket.close();
            throw var1_13;
lbl61:
            // 1 sources

            catch (IOException var3_4) {
                // empty catch block
            }
            throw var1_13;
        }
        try {}
        catch (IOException var3_1) {}
        if (this.serverSocket == null) return;
        this.serverSocket.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Socket accept(TcpConnection tcpConnection) {
        while (!this.isClosed) {
            if (tcpConnection.isInterrupted()) return null;
            if (tcpConnection.isClosed()) {
                return null;
            }
            Socket[] socketArray = this.socketQueue;
            synchronized (socketArray) {
                if (this.queueHead != this.queueTail) {
                    Socket socket = this.socketQueue[this.queueHead];
                    this.socketQueue[this.queueHead] = null;
                    this.queueHead = (this.queueHead + 1) % this.socketQueue.length;
                    if (!this.acceptIsBlocked) return socket;
                    this.acceptIsBlocked = false;
                    this.socketQueue.notifyAll();
                    return socket;
                }
                if (this.connectionListen >= this.connectionMin && this.allowExit) {
                    this.allowExit = false;
                    return null;
                }
                this.allowExit = false;
                ++this.connectionListen;
                try {
                    this.socketQueue.wait(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --this.connectionListen;
            }
        }
        return null;
    }

    boolean allocateKeepalive() {
        boolean bl = false;
        Socket[] socketArray = this.socketQueue;
        synchronized (socketArray) {
            if (this.connectionMaxKeepalive <= this.connectionKeepalive) {
                boolean bl2 = false;
                Object var3_4 = null;
                return bl2;
            }
            ++this.connectionKeepalive;
            if (this.connectionListen == 0 && this.connectionCount < this.connectionMax) {
                bl = true;
                ++this.connectionCount;
            }
        }
        if (bl) {
            this.startConnection();
        }
        return true;
    }

    void freeKeepalive() {
        Socket[] socketArray = this.socketQueue;
        synchronized (socketArray) {
            --this.connectionKeepalive;
        }
    }

    private void startConnection() {
        TcpConnection tcpConnection = (TcpConnection)this.freeConnections.allocate();
        if (tcpConnection == null) {
            tcpConnection = new TcpConnection(this, this.server.createRequest());
        }
        Thread thread = new Thread((Runnable)tcpConnection, "tcpConnection-" + tcpConnection.getId());
        thread.setDaemon(true);
        tcpConnection.setThread(thread);
        thread.start();
        long l = Alarm.getCurrentTime();
        TcpServer tcpServer = this;
        synchronized (tcpServer) {
            this.connections.add(tcpConnection);
        }
        if (dbg.canWrite()) {
            dbg.log("start connection[" + tcpConnection.getId() + "] listen:" + this.connectionListen + " keepalive:" + this.connectionKeepalive + " total:" + this.connectionCount + " " + tcpConnection.getThread());
        }
    }

    void stopConnection(TcpConnection tcpConnection) {
        if (dbg.canWrite()) {
            dbg.log("stop connection[" + tcpConnection.getId() + "] listen:" + this.connectionListen + " keepalive:" + this.connectionKeepalive + " total: " + this.connectionCount + " " + tcpConnection.getThread());
        }
        TcpServer tcpServer = this;
        synchronized (tcpServer) {
            --this.connectionCount;
            ((AbstractCollection)this.connections).remove(tcpConnection);
        }
        this.freeConnections.free(tcpConnection);
    }

    public boolean isDead() {
        return this.isClosed || this.connectionCount <= 0;
    }

    private void reapIdle() {
        int n = 0;
        while (n < this.connections.size()) {
            TcpConnection tcpConnection = (TcpConnection)this.connections.get(n);
            if (tcpConnection.isIdle()) {
                tcpConnection.interrupt();
            }
            ++n;
        }
    }

    public void handleAlarm(Alarm alarm) {
        block3: {
            long l = Alarm.getCurrentTime();
            try {
                this.timeout(l);
            }
            catch (Throwable throwable) {
                if (!dbg.canWrite()) break block3;
                dbg.log(throwable);
            }
        }
        if (!this.isClosed) {
            alarm.queue(1000L);
        }
    }

    public void handleCron(Cron cron) {
        block3: {
            long l = Alarm.getCurrentTime();
            try {
                this.server.cron(l);
            }
            catch (Throwable throwable) {
                if (!dbg.canWrite()) break block3;
                dbg.log(throwable);
            }
        }
        if (!this.isClosed) {
            this.cron.queue();
        }
    }

    public void timeout(long l) {
        int n;
        boolean bl;
        boolean bl2;
        boolean bl3 = false;
        if (this.baseUsage == null) {
            this.baseUsage = CpuUsage.create();
            this.cpuUsage = CpuUsage.create();
            this.sumUsage = CpuUsage.create();
            this.minuteStat = new ServerStat();
            this.hourStat = new ServerStat();
            this.dayStat = new ServerStat();
        }
        boolean bl4 = bl2 = l / MS_PER_MINUTE > this.minuteStat.getTime() / MS_PER_MINUTE;
        if (bl2) {
            this.sumUsage.clear();
            this.cpuUsage.update(l);
            this.sumUsage.add(this.baseUsage, this.cpuUsage);
        }
        boolean bl5 = bl = this.lastReaper + this.reaperInterval < l;
        if (bl) {
            this.lastReaper = l;
        }
        int n2 = 0;
        int n3 = this.connectionListen;
        int n4 = this.connectionKeepalive;
        int n5 = this.connectionCount;
        this.connectionInterrupts.clear();
        this.slowThreadCount = 0;
        TcpServer tcpServer = this;
        synchronized (tcpServer) {
            n = this.connections.size();
            int n6 = 0;
            while (n6 < n) {
                TcpConnection tcpConnection = (TcpConnection)this.connections.get(n6);
                long l2 = tcpConnection.getAccessTime();
                int n7 = tcpConnection.getInterrupts();
                if (l2 > 0L && l - l2 > this.slowThreadTime) {
                    ++this.slowThreadCount;
                }
                if (this.connectionTimeout > 0L && bl && l2 > 0L && l2 + this.connectionTimeout * (long)(n7 + 1) < l) {
                    this.connectionInterrupts.add(tcpConnection);
                }
                if (!tcpConnection.isListening() && tcpConnection.isIdle()) {
                    ++n2;
                }
                if (bl2) {
                    tcpConnection.updateUsage(this.sumUsage);
                }
                ++n6;
            }
            if (this.connectionListen < this.connectionMin && this.connectionCount < this.connectionMax) {
                ++this.connectionCount;
                bl3 = true;
            } else if (this.connectionListen > this.connectionMin) {
                this.allowExit = true;
            }
        }
        n = 0;
        while (n < this.connectionInterrupts.size()) {
            TcpConnection tcpConnection = (TcpConnection)this.connectionInterrupts.get(n);
            tcpConnection.interrupt();
            ++n;
        }
        if (bl3) {
            this.startConnection();
        }
        ++this.statCount;
        n = n5 - n3 - n2;
        this.activeThreadCount += (long)n;
        if (bl2) {
            this.minuteStat.update(this.sumUsage, this.statCount, this.activeThreadCount);
            if (l / MS_PER_HOUR > this.hourStat.getTime() / MS_PER_HOUR) {
                this.hourStat.update(this.sumUsage, this.statCount, this.activeThreadCount);
            }
            if (l / MS_PER_DAY > this.dayStat.getTime() / MS_PER_DAY) {
                this.dayStat.update(this.sumUsage, this.statCount, this.activeThreadCount);
            }
        }
        if (bl) {
            this.lastReaper = l;
            this.server.timeout(l);
        }
    }

    public void close() {
        Object object;
        this.isClosed = true;
        this.alarm.dequeue();
        this.cron.dequeue();
        if (dbg.canWrite()) {
            dbg.log("closing");
        }
        if (this.serverSocket != null) {
            int n = this.serverSocket.getLocalPort();
            try {
                object = new Socket("localhost", n);
                ((Socket)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            this.serverSocket = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 0;
        while (n < 30 && this.connectionCount > 0) {
            object = null;
            TcpServer tcpServer = this;
            synchronized (tcpServer) {
                int n2 = 0;
                while (n2 < this.connections.size()) {
                    TcpConnection tcpConnection = (TcpConnection)this.connections.get(n2);
                    if (!tcpConnection.isIdle() && !tcpConnection.isListening() && tcpConnection.getThread() != null) {
                        object = tcpConnection;
                    }
                    ++n2;
                }
            }
            if (object == null) {
                return;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public ServerStat getMinuteStat() {
        return this.minuteStat;
    }

    public ServerStat getHourStat() {
        return this.hourStat;
    }

    public ServerStat getDayStat() {
        return this.dayStat;
    }

    public int getSlowThreads() {
        return this.slowThreadCount;
    }

    public TcpServer(Server server, ServerSocket serverSocket, int n, int n2, int n3, long l, long l2) {
        this.server = server;
        server.setServer(this);
        this.serverSocket = serverSocket;
        if (n < 1) {
            n = 1;
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n3 < 0) {
            n3 = n2 - n;
        }
        if (n + n3 < n2) {
            n2 = n3 + n;
        }
        this.connectionMin = n;
        this.connectionMax = n2;
        this.connectionMaxKeepalive = n3;
        this.connectionTimeout = l;
        if (l2 < 1000L) {
            l2 = 1000L;
        }
        this.reaperInterval = l2;
        this.connections = new ArrayList();
        this.connectionInterrupts = new ArrayList();
        this.connectionCount = 0;
        this.connectionKeepalive = 0;
        this.connectionListen = 0;
        this.socketQueue = new Socket[128];
        while (this.connectionCount < n) {
            ++this.connectionCount;
            this.startConnection();
        }
        this.alarm = new Alarm("tcp-reaper", this, 1000L);
        this.cron = new Cron(this);
        this.thread = new Thread((Runnable)this, "tcp-server");
        this.thread.setDaemon(true);
        this.thread.start();
    }
}

