/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Request;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InterruptedIOException;

class ChunkedInputStream
extends StreamImpl {
    private Request request;
    private ReadStream next;
    private int available;
    private byte[] buf = new byte[8];

    void init(Request request, ReadStream readStream) {
        this.request = request;
        this.next = readStream;
        this.available = 0;
    }

    public boolean canRead() {
        return true;
    }

    public int getAvailable() {
        return this.available;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.request.resetTimeout();
        if (this.available > 0) {
            if (this.available < n2) {
                n2 = this.available;
            }
            this.available -= n2;
            n2 = this.next.read(byArray, n, n2);
        } else if (this.available == 0) {
            this.available = this.readChunkLength();
            if (this.available > 0) {
                if (this.available < n2) {
                    n2 = this.available;
                }
                if ((n2 = this.next.read(byArray, n, n2)) > 0) {
                    this.available -= n2;
                }
            } else {
                this.available = -1;
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        Thread.currentThread();
        if (Thread.interrupted()) {
            throw new InterruptedIOException("interrupt during read");
        }
        return n2;
    }

    private int readChunkLength() throws IOException {
        int n = 0;
        int n2 = this.next.read();
        while (n2 == 13 || n2 == 32 || n2 == 10) {
            n2 = this.next.read();
        }
        while (n2 > 0 && n2 != 13 && n2 != 10) {
            if (n2 >= 48 && n2 <= 57) {
                n = 16 * n + n2 - 48;
            } else if (n2 >= 97 && n2 <= 102) {
                n = 16 * n + n2 - 97 + 10;
            } else if (n2 >= 65 && n2 <= 70) {
                n = 16 * n + n2 - 65 + 10;
            } else if (n2 != 32 && n2 != 9) {
                throw new IOException("HTTP/1.1 protocol error: bad chunk");
            }
            n2 = this.next.read();
        }
        if (n2 == 13) {
            n2 = this.next.read();
        }
        return n;
    }

    ChunkedInputStream() {
    }
}

