/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.util.Alarm;
import com.caucho.util.Base64;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FileServlet
extends GenericServlet {
    private Path context;
    private byte[] buffer = new byte[1024];
    private RequestDispatcher dir;
    private ArrayList indexFiles;
    private LruCache pathCache;
    private QDate calendar = new QDate();
    private String directoryServlet = "com.caucho.server.http.DirectoryServlet";

    /*
     * Unable to fully structure code
     */
    public void init(ServletConfig var1_1) throws ServletException {
        super.init(var1_1);
        var2_2 = (Application)this.getServletContext();
        this.context = var2_2.getAppDir();
        this.pathCache = new LruCache(256);
        this.indexFiles = new ArrayList<E>();
        var3_3 = var2_2.getRegistry();
        var4_4 = "";
        if (var3_3 != null) {
            var4_4 = var3_3.getString("welcome-file-list", "index.xtp, index.jsp, index.html");
            var5_5 = var3_3.lookup("welcome-file-list");
            if (var5_5 != null) {
                var6_7 = var5_5.select("welcome-file");
                while (var6_7.hasNext()) {
                    var7_9 = (RegistryNode)var6_7.next();
                    var8_10 = var7_9.getString();
                    if (var8_10 == null) continue;
                    var4_4 = var4_4 + ", " + var8_10;
                }
            }
            this.directoryServlet = var3_3.getString("directory-servlet", this.directoryServlet);
            if (this.directoryServlet.equals("none")) {
                this.directoryServlet = null;
            }
        }
        if (this.directoryServlet != null) {
            this.dir = var2_2.getNamedDispatcher(this.directoryServlet);
        }
        var5_6 = var4_4.length();
        var6_8 = 0;
        var7_9 = new CharBuffer();
        while (var6_8 < var5_6) {
            var8_11 = '\u0000';
            if (true) ** GOTO lbl32
            while (true) {
                ++var6_8;
lbl32:
                // 2 sources

                if (var6_8 < var5_6) {
                    v0 = var4_4.charAt(var6_8);
                    var8_11 = v0;
                    if (v0 == ' ') continue;
                }
                if (var8_11 != ',' && var8_11 != '\t') break;
            }
            if (var6_8 >= var5_6) break;
            var7_9.clear();
            if (true) ** GOTO lbl45
            do {
                var7_9.append(var8_11);
                ++var6_8;
lbl45:
                // 2 sources

                if (var6_8 >= var5_6) break;
                v1 = var4_4.charAt(var6_8);
                var8_11 = v1;
            } while (v1 != ' ' && var8_11 != ',' && var8_11 != 9);
            this.indexFiles.add(var7_9.toString());
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        Path path;
        Object object;
        Object object2;
        String string;
        String string2;
        String string3;
        Object object3;
        Cache cache;
        CauchoRequest cauchoRequest = (CauchoRequest)servletRequest;
        CauchoResponse cauchoResponse = (CauchoResponse)servletResponse;
        String string4 = cauchoRequest.getMethod();
        if (!(string4.equalsIgnoreCase("GET") || string4.equalsIgnoreCase("HEAD") || string4.equalsIgnoreCase("POST"))) {
            cauchoResponse.sendError(501, "Method not implemented");
            return;
        }
        String string5 = cauchoRequest.getPageURI();
        LruCache lruCache = this.pathCache;
        synchronized (lruCache) {
            cache = (Cache)this.pathCache.get(string5);
        }
        String string6 = null;
        if (cache == null) {
            object3 = CharBuffer.allocate();
            string3 = cauchoRequest.getPageServletPath();
            if (string3 != null) {
                ((CharBuffer)object3).append(string3);
            }
            if ((string2 = cauchoRequest.getPagePathInfo()) != null) {
                ((CharBuffer)object3).append(string2);
            }
            string = ((CharBuffer)object3).close();
            string6 = this.getServletContext().getRealPath(string);
            if (string.regionMatches(true, 0, "/web-inf", 0, 8) && (string.length() == 8 || !Character.isLetterOrDigit(string.charAt(8)))) {
                cauchoResponse.sendError(404);
                return;
            }
            if (CauchoSystem.isWindows() && string.endsWith(".")) {
                cauchoResponse.sendError(404);
                return;
            }
            object2 = this.getServletContext();
            object = this.pathCache;
            synchronized (object) {
                path = this.context.lookupNative(string6);
                cache = new Cache(this.calendar, path, string, object2.getMimeType(string));
                this.pathCache.put(string5, cache);
            }
        }
        cache.update();
        object3 = cauchoRequest.getHeader("If-None-Match");
        string3 = cache.getEtag();
        if (object3 != null && ((String)object3).equals(string3)) {
            cauchoResponse.sendError(304);
            return;
        }
        string2 = cauchoRequest.getHeader("If-Modified-Since");
        string = cache.getLastModifiedString();
        if (string2 != null && string2.equals(string)) {
            cauchoResponse.sendError(304);
            return;
        }
        if (!cache.canRead()) {
            cauchoResponse.sendError(404);
            return;
        }
        if (cache.isDirectory()) {
            boolean bl = false;
            if (string5.length() > 0 && string5.charAt(string5.length() - 1) != '/') {
                bl = true;
            }
            int n = 0;
            while (n < this.indexFiles.size()) {
                String string7 = (String)this.indexFiles.get(n);
                path = cache.getPath().lookup(string7);
                if (path.exists()) {
                    if (bl) {
                        cauchoResponse.sendRedirect(string5 + "/");
                        return;
                    }
                    String string8 = cache.getRelPath() + "/" + string7;
                    RequestDispatcher requestDispatcher = this.getServletContext().getRequestDispatcher(string8);
                    requestDispatcher.forward((ServletRequest)cauchoRequest, (ServletResponse)cauchoResponse);
                    return;
                }
                ++n;
            }
            if (this.dir == null) {
                cauchoResponse.sendError(404, "Can't list directory `" + string5 + "'");
                return;
            }
            this.dir.forward((ServletRequest)cauchoRequest, (ServletResponse)cauchoResponse);
            return;
        }
        cauchoResponse.setHeader("ETag", string3);
        cauchoResponse.setHeader("Last-Modified", string);
        object2 = cache.getMimeType();
        if (object2 != null) {
            cauchoResponse.setContentType((String)object2);
        }
        cauchoResponse.setContentLength((int)cache.getLength());
        if (string4.equalsIgnoreCase("HEAD")) {
            return;
        }
        object = null;
        ServletOutputStream servletOutputStream = null;
        try {
            object = cache.getPath().openRead();
            servletOutputStream = cauchoResponse.getOutputStream();
            ((ReadStream)object).writeToStream((OutputStream)servletOutputStream);
        }
        finally {
            Object var9_24 = null;
            if (object != null) {
                ((ReadStream)object).close();
            }
            if (servletOutputStream != null) {
                servletOutputStream.close();
            }
        }
    }

    static class Cache {
        QDate calendar;
        Path path;
        boolean isDirectory;
        boolean canRead;
        long length;
        long lastCheck;
        long lastModified;
        String relPath;
        String etag;
        String lastModifiedString;
        String mimeType;

        Path getPath() {
            return this.path;
        }

        boolean canRead() {
            return this.canRead;
        }

        boolean isDirectory() {
            return this.isDirectory;
        }

        long getLength() {
            return this.length;
        }

        String getRelPath() {
            return this.relPath;
        }

        String getEtag() {
            return this.etag;
        }

        String getLastModifiedString() {
            return this.lastModifiedString;
        }

        String getMimeType() {
            return this.mimeType;
        }

        void update() {
            long l = Alarm.getCurrentTime();
            if (this.lastCheck + 2000L < l) {
                this.lastCheck = l;
                this.isDirectory = this.path.isDirectory();
                this.canRead = this.path.canRead();
                this.length = this.path.getLength();
                long l2 = this.path.getLastModified();
                if (l2 != this.lastModified) {
                    this.lastModified = l2;
                    CharBuffer charBuffer = new CharBuffer();
                    Base64.encode(charBuffer, l2);
                    this.etag = charBuffer.close();
                    QDate qDate = this.calendar;
                    synchronized (qDate) {
                        this.calendar.calculate(l2, false);
                        this.lastModifiedString = this.calendar.printDate();
                    }
                }
            }
        }

        Cache(QDate qDate, Path path, String string, String string2) {
            this.calendar = qDate;
            this.path = path;
            this.relPath = string;
            this.mimeType = string2;
        }
    }
}

