/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.SecurityConstraint;
import com.caucho.server.http.VirtualHost;
import com.caucho.util.ByteBuffer;
import com.caucho.util.QDate;
import javax.servlet.Servlet;
import javax.servlet.ServletException;

class Invocation {
    private static QDate date = new QDate();
    private VirtualHost host;
    Application application;
    String uri;
    String contextPath;
    String servletPath;
    String pathInfo;
    String sessionId;
    QServletConfig servletConfig;
    Servlet servlet;
    int loaderCount;
    SecurityConstraint security;

    static String normalizeUri(String string) {
        ByteBuffer byteBuffer = new ByteBuffer();
        int n = string.length();
        if (n == 0 || string.charAt(0) != '/') {
            byteBuffer.append(47);
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '/') {
                while (n2 + 1 < n) {
                    c = string.charAt(n2 + 1);
                    if (c == '/') {
                        ++n2;
                        continue;
                    }
                    if (c != '.') break;
                    if (n2 + 2 >= n || (c = string.charAt(n2 + 2)) == '/') {
                        n2 += 2;
                        continue;
                    }
                    if (c != '.' || n2 + 3 < n && string.charAt(n2 + 3) != '/') break;
                    int n3 = byteBuffer.size() - 1;
                    while (n3 >= 0) {
                        if (byteBuffer.get(n3) == 47) break;
                        --n3;
                    }
                    if (n3 > 0) {
                        byteBuffer.setLength(n3);
                    } else {
                        byteBuffer.setLength(0);
                    }
                    n2 += 3;
                }
                byteBuffer.append(47);
            } else if (c == '%') {
                n2 = Invocation.scanUrlEscape(byteBuffer, string, n2);
            } else {
                byteBuffer.append(c);
            }
            ++n2;
        }
        return byteBuffer.toString();
    }

    private static int scanUrlEscape(ByteBuffer byteBuffer, String string, int n) {
        char c;
        if ((c = string.charAt(++n)) == 'u') {
            int n2 = Invocation.toHex(string.charAt(++n));
            int n3 = Invocation.toHex(string.charAt(++n));
            int n4 = Invocation.toHex(string.charAt(++n));
            int n5 = Invocation.toHex(string.charAt(++n));
            byteBuffer.append(63);
            return n;
        }
        int n6 = Invocation.toHex(c);
        int n7 = Invocation.toHex(string.charAt(++n));
        if (n6 < 0 || n7 < 0) {
            byteBuffer.append(63);
        } else {
            byteBuffer.append((byte)((n6 << 4) + n7));
        }
        return n;
    }

    private static int toHex(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    VirtualHost getHost() {
        return this.host;
    }

    String getUri() {
        return this.uri;
    }

    String getContextPath() {
        return this.contextPath;
    }

    String getServletPath() {
        return this.servletPath;
    }

    String getPathInfo() {
        return this.pathInfo;
    }

    String getSessionId() {
        return this.sessionId;
    }

    Application getApplication() {
        return this.application;
    }

    QServletConfig getServletConfig() {
        return this.servletConfig;
    }

    String getServletName() {
        return this.servletConfig.getServletName();
    }

    Servlet getServlet() throws Exception, ServletException {
        this.servlet = this.application.updateServlet(this.servletConfig, this.servlet, this.loaderCount);
        if (this.servlet == null) {
            this.servlet = this.application.loadServlet(this.servletConfig);
        }
        this.loaderCount = this.application.getClassUpdateCount();
        return this.servlet;
    }

    Invocation(VirtualHost virtualHost, String string) {
        this.host = virtualHost;
        this.uri = Invocation.normalizeUri(string);
    }
}

