/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.Response;
import com.caucho.server.http.VirtualHost;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;

class PageCache {
    static WriteStream dbg = LogStream.open("/caucho.com/http/cache");
    static final long DEFAULT_EXPIRES = 5000L;
    VirtualHost host;
    Path cacheRoot;
    LruCache cache;
    Key key;
    QDate calendar = new QDate();

    synchronized void clear() {
        this.cache.clear();
    }

    void service(AbstractRequest abstractRequest, Response response) throws Exception {
        Entry entry = this.getEntry(abstractRequest.getPageUriBuffer(), abstractRequest.getPageQueryBuffer());
        entry.service(abstractRequest, response);
    }

    Invocation getInvocation(CharBuffer charBuffer, CharBuffer charBuffer2) throws Exception {
        Entry entry = this.getEntry(charBuffer, charBuffer2);
        return entry.invocation;
    }

    private Entry getEntry(CharBuffer charBuffer, CharBuffer charBuffer2) throws Exception {
        Entry entry = null;
        PageCache pageCache = this;
        synchronized (pageCache) {
            this.key.init(charBuffer, charBuffer2);
            entry = (Entry)this.cache.get(this.key);
        }
        if (entry != null) {
            return entry;
        }
        Invocation invocation = this.host.getInvocation(charBuffer);
        PageCache pageCache2 = this;
        if (pageCache2 == null) {
            throw null;
        }
        entry = pageCache2.new Entry(this.cacheRoot, invocation);
        pageCache = this;
        synchronized (pageCache) {
            Key key = new Key(charBuffer, charBuffer2);
            this.cache.put(key, entry);
        }
        return entry;
    }

    PageCache(VirtualHost virtualHost, Path path) {
        this.host = virtualHost;
        this.cacheRoot = path;
        this.cache = new LruCache(1024);
        this.key = new Key();
        try {
            Iterator iterator = path.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    Path path2 = path.lookup(string);
                    path2.remove();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class Entry {
        String url;
        private Invocation invocation;
        Path cacheRoot;
        Path cache;
        WriteStream cacheStream;
        ArrayList headerKeys;
        ArrayList headerValues;
        String contentType;
        boolean isCacheable = true;
        long lastCacheCheck;
        boolean hasCache = false;
        boolean isFillingCache = false;
        long expiresTime = -1L;
        long expireDate = -1L;
        String etag;
        String lastModified;
        long lastModifiedDate = -1L;
        boolean varyCookies = false;
        boolean canCache = false;

        Invocation getInvocation() throws ServletException {
            try {
                VirtualHost virtualHost = this.invocation.getHost();
                this.invocation = virtualHost.updateInvocation(this.invocation);
                return this.invocation;
            }
            catch (ServletException servletException) {
                throw servletException;
            }
            catch (Exception exception) {
                throw new ServletException((Throwable)exception);
            }
        }

        void service(AbstractRequest abstractRequest, Response response) throws IOException, ServletException {
            boolean bl = this.hasCache && this.cache != null;
            Entry entry = this;
            synchronized (entry) {
                if (bl) {
                    if (this.varyCookies && abstractRequest.getHeader("Cookie") != null) {
                        bl = false;
                    } else if (!this.invocation.getApplication().isModified() && this.expireDate >= abstractRequest.getDate() && this.fillFromCache(abstractRequest, response, true)) {
                        Object var5_6 = null;
                        return;
                    }
                }
                String string = null;
                if (bl && this.etag != null) {
                    string = abstractRequest.getHeader("If-None-Match");
                    abstractRequest.setHeader("If-None-Match", this.etag);
                }
                String string2 = null;
                if (bl && this.lastModified != null) {
                    string2 = abstractRequest.getHeader("If-Modified-Since");
                    abstractRequest.setHeader("If-Modified-Since", this.lastModified);
                }
                if (bl) {
                    if (abstractRequest.getRequestDepth(0) > 1) {
                        response.setPageCache(this);
                    } else if (string == null && string2 == null) {
                        response.setPageCache(this);
                    } else if (string != null && !string.equals(this.etag)) {
                        response.setPageCache(this);
                    } else if (string2 != null && !string2.equals(this.lastModified)) {
                        response.setPageCache(this);
                    }
                }
            }
            try {
                abstractRequest.service(this, (CauchoResponse)response);
            }
            finally {
                Object var5_7 = null;
                if (this.cacheStream != null) {
                    this.finishCaching(false);
                }
            }
            entry = this;
            synchronized (entry) {
                if (bl && this.expiresTime > 0L && this.expireDate < abstractRequest.getDate()) {
                    this.expireDate = abstractRequest.getDate() + this.expiresTime;
                }
            }
        }

        synchronized boolean fillFromCache(AbstractRequest abstractRequest, Response response, boolean bl) throws IOException {
            if (!this.hasCache || this.cache == null) {
                return false;
            }
            if (dbg.canWrite()) {
                dbg.log("using cache: " + this.url + "?" + abstractRequest.getPageQueryString());
            }
            response.reset();
            response.disableCaching(true);
            boolean bl2 = false;
            if (bl) {
                int n;
                String string;
                if (this.etag != null) {
                    string = abstractRequest.getHeader("if-none-match");
                    int n2 = n = string != null ? string.indexOf(59) : -1;
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    if (string != null && string.equals(this.etag)) {
                        response.setStatus(304);
                        bl2 = true;
                    }
                }
                if (!bl2 && this.lastModified != null) {
                    string = abstractRequest.getHeader("if-modified-since");
                    int n3 = n = string != null ? string.indexOf(59) : 0;
                    if (n > 0) {
                        string = string.substring(0, n);
                    }
                    if (string != null && string.equals(this.lastModified)) {
                        response.setStatus(304);
                        bl2 = true;
                    }
                }
            }
            if (this.contentType != null) {
                response.setContentType(this.contentType);
            }
            int n = 0;
            while (this.headerKeys != null && n < this.headerKeys.size()) {
                response.addHeader((String)this.headerKeys.get(n), (String)this.headerValues.get(n));
                ++n;
            }
            if (this.expiresTime > 0L) {
                response.setDateHeader("Expires", abstractRequest.getDate() + this.expiresTime);
            } else if (this.expireDate > 0L) {
                response.setDateHeader("Expires", this.expireDate);
            }
            CharBuffer charBuffer = abstractRequest.getMethodBuffer();
            if (charBuffer != null && charBuffer.matches("HEAD") || bl2) {
                return true;
            }
            this.cache.writeToStream(response.getStream());
            return true;
        }

        boolean isCacheable() {
            return this.isCacheable && this.canCache;
        }

        synchronized WriteStream startCaching(AbstractRequest abstractRequest, Response response, ArrayList arrayList, ArrayList arrayList2, String string, String string2) {
            Object object;
            String string3;
            Path path = null;
            long l = abstractRequest.getDate();
            if (!this.isCacheable && this.lastCacheCheck + 60000L < l || this.isFillingCache) {
                return null;
            }
            this.isCacheable = false;
            this.isFillingCache = true;
            boolean bl = this.hasCache;
            this.hasCache = false;
            path = this.cache;
            this.cache = null;
            boolean bl2 = false;
            if (!"GET".equals(abstractRequest.getMethod()) && !"HEAD".equals(abstractRequest.getMethod())) {
                bl2 = true;
            } else if (response.getHeader("Vary") != null) {
                bl2 = true;
            }
            String string4 = response.getHeader("Cache-Control");
            if (string4 != null && string4.startsWith("no-cache")) {
                bl2 = true;
            }
            boolean bl3 = this.canCache = !bl2;
            if (bl2) {
                try {
                    if (path != null) {
                        path.remove();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            this.varyCookies = abstractRequest.getVaryCookies();
            boolean bl4 = abstractRequest.getUsesCookies();
            long l2 = -1L;
            if (!bl4) {
                this.expireDate = l2;
            }
            if ((string3 = response.getHeader("Expires")) != null) {
                QDate qDate = PageCache.this.calendar;
                synchronized (qDate) {
                    try {
                        l2 = PageCache.this.calendar.parseDate(string3);
                        if (!bl4) {
                            this.expireDate = l2;
                        }
                        if (l2 < abstractRequest.getDate()) {
                            this.canCache = false;
                            WriteStream writeStream = null;
                            Object var18_20 = null;
                            return writeStream;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            long l3 = -1L;
            String string5 = response.getHeader("Last-Modified");
            if (string5 != null) {
                object = PageCache.this.calendar;
                synchronized (object) {
                    block52: {
                        try {
                            l3 = PageCache.this.calendar.parseDate(string5);
                        }
                        catch (Exception exception) {
                            if (!dbg.canWrite()) break block52;
                            dbg.log(exception);
                        }
                    }
                }
            }
            if (!bl4) {
                this.lastModifiedDate = l3;
                this.lastModified = string5;
            }
            object = response.getHeader("ETag");
            if (!bl4) {
                this.etag = object;
            }
            if (!(bl4 || l2 != -1L || object == null && l3 <= 0L)) {
                if (this.expiresTime < 0L) {
                    Application application = abstractRequest.getApplication();
                    if (application != null && this.url != null) {
                        this.expiresTime = application.getCacheTime(this.url);
                    }
                    if (this.expiresTime < 5000L) {
                        this.expiresTime = 5000L;
                    }
                }
                if (this.expiresTime > 0L && !abstractRequest.getVaryCookies()) {
                    response.setDateHeader("Expires", abstractRequest.getDate() + this.expiresTime);
                }
                this.expireDate = abstractRequest.getDate() + 5000L;
            }
            if (l2 - 1000L < abstractRequest.getDate() && l3 < 0L && object == null) {
                this.canCache = false;
                return null;
            }
            if (abstractRequest.getUsesCookies()) {
                this.isCacheable = true;
                this.isFillingCache = false;
                this.cache = path;
                this.hasCache = bl;
                return null;
            }
            if (path != null) {
                try {
                    path.remove();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (dbg.canWrite()) {
                dbg.log("caching: " + this.url + "?" + abstractRequest.getPageQueryString());
            }
            if (this.headerKeys == null) {
                this.headerKeys = new ArrayList();
            } else {
                this.headerKeys.clear();
            }
            if (this.headerValues == null) {
                this.headerValues = new ArrayList();
            } else {
                this.headerValues.clear();
            }
            int n = 0;
            while (n < arrayList.size()) {
                String string6 = (String)arrayList.get(n);
                if (!string6.equalsIgnoreCase("expires")) {
                    this.headerKeys.add(string6);
                    this.headerValues.add(arrayList2.get(n));
                }
                ++n;
            }
            if (abstractRequest.getVaryCookies()) {
                this.headerKeys.add("Cache-Control");
                this.headerValues.add("no-cache");
                this.headerKeys.add("Pragma");
                this.headerValues.add("no-cache");
            }
            if (string != null && string2 != null) {
                this.contentType = string + "; charset=" + string2;
            } else if (string != null) {
                this.contentType = string;
            } else if (string2 != null) {
                this.contentType = "text/html; charset=" + string2;
            }
            try {
                this.cache = this.cacheRoot.createTempFile("res", "");
                this.cacheStream = this.cache.openWrite();
                this.isCacheable = true;
                return this.cacheStream;
            }
            catch (IOException iOException) {
                if (dbg.canWrite()) {
                    dbg.log(iOException);
                }
                return null;
            }
        }

        void finishCaching(boolean bl) {
            block7: {
                Object object;
                this.hasCache = bl;
                try {
                    object = this.cacheStream;
                    this.cacheStream = null;
                    if (object != null) {
                        ((WriteStream)object).close();
                    }
                }
                catch (IOException iOException) {
                    if (dbg.canWrite()) {
                        dbg.log(iOException);
                    }
                    this.hasCache = false;
                }
                try {
                    if (!this.hasCache && this.cache != null) {
                        object = this.cache;
                        this.cache = null;
                        ((Path)object).remove();
                    }
                }
                catch (IOException iOException) {
                    if (!dbg.canWrite()) break block7;
                    dbg.log(iOException);
                }
            }
            this.isFillingCache = false;
        }

        Entry(Path path, Invocation invocation) {
            this.cacheRoot = path;
            this.invocation = invocation;
            this.url = invocation.uri;
        }
    }

    static class Key {
        CharBuffer url;
        CharBuffer queryString;

        void init(CharBuffer charBuffer, CharBuffer charBuffer2) {
            this.url = charBuffer;
            this.queryString = charBuffer2;
        }

        public int hashCode() {
            if (this.queryString != null) {
                return this.url.hashCode() * 65521 + this.queryString.hashCode();
            }
            return this.url.hashCode() * 65521;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.url.equals(key.url) && this.queryString.equals(key.queryString);
            }
            return false;
        }

        Key() {
        }

        Key(CharBuffer charBuffer, CharBuffer charBuffer2) {
            this.url = (CharBuffer)charBuffer.clone();
            if (charBuffer2 != null) {
                this.queryString = (CharBuffer)charBuffer2.clone();
            }
        }
    }
}

