/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoApplication;
import com.caucho.util.QDate;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

class QServletConfig
implements ServletConfig {
    private CauchoApplication application;
    private RegistryNode registry;
    private String name;
    private String className;
    private String jspFile;
    private String displayName;
    private String description;
    private boolean loadOnStartup;
    private HashMap init;
    private String outputFilter;
    private long available;
    private ArrayList hourTimes;
    private ArrayList minuteTimes;
    private QDate cal;

    private void configureRunAt(RegistryNode registryNode) throws ServletException {
        String string = registryNode.getValue();
        if (string == null) {
            return;
        }
        int n = string.length();
        char c = '\u0000';
        int n2 = 0;
        while (true) {
            if (n2 < n && (Character.isWhitespace(c = string.charAt(n2)) || c == ',')) {
                ++n2;
                continue;
            }
            if (n2 >= n) {
                return;
            }
            if ((c < '0' || c > '9') && c != ':') {
                throw Application.error(registryNode, "illegal run-at time");
            }
            int n3 = 0;
            int n4 = 0;
            boolean bl = false;
            while (n2 < n && (c = string.charAt(n2)) >= '0' && c <= '9') {
                bl = true;
                n3 = 10 * n3 + c - 48;
                ++n2;
            }
            if (c == ':') {
                ++n2;
                while (n2 < n && (c = string.charAt(n2)) >= '0' && c <= '9') {
                    n4 = 10 * n4 + c - 48;
                    ++n2;
                }
            }
            this.loadOnStartup = true;
            if (bl) {
                if (this.hourTimes == null) {
                    this.hourTimes = new ArrayList();
                }
                this.hourTimes.add(new Integer(60 * n3 + n4));
                continue;
            }
            if (this.minuteTimes == null) {
                this.minuteTimes = new ArrayList();
            }
            this.minuteTimes.add(new Integer(n4));
        }
    }

    boolean isCron() {
        return this.hourTimes != null || this.minuteTimes != null;
    }

    long getNextTimeout(long l) {
        long l2;
        long l3;
        Integer n;
        if (this.cal == null) {
            this.cal = new QDate();
        }
        this.cal.setTime(l);
        long l4 = l + this.cal.getZoneOffset();
        long l5 = l4 / 60000L % 1440L;
        long l6 = l5 % 60L;
        long l7 = Long.MAX_VALUE;
        int n2 = 0;
        while (this.hourTimes != null && n2 < this.hourTimes.size()) {
            n = (Integer)this.hourTimes.get(n2);
            l3 = n.intValue();
            l2 = (l3 - l5 + 1440L) % 1440L;
            if (l2 < l7) {
                l7 = l2;
            }
            ++n2;
        }
        n2 = 0;
        while (this.minuteTimes != null && n2 < this.minuteTimes.size()) {
            n = (Integer)this.minuteTimes.get(n2);
            l3 = n.intValue();
            l2 = (l3 - l6 + 60L) % 60L;
            if (l2 < l7) {
                l7 = l2;
            }
            ++n2;
        }
        if (l7 < Integer.MAX_VALUE) {
            return l + l7 * 60000L;
        }
        return Long.MAX_VALUE;
    }

    public String getServletName() {
        return this.name;
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public String getInitParameter(String string) {
        return (String)this.init.get(string);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this.init.keySet());
    }

    public Path getPath() {
        return this.application.getAppDir();
    }

    String getClassName() {
        return this.className;
    }

    String getJspFile() {
        return this.jspFile;
    }

    boolean loadOnStartup() {
        return this.loadOnStartup;
    }

    String getFilter(String string) {
        return this.application.getFilter(string);
    }

    void setAvailable(long l) {
        this.available = l;
    }

    boolean isAvailable(long l) {
        return this.available <= l;
    }

    QServletConfig(CauchoApplication cauchoApplication, String string, String string2, RegistryNode registryNode) throws ServletException {
        this.application = cauchoApplication;
        this.registry = registryNode;
        this.name = string;
        this.init = new HashMap();
        if (registryNode == null) {
            if (string.endsWith(".jsp") || string.endsWith(".xtp")) {
                this.jspFile = string;
            } else {
                this.className = string2 == null ? string : string2;
            }
            return;
        }
        this.className = registryNode.getString("servlet-class", string2);
        this.jspFile = registryNode.getString("jsp-file", null);
        if (this.className == null && this.jspFile == null) {
            if (string.endsWith(".jsp") || string.endsWith(".xtp")) {
                this.jspFile = string;
            } else {
                this.className = string2 != null ? string2 : string;
            }
        }
        Iterator iterator = registryNode.iterator();
        while (iterator.hasNext()) {
            RegistryNode registryNode2 = (RegistryNode)iterator.next();
            if (registryNode2.getName().equals("init-param")) {
                Iterator iterator2 = registryNode2.iterator();
                while (iterator2.hasNext()) {
                    RegistryNode registryNode3 = (RegistryNode)iterator2.next();
                    if (registryNode3.getName().equals("param-name")) {
                        String string3 = registryNode3.getValue();
                        String string4 = registryNode2.getString("param-value", null);
                        this.init.put(string3, string4 == null ? "" : string4);
                        continue;
                    }
                    if (registryNode3.getName().equals("param-value")) continue;
                    this.init.put(registryNode3.getName(), registryNode3.getValue());
                }
                continue;
            }
            if (registryNode2.getName().equals("run-at")) {
                this.configureRunAt(registryNode2);
                continue;
            }
            if (registryNode2.getName().equals("load-on-startup")) {
                this.loadOnStartup = true;
                continue;
            }
            if (registryNode2.getName().equals("output-filter")) {
                this.outputFilter = registryNode2.getValue();
                continue;
            }
            if (registryNode2.getName().equals("display-name")) {
                this.displayName = registryNode2.getValue();
                continue;
            }
            if (registryNode2.getName().equals("description")) {
                this.description = registryNode2.getValue();
                continue;
            }
            if (registryNode2.getName().equals("servlet-name") || registryNode2.getName().equals("servlet-class") || registryNode2.getName().equals("jsp-file") || registryNode2.getName().equals("icon") || registryNode2.getName().equals("security-role-ref") || registryNode2.getName().equals("url-pattern") || registryNode2.getName().equals("url-regexp") || registryNode2.getName().equals("path-info")) continue;
            throw Application.error(registryNode2, "unknown servlet configuration `" + registryNode2.getName() + "'");
        }
    }
}

