/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.util.CacheListener;
import com.caucho.util.NullEnumeration;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;

class QSession
implements HttpSession,
CacheListener {
    private static WriteStream dbg = LogStream.open("/caucho.com/http/session");
    private Application application;
    private String id;
    private long creationTime;
    long accessTime;
    long maxInactiveInterval;
    private HashMap values;
    private boolean isNew = true;
    boolean isValid = true;
    boolean inUse;

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.accessTime;
    }

    public int getMaxInactiveInterval() {
        return (int)(this.maxInactiveInterval / 1000L);
    }

    public void setMaxInactiveInterval(int n) {
        this.maxInactiveInterval = (long)n * 1000L;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public synchronized Object getAttribute(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("session is invalid");
        }
        if (this.values == null) {
            return null;
        }
        return this.values.get(string);
    }

    public synchronized void setAttribute(String string, Object object) {
        if (!this.isValid) {
            throw new IllegalStateException("session is invalid");
        }
        if (this.values == null) {
            this.values = new HashMap();
        }
        this.values.put(string, object);
        if (object instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            httpSessionBindingListener.valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public synchronized void removeAttribute(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("session is invalid");
        }
        if (this.values == null) {
            return;
        }
        Object v = this.values.remove(string);
        if (v instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)v;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public synchronized Enumeration getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException("session is invalid");
        }
        if (this.values == null) {
            return NullEnumeration.create();
        }
        return Collections.enumeration(this.values.keySet());
    }

    public synchronized Object getValue(String string) {
        return this.getAttribute(string);
    }

    public synchronized void putValue(String string, Object object) {
        this.setAttribute(string, object);
    }

    public synchronized void removeValue(String string) {
        this.removeAttribute(string);
    }

    public synchronized String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException("session is invalid");
        }
        if (this.values == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.values.size()];
        Enumeration enumeration = this.getAttributeNames();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public boolean isNew() {
        return this.isNew;
    }

    boolean isValid() {
        return this.isValid;
    }

    public void removeEvent() {
        this.invalidate();
    }

    public void invalidate() {
        if (!this.isValid) {
            return;
        }
        if (dbg.canWrite()) {
            dbg.log("invalidate session " + this.id);
        }
        this.isValid = false;
        this.application.removeSession(this);
        HashMap hashMap = this.values;
        this.values = null;
        if (hashMap == null) {
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = hashMap.get(string);
            if (!(v instanceof HttpSessionBindingListener)) continue;
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)v;
            httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    void setAccess(long l) {
        this.isNew = false;
        this.accessTime = l;
        this.inUse = true;
    }

    void finish() {
        this.inUse = false;
    }

    QSession(Application application, String string, long l) {
        this.application = application;
        this.creationTime = l;
        this.accessTime = l;
        this.maxInactiveInterval = application.getSessionTimeout();
        this.id = string;
        if (dbg.canWrite()) {
            dbg.log("create session " + string);
        }
    }
}

