/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

class RequestAdapter
extends AbstractRequest {
    HttpServletRequest request;
    private CharBuffer pageUri = new CharBuffer();
    private CharBuffer pageQuery = new CharBuffer();
    private CauchoApplication application;

    public void init(HttpServletRequest httpServletRequest) throws ServletException {
        super.start();
        this.request = httpServletRequest;
        this.pageUri.clear();
        this.pageQuery.clear();
        this.application = null;
        if (httpServletRequest == this || httpServletRequest instanceof CauchoRequest && ((CauchoRequest)httpServletRequest).getRequestDepth(0) > 10) {
            throw new ServletException("too many servlet includes `" + httpServletRequest.getRequestURI() + "'");
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public ReadStream getStream() throws IOException {
        try {
            return ((CauchoRequest)this.request).getStream();
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
    }

    public int getRequestDepth(int n) {
        if (n > 20) {
            throw new RuntimeException("too many request dispatchers");
        }
        if (this.request instanceof CauchoRequest) {
            return ((CauchoRequest)this.request).getRequestDepth(n + 1);
        }
        return n + 1;
    }

    public long getDate() {
        if (this.request instanceof CauchoRequest) {
            return ((CauchoRequest)this.request).getDate();
        }
        return Alarm.getCurrentTime();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public CharBuffer getPageUriBuffer() {
        if (this.pageUri.length() == 0) {
            this.pageUri.append(this.getPageURI());
        }
        return this.pageUri;
    }

    public String getContextPath() {
        if (this.request instanceof CauchoRequest) {
            return ((CauchoRequest)this.request).getContextPath();
        }
        String string = this.getRequestURI();
        String string2 = this.getServletPath();
        String string3 = this.getPathInfo();
        int n = 0;
        n += string2 == null ? 0 : string2.length();
        if (string.length() >= (n += string3 == null ? 0 : string3.length())) {
            return string.substring(0, string.length() - n);
        }
        return "";
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public CharBuffer getPageQueryBuffer() {
        if (this.pageQuery.length() == 0) {
            this.pageQuery.append(this.getPageQueryString());
        }
        return this.pageQuery;
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getHeader(String string) {
        return this.request.getHeader(string);
    }

    public void setHeader(String string, String string2) {
    }

    public Application getApplication() {
        return null;
    }

    public CauchoApplication getCauchoApplication() {
        return this.application;
    }

    protected void setVaryCookies() {
        super.setVaryCookies();
        if (this.request instanceof AbstractRequest) {
            ((AbstractRequest)this.request).setVaryCookies();
        }
    }

    protected void setUsesCookies() {
        super.setUsesCookies();
        if (this.request instanceof AbstractRequest) {
            ((AbstractRequest)this.request).setUsesCookies();
        }
    }

    public HttpSession getSession(boolean bl) {
        this.setVaryCookies();
        HttpSession httpSession = this.request.getSession(bl);
        if (httpSession != null) {
            this.setUsesCookies();
        }
        return httpSession;
    }

    public String getRequestedSessionId() {
        this.setVaryCookies();
        String string = this.request.getRequestedSessionId();
        if (string != null) {
            this.setUsesCookies();
        }
        return string;
    }

    public boolean isRequestedSessionIdValid() {
        this.setVaryCookies();
        boolean bl = this.request.isRequestedSessionIdValid();
        if (bl) {
            this.setUsesCookies();
        }
        return bl;
    }

    public boolean isRequestedSessionIdFromCookie() {
        this.setVaryCookies();
        boolean bl = this.request.isRequestedSessionIdFromCookie();
        if (bl) {
            this.setUsesCookies();
        }
        return bl;
    }

    public boolean isRequestedSessionIdFromURL() {
        this.setVaryCookies();
        boolean bl = this.request.isRequestedSessionIdFromURL();
        if (bl) {
            this.setUsesCookies();
        }
        return bl;
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public Object getAttribute(String string) {
        return this.request.getAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        this.request.setAttribute(string, object);
    }

    public void removeAttribute(String string) {
        if (this.request instanceof CauchoRequest) {
            ((CauchoRequest)this.request).removeAttribute(string);
        }
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String string) {
        return this.request.getParameterValues(string);
    }

    public String getParameter(String string) {
        return this.request.getParameter(string);
    }

    public Cookie[] getCookies() {
        this.setVaryCookies();
        Cookie[] cookieArray = this.request.getCookies();
        if (cookieArray != null && cookieArray.length > 0) {
            this.setUsesCookies();
        }
        return cookieArray;
    }

    public Cookie getCookie(String string) {
        this.setVaryCookies();
        if (this.request instanceof CauchoRequest) {
            return ((CauchoRequest)this.request).getCookie(string);
        }
        Cookie[] cookieArray = this.getCookies();
        int n = 0;
        while (cookieArray != null && n < cookieArray.length) {
            if (cookieArray[n].getName().equals(string)) {
                this.setUsesCookies();
                return cookieArray[n];
            }
            ++n;
        }
        return null;
    }

    public String getRealPath(String string) {
        return this.request.getRealPath(string);
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public Enumeration getHeaders(String string) {
        try {
            return this.request.getHeaders(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Locale getLocale() {
        try {
            return this.request.getLocale();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Enumeration getLocales() {
        try {
            return this.request.getLocales();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isUserInRole(String string) {
        try {
            return this.request.isUserInRole(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isSecure() {
        try {
            return this.request.isSecure();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Principal getUserPrincipal() {
        try {
            return this.request.getUserPrincipal();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void resetTimeout() {
        if (this.request instanceof CauchoRequest) {
            ((CauchoRequest)this.request).resetTimeout();
        }
    }

    public RequestAdapter() {
        this.request = null;
    }

    public RequestAdapter(HttpServletRequest httpServletRequest, CauchoApplication cauchoApplication) {
        this.request = httpServletRequest;
        this.application = cauchoApplication;
    }
}

