/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.PageCache;
import com.caucho.server.http.QRequestDispatcher;
import com.caucho.server.http.QServletOutputStream;
import com.caucho.server.http.Request;
import com.caucho.server.http.ResponseStream;
import com.caucho.server.http.VirtualHost;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.QDate;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlChar;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

abstract class Response
implements CauchoResponse {
    static WriteStream dbg = LogStream.open("/caucho.com/http/connection");
    static HashMap errors = new HashMap();
    protected AbstractRequest request;
    protected int statusCode;
    protected String statusMessage;
    protected String contentType;
    protected String charEncoding;
    protected ArrayList headerKeys = new ArrayList();
    protected ArrayList headerValues = new ArrayList();
    protected ArrayList cookiesOut = new ArrayList();
    private ResponseStream responseStream;
    private WriteStream s;
    private QServletOutputStream os;
    boolean headersWritten;
    protected QDate calendar = new QDate();
    protected CharBuffer cb = new CharBuffer();
    private String sessionId;
    protected boolean allowKeepalive;
    private Locale locale;
    protected boolean disableHeaders;
    protected boolean disableCaching;
    private int contentLength;
    protected boolean isChaining;
    protected boolean isClosed;
    protected boolean hasWriter;
    protected boolean hasOutputStream;
    private PageCache.Entry cache;

    void init(WriteStream writeStream) {
        this.responseStream.init(this, writeStream);
        this.s.init(this.responseStream);
    }

    void init(AbstractRequest abstractRequest, WriteStream writeStream) {
        this.request = abstractRequest;
        this.responseStream.init(this, writeStream);
        this.s.init(this.responseStream);
    }

    AbstractRequest getRequest() {
        return this.request;
    }

    void setRequest(AbstractRequest abstractRequest) {
        this.request = abstractRequest;
    }

    public void close() throws IOException {
    }

    void start() throws IOException {
        this.statusCode = 200;
        this.statusMessage = "OK";
        this.headerKeys.clear();
        this.headerValues.clear();
        this.cookiesOut.clear();
        this.headersWritten = false;
        this.charEncoding = null;
        this.contentType = null;
        this.locale = null;
        this.s.setLocale(null);
        this.s.setEncoding(null);
        this.responseStream.start();
        this.allowKeepalive = true;
        this.contentLength = 0;
        this.disableHeaders = false;
        this.disableCaching = false;
        this.isChaining = false;
        this.isClosed = false;
        this.hasWriter = false;
        this.hasOutputStream = false;
        this.cache = null;
        this.sessionId = null;
    }

    void setHead() {
        this.responseStream.setHead();
    }

    void setPageCache(PageCache.Entry entry) {
        this.cache = entry;
    }

    ReadStream finish(boolean bl) throws IOException {
        VirtualHost virtualHost;
        Request request;
        Invocation invocation;
        if (this.isClosed) {
            return null;
        }
        this.isClosed = true;
        this.responseStream.setFlush(false);
        if (this.os != null) {
            this.os.flush();
        }
        if (this.s != null) {
            this.s.flush();
        }
        this.responseStream.setFlush(true);
        this.responseStream.finish(!this.allowKeepalive(), bl);
        this.request.finishCaching(this.statusCode == 200);
        if (this.request instanceof Request && (invocation = (request = (Request)this.request).getInvocation()) != null && (virtualHost = invocation.getHost()) != null) {
            virtualHost.logAccess(request, this);
        }
        return null;
    }

    public String getFilter() {
        if (this.statusCode != 200) {
            return null;
        }
        return this.request.getFilter(this.contentType);
    }

    void flushChaining() {
        this.responseStream.setFlush(true);
    }

    public TempBuffer startChaining(Hashtable hashtable) throws IOException {
        this.responseStream.setFlush(false);
        if (this.os != null) {
            this.os.flush();
        }
        if (this.s != null) {
            this.s.flush();
        }
        this.statusCode = 200;
        this.statusMessage = "OK";
        int n = 0;
        while (n < this.headerKeys.size()) {
            String string = (String)this.headerKeys.get(n);
            String string2 = (String)this.headerValues.get(n);
            hashtable.put(string.toLowerCase(), string2);
            ++n;
        }
        this.headerKeys.clear();
        this.headerValues.clear();
        this.charEncoding = null;
        this.contentType = null;
        this.locale = null;
        this.s.setLocale(null);
        this.s.setEncoding(null);
        TempBuffer tempBuffer = this.responseStream.startChaining();
        this.allowKeepalive = false;
        this.contentLength = 0;
        this.disableHeaders = false;
        return tempBuffer;
    }

    public void setStatus(int n, String string) {
        block15: {
            if (n == 304 && this.cache != null) {
                try {
                    this.cache.fillFromCache(this.request, this, false);
                    this.closeConnection();
                    this.finish(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            if (n < 0) {
                n = 500;
            }
            if (string == null) {
                if (n == 200) {
                    string = "OK";
                } else if (n == 304) {
                    string = "Not Modified";
                } else if (string == null && (string = (String)errors.get(String.valueOf(n))) == null) {
                    string = "Internal Server Error";
                }
            }
            this.statusCode = n;
            this.statusMessage = string;
            if (this.statusCode != 200 && this.statusCode != 302 && this.statusCode != 304) {
                String string2;
                Application application = this.request.getApplication();
                String string3 = string2 = application != null ? application.getErrorPage(this.statusCode) : null;
                if (string2 == null && application != null) {
                    string2 = application.getErrorPage(0);
                }
                if (string2 != null) {
                    try {
                        this.request.setAttribute("javax.servlet.error.status_code", String.valueOf(this.statusCode));
                        this.request.setAttribute("javax.servlet.error.message", this.statusMessage);
                        QRequestDispatcher qRequestDispatcher = (QRequestDispatcher)application.getRequestDispatcher(string2);
                        this.setHeader("Cache-Control", "no-cache");
                        qRequestDispatcher.forward(this.request, this, "GET");
                        this.finish(false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!dbg.canWrite()) break block15;
                        dbg.log(exception);
                    }
                }
            }
        }
    }

    public void setStatus(int n) {
        this.setStatus(n, null);
    }

    int getStatusCode() {
        return this.statusCode;
    }

    public void sendError(int n, String string) throws IOException {
        block6: {
            if (n == 304 && this.cache != null) {
                this.setStatus(n, string);
                return;
            }
            this.s.clearWrite();
            this.responseStream.clear();
            if (this.responseStream.isCommitted()) {
                throw new IllegalStateException("response can't sendError() after commit");
            }
            this.setStatus(n, string);
            try {
                this.setContentType("text/html");
                WriteStream writeStream = this.getStream();
                writeStream.print("<title>");
                writeStream.print(n);
                writeStream.print(" ");
                writeStream.print(this.statusMessage);
                writeStream.println("</title>");
                writeStream.print("<h1>");
                writeStream.print(n);
                writeStream.print(" ");
                writeStream.print(this.statusMessage);
                writeStream.println("</h1>");
                if (n == 404) {
                    writeStream.print(this.request.getPageURI());
                    writeStream.println(" was not found on this server.<p>");
                }
                if (!CauchoSystem.isTesting()) {
                    writeStream.println("<hr>");
                    writeStream.println("<small>");
                    writeStream.println(Version.VERSION);
                    writeStream.println("</small>");
                    writeStream.println("</address>");
                }
            }
            catch (Exception exception) {
                if (!dbg.canWrite()) break block6;
                dbg.log(exception);
            }
        }
        this.closeConnection();
        this.finish(true);
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, null);
    }

    public void sendRedirect(String string) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", string);
        this.closeConnection();
        this.finish(true);
    }

    public boolean containsHeader(String string) {
        int n = 0;
        while (n < this.headerKeys.size()) {
            String string2 = (String)this.headerKeys.get(n);
            if (string2.equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getHeader(String string) {
        int n = 0;
        while (n < this.headerKeys.size()) {
            String string2 = (String)this.headerKeys.get(n);
            if (string2.equalsIgnoreCase(string)) {
                return (String)this.headerValues.get(n);
            }
            ++n;
        }
        return null;
    }

    public void setHeader(String string, String string2) {
        if (this.disableHeaders) {
            return;
        }
        if (string.equalsIgnoreCase("content-type")) {
            this.setContentType(string2);
            return;
        }
        int n = 0;
        while (n < this.headerKeys.size()) {
            String string3 = (String)this.headerKeys.get(n);
            if (string3.equalsIgnoreCase(string)) break;
            ++n;
        }
        if (n == this.headerKeys.size()) {
            this.headerKeys.add(string);
            this.headerValues.add(string2);
        } else {
            this.headerValues.set(n, string2);
        }
    }

    public void addHeader(String string, String string2) {
        if (this.disableHeaders) {
            return;
        }
        this.headerKeys.add(string);
        this.headerValues.add(string2);
    }

    public void setIntHeader(String string, int n) {
        this.cb.clear();
        this.cb.append(n);
        this.setHeader(string, this.cb.toString());
    }

    public void addIntHeader(String string, int n) {
        this.cb.clear();
        this.cb.append(n);
        this.addHeader(string, this.cb.toString());
    }

    public void setDateHeader(String string, long l) {
        this.calendar.calculate(l, false);
        this.setHeader(string, this.calendar.toString());
    }

    public void addDateHeader(String string, long l) {
        this.calendar.calculate(l, false);
        this.addHeader(string, this.calendar.toString());
    }

    public void setContentLength(int n) {
        this.cb.clear();
        this.cb.append(n);
        this.setHeader("Content-Length", this.cb.toString());
    }

    public void setContentType(String string) {
        if (this.disableHeaders) {
            return;
        }
        if (string == "text/html" || string.equals("text/html")) {
            this.contentType = "text/html";
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n && string.charAt(n2) != ';' && !Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        this.contentType = string.substring(0, n2);
        while ((n2 = string.indexOf(59, n2)) > 0) {
            ++n2;
            while (n2 < n && XmlChar.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            int n3 = string.indexOf(61, n2);
            if (n3 < 0) break;
            if (string.substring(n2, n3).equals("charset")) {
                ++n3;
                while (n3 < n && XmlChar.isWhitespace(string.charAt(n3))) {
                    ++n3;
                }
                String string2 = string.substring(n3);
                this.charEncoding = Encoding.getMimeName(string2);
                try {
                    if (this.charEncoding == null) break;
                    this.s.setEncoding(this.charEncoding);
                }
                catch (IOException iOException) {}
                break;
            }
            n2 = n3;
        }
    }

    public String getCharacterEncoding() {
        return this.charEncoding == null ? "ISO-8859-1" : this.charEncoding;
    }

    String getRealCharacterEncoding() {
        return this.charEncoding;
    }

    public void addCookie(Cookie cookie) {
        this.request.setUsesCookies();
        if (this.disableHeaders) {
            return;
        }
        if (cookie == null) {
            return;
        }
        this.cookiesOut.add(cookie);
        if (this.cookiesOut.size() == 1) {
            this.setHeader("Cache-Control", "no-cache=\"set-cookie,set-cookie2\"");
            this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        }
    }

    void setSessionId(String string) {
        this.sessionId = string;
    }

    public WriteStream getStream() {
        return this.s;
    }

    public void setStream(WriteStream writeStream) {
        this.s = writeStream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.os.init(this.s);
        return this.os;
    }

    public PrintWriter getWriter() throws IOException {
        return this.s.getPrintWriter();
    }

    public String encodeURL(String string) {
        if (this.request.isRequestedSessionIdFromCookie()) {
            return string;
        }
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession == null) {
            return string;
        }
        if (!this.request.getApplication().enableSessionUrls()) {
            return string;
        }
        this.cb.clear();
        boolean bl = false;
        int n = string.indexOf(63);
        if (n >= 0) {
            this.cb.append(string.substring(0, n));
            this.cb.append(";jsessionid=");
            this.cb.append(httpSession.getId());
            this.cb.append(string.substring(n));
        } else {
            this.cb.append(string);
            this.cb.append(";jsessionid=");
            this.cb.append(httpSession.getId());
        }
        return this.cb.toString();
    }

    public String encodeRedirectURL(String string) {
        return this.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public void setBufferSize(int n) {
        this.responseStream.setBufferSize(n);
    }

    public int getBufferSize() {
        return this.responseStream.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.s.flush();
        this.responseStream.flushBuffer(false);
    }

    public boolean isCommitted() {
        return this.responseStream.isCommitted();
    }

    public void reset() {
        this.reset(false);
    }

    void reset(boolean bl) {
        this.s.clearWrite();
        this.responseStream.clear();
        if (!bl && this.responseStream.isCommitted()) {
            throw new IllegalStateException("response cannot be reset() when committed");
        }
        this.statusCode = 200;
        this.statusMessage = "OK";
        this.headerKeys.clear();
        this.headerValues.clear();
        this.cookiesOut.clear();
        this.charEncoding = null;
        this.locale = null;
        try {
            this.s.setLocale(null);
            this.s.setEncoding(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clearBuffer() {
        this.s.clearWrite();
        this.responseStream.clear();
        if (this.responseStream.isCommitted()) {
            throw new IllegalStateException("response cannot be reset() when committed");
        }
        this.charEncoding = null;
        this.locale = null;
        try {
            this.s.setLocale(null);
            this.s.setEncoding(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        try {
            this.s.setLocale(locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.charEncoding == null) {
            this.charEncoding = Encoding.getMimeName(locale);
        }
        this.setHeader("Content-Language", locale.toString());
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    int getContentLength() {
        return this.responseStream.getContentLength();
    }

    void closeConnection() {
        this.allowKeepalive = false;
    }

    boolean allowKeepalive() {
        return this.allowKeepalive;
    }

    public boolean disableHeaders(boolean bl) {
        boolean bl2 = this.disableHeaders;
        this.disableHeaders = bl;
        return bl2;
    }

    public boolean disableCaching(boolean bl) {
        boolean bl2 = this.disableCaching;
        this.disableCaching = bl;
        return bl2;
    }

    boolean writeHeaders(WriteStream writeStream, int n) throws IOException {
        if (this.getFilter() != null) {
            this.initChaining();
            return false;
        }
        WriteStream writeStream2 = null;
        if (this.statusCode == 200 && !this.disableCaching && this.getBufferSize() > 0) {
            writeStream2 = this.request.allowCaching(this, this.headerKeys, this.headerValues, this.contentType, this.charEncoding);
        }
        if (writeStream2 != null) {
            this.responseStream.setCache(writeStream2);
        } else if (this.statusCode == 200 && this.request.getMethodBuffer() != null && this.request.getMethodBuffer().matches("HEAD")) {
            n = 0;
            this.responseStream.setHead();
        }
        if (this.request.getVaryCookies() && this.request.isCacheable() && this.sessionId == null) {
            this.addHeader("Cache-Control", "no-cache");
            this.addHeader("Pragma", "no-cache");
        }
        if (this.sessionId != null) {
            Cookie cookie = new Cookie("JSESSIONID", this.sessionId);
            cookie.setPath("/");
            this.addCookie(cookie);
        }
        return this.writeHeadersInt(writeStream, n);
    }

    abstract boolean writeHeadersInt(WriteStream var1, int var2) throws IOException;

    protected void fillCookie(CharBuffer charBuffer, Cookie cookie, long l) {
        int n = cookie.getVersion();
        charBuffer.clear();
        charBuffer.append(cookie.getName());
        charBuffer.append("=");
        charBuffer.append(cookie.getValue());
        if (cookie.getDomain() != null && !cookie.getDomain().equals("")) {
            charBuffer.append(";Domain=");
            charBuffer.append(cookie.getDomain());
        }
        if (cookie.getPath() != null && !cookie.getPath().equals("")) {
            charBuffer.append(";Path=");
            charBuffer.append(cookie.getPath());
        }
        if (cookie.getSecure()) {
            charBuffer.append(";Secure");
        }
        if (cookie.getMaxAge() >= 0) {
            charBuffer.append(";Max-Age=");
            charBuffer.append(cookie.getMaxAge());
            this.calendar.calculate(l + 1000L * (long)cookie.getMaxAge(), false);
            charBuffer.append(";Expires=");
            charBuffer.append(this.calendar.printDate());
        }
        if (cookie.getVersion() > 0) {
            charBuffer.append(";Version=");
            charBuffer.append(cookie.getVersion());
            if (cookie.getComment() != null) {
                charBuffer.append(";Comment=\"");
                charBuffer.append(cookie.getComment());
                charBuffer.append("\"");
            }
        }
    }

    protected void initChaining() {
        this.isChaining = true;
        this.responseStream.setFlush(false);
    }

    void killChaining() {
        this.isChaining = false;
        this.responseStream.setFlush(true);
    }

    protected Response() {
        this.os = new QServletOutputStream();
        this.responseStream = new ResponseStream();
        this.s = new WriteStream();
    }

    Response(AbstractRequest abstractRequest) {
        this.request = abstractRequest;
        this.os = new QServletOutputStream();
        this.responseStream = new ResponseStream();
        this.s = new WriteStream();
    }

    static {
        errors.put("100", "Continue");
        errors.put("101", "Switching Protocols");
        errors.put("200", "OK");
        errors.put("201", "Created");
        errors.put("202", "Accepted");
        errors.put("203", "Non-Authoritative Information");
        errors.put("204", "No Content");
        errors.put("205", "Reset Content");
        errors.put("206", "Partial Content");
        errors.put("300", "Multiple Choices");
        errors.put("301", "Moved Perminantly");
        errors.put("302", "Found");
        errors.put("303", "See Other");
        errors.put("304", "Not Modified");
        errors.put("305", "Use Proxy");
        errors.put("307", "Temporary Redirect");
        errors.put("400", "Bad Request");
        errors.put("401", "Unauthorized");
        errors.put("402", "Payment Required");
        errors.put("403", "Forbidden");
        errors.put("404", "Not Found");
        errors.put("405", "Method Not Allowed");
        errors.put("406", "Not Acceptable");
        errors.put("407", "Proxy Authentication Required");
        errors.put("408", "Request Timeout");
        errors.put("409", "Conflict");
        errors.put("410", "Gone");
        errors.put("411", "Length Required");
        errors.put("412", "Precondition Failed");
        errors.put("413", "Request Entity Too Large");
        errors.put("414", "Request-URI Too Long");
        errors.put("415", "Unsupported Media Type");
        errors.put("416", "Requested Range Not Satisfiable");
        errors.put("417", "Expectation Failed");
        errors.put("500", "Internal Server Error");
        errors.put("501", "Not Implemented");
        errors.put("502", "Bad Gateway");
        errors.put("503", "Service Unavailable");
        errors.put("504", "Gateway Timeout");
        errors.put("505", "Http Version Not Supported");
    }
}

