/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.Connection;
import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.BasicPrincipal;
import com.caucho.server.http.Request;
import com.caucho.server.http.RunnerResponse;
import com.caucho.server.http.ServletServer;
import com.caucho.util.Alarm;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

class RunnerRequest
extends Request {
    private static WriteStream dbg = LogStream.open("/caucho.com/http/request");
    public static final int CSE_NULL = 63;
    public static final int CSE_PATH_INFO = 98;
    public static final int CSE_PROTOCOL = 99;
    public static final int CSE_METHOD = 100;
    public static final int CSE_QUERY_STRING = 101;
    public static final int CSE_SERVER_NAME = 102;
    public static final int CSE_SERVER_PORT = 103;
    public static final int CSE_REMOTE_HOST = 104;
    public static final int CSE_REMOTE_ADDR = 105;
    public static final int CSE_REMOTE_PORT = 106;
    public static final int CSE_REAL_PATH = 107;
    public static final int CSE_SCRIPT_FILENAME = 108;
    public static final int CSE_REMOTE_USER = 109;
    public static final int CSE_AUTH_TYPE = 110;
    public static final int CSE_URI = 111;
    public static final int CSE_CONTENT_LENGTH = 112;
    public static final int CSE_CONTENT_TYPE = 113;
    public static final int CSE_IS_SECURE = 114;
    public static final int CSE_SESSION_GROUP = 115;
    public static final int CSE_CLIENT_CERT = 116;
    public static final int CSE_STATUS = 83;
    public static final int CSE_SEND_HEADER = 71;
    public static final int CSE_HEADER = 72;
    public static final int CSE_VALUE = 86;
    public static final int CSE_QUERY = 81;
    public static final int CSE_PING = 80;
    public static final int CSE_DATA = 68;
    public static final int CSE_FLUSH = 70;
    public static final int CSE_KEEPALIVE = 75;
    public static final int CSE_ACK = 65;
    public static final int CSE_END = 90;
    public static final int CSE_CLOSE = 88;
    private CharBuffer method;
    private CharBuffer host;
    private int port;
    private CharBuffer uri;
    private CharBuffer queryString;
    private CharBuffer protocol;
    private int version;
    private CharBuffer remoteAddr;
    private CharBuffer remoteHost;
    private CharBuffer serverName;
    private CharBuffer serverPort;
    private ByteBuffer clientCert;
    private CharBuffer[] headerKeys;
    private CharBuffer[] headerValues;
    private int headerSize;
    private byte[] lengthBuf;
    private ReadStream rawRead;
    private WriteStream rawWrite;
    private ReadStream filterRead;
    private WriteStream filterWrite;
    private ServletFilter filter;
    private int pendingData;
    private CharBuffer cb1;
    private CharBuffer cb2;
    private boolean keepalive;
    private boolean hasRequest;

    public void handleConnection(Connection connection) throws IOException {
        this.setConnection(connection);
        ReadStream readStream = connection.getReadStream();
        WriteStream writeStream = connection.getWriteStream();
        if (dbg.canWrite()) {
            dbg.println("[" + connection.getId() + "] start connection");
        }
        while (this.handleRequest(readStream, writeStream)) {
        }
        if (dbg.canWrite()) {
            dbg.println("[" + connection.getId() + "] close connection");
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean handleRequest(ReadStream var1_1, WriteStream var2_2) throws IOException {
        block42: {
            block37: {
                block36: {
                    block35: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        this.rawStream = null;
                                        this.rawRead = var1_1;
                                        this.rawWrite = var2_2;
                                        if (RunnerRequest.dbg.canWrite()) {
                                            RunnerRequest.dbg.println("[" + this.conn.getId() + "] start request");
                                        }
                                        this.filter.init(this, var1_1, var2_2);
                                        this.filterWrite.init(this.filter);
                                        this.filterWrite.setWritePrefix(4);
                                        this.filterRead.init(this.filter, this.filterWrite);
                                        this.rawStream = this.filterRead;
                                        this.response.init(this.filterWrite);
                                        var3_3 = false;
                                        this.start(this.filterRead);
                                        if (this.scanHeaders()) break block41;
                                        this.keepalive = false;
                                        var6_4 = false;
                                        var5_6 = null;
                                        if (var3_3) break block28;
                                        this.response.headersWritten = true;
                                    }
                                    try {
                                        this.finish();
                                    }
                                    catch (Exception var7_10) {
                                        this.keepalive = false;
                                        if (!RunnerRequest.dbg.canWrite()) break block29;
                                        RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_10);
                                        RunnerRequest.dbg.log(var7_10);
                                    }
                                }
                                try {
                                    this.filterWrite.setDisableClose(false);
                                    this.filterWrite.close();
                                }
                                catch (Exception var7_10) {
                                    this.keepalive = false;
                                    if (!RunnerRequest.dbg.canWrite()) break block30;
                                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_10);
                                    RunnerRequest.dbg.log(var7_10);
                                }
                            }
                            try {
                                this.filterWrite.setDisableClose(false);
                                this.filterRead.close();
                            }
                            catch (Exception var7_10) {
                                this.keepalive = false;
                                if (!RunnerRequest.dbg.canWrite()) break block31;
                                RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_10);
                                RunnerRequest.dbg.log(var7_10);
                            }
                        }
                        if (!RunnerRequest.dbg.canWrite()) ** GOTO lbl-1000
                        RunnerRequest.dbg.println("[" + this.conn.getId() + "] complete request");
lbl-1000:
                        // 2 sources

                        {
                            block41: {
                                return var6_4;
                            }
                            if (this.isSecure) {
                                this.getClientCertificate();
                            }
                            var3_3 = true;
                            this.filter.setPending(this.pendingData);
                            try {
                                this.dispatch(this.getHost(), this.uri);
                            }
                            catch (Exception var7_11) {
                                block34: {
                                    block33: {
                                        block32: {
                                            if (RunnerRequest.dbg.canWrite()) {
                                                RunnerRequest.dbg.log(var7_11);
                                            }
                                            var6_5 = false;
                                            var5_7 = null;
                                            if (!var3_3) {
                                                this.response.headersWritten = true;
                                            }
                                            try {
                                                this.finish();
                                            }
                                            catch (Exception var7_12) {
                                                this.keepalive = false;
                                                if (!RunnerRequest.dbg.canWrite()) break block32;
                                                RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_12);
                                                RunnerRequest.dbg.log(var7_12);
                                            }
                                        }
                                        try {
                                            this.filterWrite.setDisableClose(false);
                                            this.filterWrite.close();
                                        }
                                        catch (Exception var7_12) {
                                            this.keepalive = false;
                                            if (!RunnerRequest.dbg.canWrite()) break block33;
                                            RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_12);
                                            RunnerRequest.dbg.log(var7_12);
                                        }
                                    }
                                    try {
                                        this.filterWrite.setDisableClose(false);
                                        this.filterRead.close();
                                    }
                                    catch (Exception var7_12) {
                                        this.keepalive = false;
                                        if (!RunnerRequest.dbg.canWrite()) break block34;
                                        RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_12);
                                        RunnerRequest.dbg.log(var7_12);
                                    }
                                }
                                if (RunnerRequest.dbg.canWrite()) {
                                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] complete request");
                                }
                                return var6_5;
                            }
                        }
                        var5_8 = null;
                        if (!var3_3) {
                            this.response.headersWritten = true;
                        }
                        try {
                            this.finish();
                        }
                        catch (Exception var7_13) {
                            this.keepalive = false;
                            if (!RunnerRequest.dbg.canWrite()) break block35;
                            RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_13);
                            RunnerRequest.dbg.log(var7_13);
                        }
                    }
                    try {
                        this.filterWrite.setDisableClose(false);
                        this.filterWrite.close();
                    }
                    catch (Exception var7_13) {
                        this.keepalive = false;
                        if (!RunnerRequest.dbg.canWrite()) break block36;
                        RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_13);
                        RunnerRequest.dbg.log(var7_13);
                    }
                }
                try {
                    this.filterWrite.setDisableClose(false);
                    this.filterRead.close();
                }
                catch (Exception var7_13) {
                    this.keepalive = false;
                    if (!RunnerRequest.dbg.canWrite()) break block37;
                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_13);
                    RunnerRequest.dbg.log(var7_13);
                }
            }
            if (RunnerRequest.dbg.canWrite()) {
                RunnerRequest.dbg.println("[" + this.conn.getId() + "] complete request");
            }
            break block42;
            catch (Throwable var4_15) {
                block40: {
                    block39: {
                        block38: {
                            var5_9 = null;
                            if (!var3_3) {
                                this.response.headersWritten = true;
                            }
                            try {
                                this.finish();
                            }
                            catch (Exception var7_14) {
                                this.keepalive = false;
                                if (!RunnerRequest.dbg.canWrite()) break block38;
                                RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_14);
                                RunnerRequest.dbg.log(var7_14);
                            }
                        }
                        try {
                            this.filterWrite.setDisableClose(false);
                            this.filterWrite.close();
                        }
                        catch (Exception var7_14) {
                            this.keepalive = false;
                            if (!RunnerRequest.dbg.canWrite()) break block39;
                            RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_14);
                            RunnerRequest.dbg.log(var7_14);
                        }
                    }
                    try {
                        this.filterWrite.setDisableClose(false);
                        this.filterRead.close();
                    }
                    catch (Exception var7_14) {
                        this.keepalive = false;
                        if (!RunnerRequest.dbg.canWrite()) break block40;
                        RunnerRequest.dbg.println("[" + this.conn.getId() + "] " + var7_14);
                        RunnerRequest.dbg.log(var7_14);
                    }
                }
                if (RunnerRequest.dbg.canWrite()) {
                    RunnerRequest.dbg.println("[" + this.conn.getId() + "] complete request");
                }
                throw var4_15;
            }
        }
        return this.keepalive;
    }

    private void getClientCertificate() {
        block3: {
            if (this.clientCert.size() == 0) {
                return;
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                InputStream inputStream = this.clientCert.createInputStream();
                Certificate certificate = certificateFactory.generateCertificate(inputStream);
                inputStream.close();
                this.setAttribute("javax.servlet.request.X509Certificate", certificate);
                this.setAttribute(AbstractRequest.LOGIN_NAME, ((X509Certificate)certificate).getSubjectDN());
            }
            catch (Throwable throwable) {
                if (!dbg.canWrite()) break block3;
                dbg.log(throwable);
            }
        }
    }

    protected void start(ReadStream readStream) throws IOException {
        super.start(readStream);
        this.method.clear();
        this.protocol.clear();
        this.version = 0;
        this.uri.clear();
        this.queryString.clear();
        this.host.clear();
        this.port = 0;
        this.headerSize = 0;
        this.remoteHost.clear();
        this.remoteAddr.clear();
        this.serverName.clear();
        this.serverPort.clear();
        this.clientCert.clear();
        this.pendingData = 0;
        this.keepalive = true;
    }

    private boolean scanHeaders() throws IOException {
        boolean bl = true;
        this.conn.setAccessTime(-1L);
        this.conn.setIdle();
        block22: while (this.rawRead.readAll(this.lengthBuf, 0, 4) == 4) {
            if (bl) {
                this.conn.setActive();
                bl = false;
            }
            this.conn.setAccessTime(Alarm.getCurrentTime());
            int n = this.lengthBuf[0] & 0xFF;
            int n2 = ((this.lengthBuf[1] & 0xFF) << 16) + ((this.lengthBuf[2] & 0xFF) << 8) + (this.lengthBuf[3] & 0xFF);
            switch (n) {
                case 107: {
                    this.cb1.clear();
                    this.rawRead.readAll(this.cb1, n2);
                    n = this.rawRead.read();
                    if (n != 86) {
                        throw new IOException("protocol expected CSE_VALUE");
                    }
                    this.cb2.clear();
                    this.rawRead.readAll(this.cb2, this.readLength());
                    if (!dbg.canWrite()) continue block22;
                    dbg.log("[" + this.conn.getId() + "]" + (char)n + " " + this.cb1.toString() + "->" + this.cb2.toString());
                    break;
                }
                case 104: {
                    this.rawRead.readAll(this.remoteHost, n2);
                    if (!dbg.canWrite()) continue block22;
                    dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + this.remoteHost);
                    break;
                }
                case 105: {
                    this.rawRead.readAll(this.remoteAddr, n2);
                    if (!dbg.canWrite()) continue block22;
                    dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + this.remoteAddr);
                    break;
                }
                case 102: {
                    this.rawRead.readAll(this.serverName, n2);
                    if (!dbg.canWrite()) continue block22;
                    dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + this.serverName);
                    break;
                }
                case 103: {
                    this.rawRead.readAll(this.serverPort, n2);
                    if (!dbg.canWrite()) continue block22;
                    dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + this.serverPort);
                    break;
                }
                case 100: {
                    this.rawRead.readAll(this.method, n2);
                    if (!dbg.canWrite()) continue block22;
                    dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + this.method);
                    break;
                }
                case 111: {
                    this.rawRead.readAll(this.uri, n2);
                    if (!dbg.canWrite()) continue block22;
                    dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + this.uri);
                    break;
                }
                case 101: {
                    this.rawRead.readAll(this.queryString, n2);
                    if (!dbg.canWrite()) continue block22;
                    dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + this.queryString);
                    break;
                }
                case 99: {
                    char c;
                    this.rawRead.readAll(this.protocol, n2);
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + this.protocol);
                    }
                    int n3 = 0;
                    while (n3 < n2) {
                        c = this.protocol.charAt(n3);
                        if (c >= '0' && c <= '9') {
                            this.version = 16 * this.version + c - 48;
                        } else if (c == '.') {
                            this.version = 16 * this.version;
                        }
                        ++n3;
                    }
                    continue block22;
                }
                case 72: {
                    if (this.headerSize >= this.headerKeys.length) {
                        this.resizeHeaders();
                    }
                    this.headerKeys[this.headerSize].clear();
                    this.rawRead.readAll(this.headerKeys[this.headerSize], n2);
                    n = this.rawRead.read();
                    if (n != 86) {
                        throw new IOException("protocol expected CSE_VALUE");
                    }
                    this.headerValues[this.headerSize].clear();
                    this.rawRead.readAll(this.headerValues[this.headerSize], this.readLength());
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + this.headerKeys[this.headerSize] + "=" + this.headerValues[this.headerSize]);
                    }
                    ++this.headerSize;
                    break;
                }
                case 112: {
                    if (this.headerSize >= this.headerKeys.length) {
                        this.resizeHeaders();
                    }
                    this.headerKeys[this.headerSize].clear();
                    this.headerKeys[this.headerSize].append("Content-Length");
                    this.headerValues[this.headerSize].clear();
                    this.rawRead.readAll(this.headerValues[this.headerSize], n2);
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] " + (char)n + " content-length=" + this.headerValues[this.headerSize]);
                    }
                    ++this.headerSize;
                    break;
                }
                case 113: {
                    if (this.headerSize >= this.headerKeys.length) {
                        this.resizeHeaders();
                    }
                    this.headerKeys[this.headerSize].clear();
                    this.headerKeys[this.headerSize].append("Content-Type");
                    this.headerValues[this.headerSize].clear();
                    this.rawRead.readAll(this.headerValues[this.headerSize], n2);
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] " + (char)n + " content-type=" + this.headerValues[this.headerSize]);
                    }
                    ++this.headerSize;
                    break;
                }
                case 115: {
                    char c;
                    this.cb1.clear();
                    this.rawRead.readAll(this.cb1, n2);
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] " + (char)n + " session_group=" + this.cb1);
                    }
                    this.sessionGroup = 0;
                    int n3 = 0;
                    while (n3 < n2) {
                        c = this.cb1.charAt(n3);
                        if (c >= '0' && c <= '9') {
                            this.sessionGroup = 10 * this.sessionGroup + c - 48;
                        }
                        ++n3;
                    }
                    continue block22;
                }
                case 114: {
                    this.isSecure = true;
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] secure");
                    }
                    this.rawRead.skip(n2);
                    break;
                }
                case 116: {
                    this.clientCert.clear();
                    this.clientCert.setLength(n2);
                    this.rawRead.readAll(this.clientCert.getBuffer(), 0, n2);
                    if (!dbg.canWrite()) continue block22;
                    dbg.log("[" + this.conn.getId() + "] " + (char)n + " cert=" + this.clientCert);
                    break;
                }
                case 109: {
                    this.cb.clear();
                    this.rawRead.readAll(this.cb, n2);
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + this.cb);
                    }
                    this.setAttribute(AbstractRequest.LOGIN_NAME, new BasicPrincipal(this.cb.toString()));
                    break;
                }
                case 68: {
                    this.pendingData = n2;
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + n2);
                    }
                    return true;
                }
                case 90: {
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + n2);
                    }
                    return true;
                }
                case 80: {
                    this.rawWrite.write(90);
                    this.rawWrite.write(0);
                    this.rawWrite.write(0);
                    this.rawWrite.write(0);
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + n2);
                    }
                    return false;
                }
                case 88: {
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] close");
                    }
                    this.filter.setClientClosed(true);
                    this.keepalive = false;
                    return true;
                }
                default: {
                    if (dbg.canWrite()) {
                        dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + n2);
                    }
                    this.rawRead.skip(n2);
                    break;
                }
            }
        }
        this.filter.setClientClosed(true);
        return false;
    }

    private void resizeHeaders() {
        CharBuffer[] charBufferArray = new CharBuffer[this.headerSize * 2];
        CharBuffer[] charBufferArray2 = new CharBuffer[this.headerSize * 2];
        int n = 0;
        while (n < this.headerSize) {
            charBufferArray[n] = this.headerKeys[n];
            charBufferArray2[n] = this.headerValues[n];
            ++n;
        }
        n = this.headerSize;
        while (n < charBufferArray.length) {
            charBufferArray[n] = new CharBuffer();
            charBufferArray2[n] = new CharBuffer();
            ++n;
        }
        this.headerKeys = charBufferArray;
        this.headerValues = charBufferArray2;
    }

    private int readLength() throws IOException {
        return (this.rawRead.read() << 16) + (this.rawRead.read() << 8) + this.rawRead.read();
    }

    public String getScheme() {
        if (this.isSecure()) {
            return "https";
        }
        return "http";
    }

    public CharBuffer getMethodBuffer() {
        return this.method;
    }

    CharBuffer getHost() {
        if (this.host.length() != 0) {
            return this.host;
        }
        this.host.append(this.serverName);
        if (this.serverPort.length() > 0) {
            this.host.append(':');
            this.host.append(this.serverPort);
        }
        this.host.toLowerCase();
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public CharBuffer getPageUriBuffer() {
        return this.uri;
    }

    public CharBuffer getPageQueryBuffer() {
        return this.queryString;
    }

    public String getQueryString() {
        if (this.queryString.length() == 0) {
            return null;
        }
        return this.queryString.toString();
    }

    public CharBuffer getProtocolBuffer() {
        return this.protocol;
    }

    int getVersion() {
        return this.version;
    }

    public CharBuffer getHeaderBuffer(String string) {
        int n = 0;
        while (n < this.headerSize) {
            CharBuffer charBuffer = this.headerKeys[n];
            if (charBuffer.equalsIgnoreCase(string)) {
                return this.headerValues[n];
            }
            ++n;
        }
        return null;
    }

    public void setHeader(String string, String string2) {
        this.headerKeys[this.headerSize].clear();
        this.headerKeys[this.headerSize].append(string);
        this.headerValues[this.headerSize].clear();
        this.headerValues[this.headerSize].append(string2);
        ++this.headerSize;
    }

    public void getHeaderBuffers(ArrayList arrayList, String string) {
        this.cb.clear();
        this.cb.append(string);
        int n = this.headerSize;
        int n2 = 0;
        while (n2 < n) {
            CharBuffer charBuffer = this.headerKeys[n2];
            if (charBuffer.equalsIgnoreCase(this.cb)) {
                arrayList.add(this.headerValues[n2]);
            }
            ++n2;
        }
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.headerSize) {
            arrayList.add(this.headerKeys[n].toString());
            ++n;
        }
        return Collections.enumeration(arrayList);
    }

    public String getServerName() {
        CharBuffer charBuffer = this.getHost();
        if (charBuffer == null) {
            InetAddress inetAddress = this.conn.getRemoteAddress();
            return inetAddress.getHostName();
        }
        int n = charBuffer.indexOf(':');
        if (n >= 0) {
            return charBuffer.substring(0, n);
        }
        return charBuffer.toString();
    }

    public int getServerPort() {
        int n = this.serverPort.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = this.serverPort.charAt(n3);
            n2 = 10 * n2 + c - 48;
            ++n3;
        }
        return n2;
    }

    public String getRemoteAddr() {
        return this.remoteAddr.toString();
    }

    public String getRemoteHost() {
        return this.remoteHost.toString();
    }

    void writeStatus(CharBuffer charBuffer) throws IOException {
        this.writeString(83, charBuffer);
    }

    void sendHeader() throws IOException {
        this.writeString(71, "");
    }

    void writeHeader(String string, String string2) throws IOException {
        this.writeString(72, string);
        this.writeString(86, string2);
    }

    void writeHeader(String string, CharBuffer charBuffer) throws IOException {
        this.writeString(72, string);
        this.writeString(86, charBuffer);
    }

    void writeString(int n, String string) throws IOException {
        int n2 = string.length();
        this.lengthBuf[0] = (byte)n;
        this.lengthBuf[1] = (byte)(n2 >> 16);
        this.lengthBuf[2] = (byte)(n2 >> 8);
        this.lengthBuf[3] = (byte)n2;
        this.rawWrite.write(this.lengthBuf, 0, 4);
        this.rawWrite.print(string);
        if (dbg.canWrite()) {
            dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + string);
        }
    }

    void writeString(int n, CharBuffer charBuffer) throws IOException {
        int n2 = charBuffer.length();
        this.lengthBuf[0] = (byte)n;
        this.lengthBuf[1] = (byte)(n2 >> 16);
        this.lengthBuf[2] = (byte)(n2 >> 8);
        this.lengthBuf[3] = (byte)n2;
        this.rawWrite.write(this.lengthBuf, 0, 4);
        this.rawWrite.print(charBuffer.getBuffer(), 0, n2);
        if (dbg.canWrite()) {
            dbg.log("[" + this.conn.getId() + "] " + (char)n + " " + charBuffer);
        }
    }

    RunnerRequest(ServletServer servletServer) {
        super(servletServer);
        this.response = new RunnerResponse(this);
        this.uri = new CharBuffer();
        this.method = new CharBuffer();
        this.host = new CharBuffer();
        this.protocol = new CharBuffer();
        this.queryString = new CharBuffer();
        this.headerKeys = new CharBuffer[32];
        this.headerValues = new CharBuffer[32];
        int n = 0;
        while (n < this.headerKeys.length) {
            this.headerKeys[n] = new CharBuffer();
            this.headerValues[n] = new CharBuffer();
            ++n;
        }
        this.remoteHost = new CharBuffer();
        this.remoteAddr = new CharBuffer();
        this.serverName = new CharBuffer();
        this.serverPort = new CharBuffer();
        this.clientCert = new ByteBuffer();
        this.cb1 = new CharBuffer();
        this.cb2 = new CharBuffer();
        this.lengthBuf = new byte[16];
        this.filterRead = new ReadStream();
        this.filterWrite = new WriteStream();
        this.filter = new ServletFilter();
    }

    static class ServletFilter
    extends StreamImpl {
        RunnerRequest request;
        ReadStream nextRead;
        WriteStream nextWrite;
        byte[] buffer = new byte[16];
        int pendingData;
        boolean isClosed;
        boolean isClientClosed;

        void init(RunnerRequest runnerRequest, ReadStream readStream, WriteStream writeStream) {
            this.request = runnerRequest;
            this.nextRead = readStream;
            this.nextWrite = writeStream;
            this.pendingData = 0;
            this.isClosed = false;
            this.isClientClosed = false;
        }

        void setPending(int n) {
            this.pendingData = n;
        }

        void setClientClosed(boolean bl) {
            this.isClientClosed = bl;
        }

        public boolean canRead() {
            return true;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.pendingData <= 0) {
                return -1;
            }
            int n3 = this.pendingData;
            if (n2 < n3) {
                n3 = n2;
            }
            int n4 = this.nextRead.read(byArray, n, n3);
            this.pendingData -= n4;
            if (this.pendingData == 0) {
                if (this.nextRead.getAvailable() <= 0) {
                    this.buffer[0] = 65;
                    this.buffer[1] = 0;
                    this.buffer[2] = 0;
                    this.buffer[3] = 0;
                    this.nextWrite.write(this.buffer, 0, 4);
                }
                int n5 = this.nextRead.read();
                int n6 = (this.nextRead.read() << 16) + (this.nextRead.read() << 8) + this.nextRead.read();
                if (n5 == 68) {
                    this.pendingData = n6;
                } else {
                    return n4;
                }
            }
            return n4;
        }

        public boolean canWrite() {
            return true;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            n2 -= 4;
            if (dbg.canWrite()) {
                dbg.log("[" + this.request.conn.getId() + "] d " + n2);
            }
            byArray[0] = 68;
            byArray[1] = (byte)(n2 >> 16);
            byArray[2] = (byte)(n2 >> 8);
            byArray[3] = (byte)n2;
            this.nextWrite.write(byArray, n, n2 + 4);
        }

        public void flush() throws IOException {
            this.buffer[0] = 70;
            this.buffer[1] = 0;
            this.buffer[2] = 0;
            this.buffer[3] = 0;
            this.nextWrite.write(this.buffer, 0, 4);
            this.nextWrite.flush();
        }

        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.pendingData > 0) {
                this.nextRead.skip(this.pendingData);
                this.pendingData = 0;
            }
            if (!this.isClientClosed) {
                this.buffer[1] = 0;
                this.buffer[2] = 0;
                this.buffer[3] = 0;
                if (!this.request.keepalive || this.request.conn.isInterrupted() || !this.request.conn.allocateKeepalive()) {
                    this.request.keepalive = false;
                }
                if (dbg.canWrite()) {
                    dbg.log("[" + this.request.conn.getId() + "] " + (this.request.keepalive ? "Z" : "X"));
                }
                this.buffer[0] = (byte)(this.request.keepalive ? 90 : 88);
                this.nextWrite.write(this.buffer, 0, 4);
            }
            this.nextWrite.flush();
        }

        ServletFilter() {
        }
    }
}

