/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.Server;
import com.caucho.server.ServerRequest;
import com.caucho.server.ServerStat;
import com.caucho.server.TcpServer;
import com.caucho.server.http.Application;
import com.caucho.server.http.UrlMap;
import com.caucho.server.http.VirtualHost;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.CharScanner;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.util.SimpleClassLoader;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.CachePath;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Pwd;
import com.caucho.vfs.WriteStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletException;

abstract class ServletServer
implements Server {
    private static CharScanner hostScanner = new CharScanner(" \t:,");
    protected WriteStream dbg = LogStream.open("/caucho.com/http/server");
    private TcpServer server;
    private Path config;
    private long configLastModified;
    private Exception configException;
    private RegistryNode registry;
    private UrlMap hostMap;
    private Hashtable hosts;
    private Hashtable uniqueHosts;
    private VirtualHost defaultHost;
    private long updateInterval;
    private long lastUpdate;
    private ClassLoader parent;
    private DynamicClassLoader loader;
    Path pwd;
    Path serverRoot;
    private int sessionCount;
    private int port;
    private Path cache;
    private long startTime;
    long bogusDate;

    private void init() throws Exception {
        this.bogusDate = this.registry.getInt("bogus-date", 0);
        this.port = this.registry.getInt("port", 80);
        this.hostMap = new UrlMap();
        RegistryNode registryNode = this.registry.lookup("cache");
        if (registryNode != null) {
            int n = registryNode.getInt("entries", 1024);
            int n2 = registryNode.getInt("size", 1024);
            String string = registryNode.getString("dir", "cache");
            if (n2 > 0 && n > 0 && !"".equals(string)) {
                this.cache = new CachePath(Pwd.lookupNative(string), n, n2);
            }
        }
        String string = this.registry.getString("app-dir", ".");
        this.serverRoot = VirtualHost.getAppDir(this.pwd, string);
        this.initClassLoaders();
        this.initHosts();
    }

    private void initClassLoaders() {
        RegistryNode registryNode = Registry.lookup("/caucho.com");
        if (registryNode == null) {
            return;
        }
        ClassLoader classLoader = this.parent;
        this.loader = null;
        Iterator iterator = registryNode.select("classpath");
        while (iterator.hasNext()) {
            RegistryNode registryNode2 = (RegistryNode)iterator.next();
            String string = registryNode2.getString();
            if (string == null) continue;
            Path path = this.serverRoot.lookupNative(string);
            SimpleClassLoader simpleClassLoader = null;
            if (path.isDirectory()) {
                simpleClassLoader = SimpleClassLoader.create(classLoader, path, null);
            } else {
                if (!string.endsWith(".jar") && !string.endsWith(".zip")) continue;
                simpleClassLoader = SimpleClassLoader.create(classLoader, new JarPath(path), null);
            }
            if (this.loader != null) {
                this.loader.setNext(simpleClassLoader);
            }
            this.loader = simpleClassLoader;
        }
        if (this.loader == null) {
            CauchoSystem.setStaticClassLoader(classLoader);
        } else {
            CauchoSystem.setStaticClassLoader(this.loader);
        }
        CauchoSystem.setContextClassLoader(CauchoSystem.getStaticClassLoader());
    }

    public void setServer(TcpServer tcpServer) {
        this.server = tcpServer;
    }

    public TcpServer getServer() {
        return this.server;
    }

    private void initHosts() throws Exception {
        this.hosts = new Hashtable();
        this.uniqueHosts = new Hashtable();
        Iterator iterator = this.registry.iterator();
        while (iterator.hasNext()) {
            RegistryNode registryNode = (RegistryNode)iterator.next();
            if (!registryNode.getName().equals("host")) continue;
            String string = registryNode.getString("regexp", null);
            String string2 = registryNode.getString("app-dir", ".");
            String string3 = registryNode.getValue();
            if (string3 != null && (string3.equals("") || string3.equals("*"))) {
                this.defaultHost = VirtualHost.create(this, "*", registryNode, this.serverRoot.lookup(string2), this.cache);
            }
            if (string != null) {
                this.hostMap.addRegexp(string, "i", null, string2, registryNode);
                continue;
            }
            if (string3 != null) {
                this.addHost(string3, registryNode, string2);
                continue;
            }
            throw Application.error(registryNode, "host needs id or `regexp'");
        }
        if (this.defaultHost == null) {
            this.defaultHost = VirtualHost.create(this, "*", this.registry, this.serverRoot, this.cache);
        }
        this.defaultHost.init();
    }

    private void addHost(String string, RegistryNode registryNode, String string2) throws Exception {
        VirtualHost virtualHost = VirtualHost.create(this, string, registryNode, this.serverRoot.lookupNative(string2), this.cache);
        Host host = new Host(registryNode, string2);
        this.uniqueHosts.put(host, virtualHost);
        CharBuffer charBuffer = new CharBuffer();
        StringCharCursor stringCharCursor = new StringCharCursor(string);
        while (((CharCursor)stringCharCursor).current() != '\uffff') {
            hostScanner.skip(stringCharCursor);
            charBuffer.clear();
            char c = hostScanner.scan(stringCharCursor, charBuffer);
            CharBuffer charBuffer2 = new CharBuffer();
            charBuffer2.append(charBuffer);
            charBuffer2.toLowerCase();
            if (c != ':' || this.hosts.get(charBuffer2) == null) {
                this.hosts.put(charBuffer2, virtualHost);
                this.hostMap.addRegexp(charBuffer2.toString(), "i", null, string2, registryNode);
            }
            charBuffer.append(':');
            if (c == ':') {
                c = ((CharCursor)stringCharCursor).next();
                while (c != '\uffff' && c >= '0' && c <= '9') {
                    charBuffer.append(c);
                    c = ((CharCursor)stringCharCursor).next();
                }
            } else {
                charBuffer.append(this.port);
            }
            charBuffer2 = new CharBuffer();
            charBuffer2.append(charBuffer);
            charBuffer2.toLowerCase();
            this.hosts.put(charBuffer2, virtualHost);
            this.hostMap.addRegexp(charBuffer2.toString(), "i", null, string2, registryNode);
        }
        virtualHost.init();
    }

    Path getPwd() {
        return this.pwd;
    }

    Path getHome() {
        return this.pwd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    VirtualHost getHost(CharBuffer charBuffer) throws ServletException {
        if (this.configException != null) {
            throw new ServletException((Throwable)this.configException);
        }
        if (charBuffer == null) {
            return this.defaultHost;
        }
        Hashtable hashtable = this.hosts;
        synchronized (hashtable) {
            VirtualHost virtualHost;
            block14: {
                virtualHost = (VirtualHost)this.hosts.get(charBuffer);
                if (virtualHost != null) {
                    return virtualHost;
                }
                CharBuffer charBuffer2 = new CharBuffer();
                charBuffer2.append(charBuffer);
                int n = charBuffer.indexOf(':');
                if (n > 0) {
                    charBuffer2.setLength(n);
                }
                CharBuffer charBuffer3 = new CharBuffer();
                RegistryNode registryNode = (RegistryNode)this.hostMap.map(charBuffer.toString(), null, null, charBuffer3);
                if (registryNode == null) {
                    registryNode = (RegistryNode)this.hostMap.map(charBuffer2.toString(), null, null, charBuffer3);
                }
                if (virtualHost == null) {
                    if (registryNode != null) {
                        String string = charBuffer3.toString();
                        Host host = new Host(registryNode, string);
                        virtualHost = (VirtualHost)this.uniqueHosts.get(host);
                        try {
                            if (virtualHost == null) {
                                virtualHost = VirtualHost.create(this, charBuffer.toString(), registryNode, VirtualHost.getAppDir(this.pwd, string), this.cache);
                                this.uniqueHosts.put(host, virtualHost);
                                this.hosts.put(charBuffer.clone(), virtualHost);
                                virtualHost.init();
                                return virtualHost;
                            }
                            break block14;
                        }
                        catch (Exception exception) {
                            if (!this.dbg.canWrite()) throw new ServletException((Throwable)exception);
                            this.dbg.log(exception);
                            throw new ServletException((Throwable)exception);
                        }
                    }
                    if (registryNode == null) {
                        virtualHost = this.defaultHost;
                    }
                }
            }
            this.hosts.put(charBuffer.clone(), virtualHost);
            return virtualHost;
        }
    }

    Application getDefaultApplication() {
        if (this.defaultHost != null) {
            return this.defaultHost.getDefaultApplication();
        }
        return null;
    }

    int incrSession() {
        return this.sessionCount++;
    }

    public void timeout(long l) {
        Object object;
        if (this.lastUpdate + this.updateInterval < l && this.config != null && this.config.getLastModified() > this.configLastModified) {
            this.configException = null;
            try {
                object = Registry.parse(this.config);
                Registry.setDefault((RegistryNode)object);
                this.registry = Registry.lookup("/caucho.com/http-server");
                this.configLastModified = this.config.getLastModified();
                this.close();
                this.init();
            }
            catch (Exception exception) {
                this.updateInterval = 0L;
                this.configException = exception;
                if (this.dbg.canWrite()) {
                    this.dbg.log(exception);
                } else {
                    exception.printStackTrace();
                }
                return;
            }
        }
        if (this.defaultHost == null || this.hosts == null) {
            return;
        }
        this.defaultHost.timeout(l);
        object = this.hosts.elements();
        while (object.hasMoreElements()) {
            VirtualHost virtualHost = (VirtualHost)object.nextElement();
            virtualHost.timeout(l);
        }
    }

    public void cron(long l) {
        this.defaultHost.cron(l);
        Enumeration enumeration = this.hosts.elements();
        while (enumeration.hasMoreElements()) {
            VirtualHost virtualHost = (VirtualHost)enumeration.nextElement();
            virtualHost.cron(l);
        }
    }

    public ServerStat getMinuteStat() {
        return this.server.getMinuteStat();
    }

    public ServerStat getHourStat() {
        return this.server.getHourStat();
    }

    public ServerStat getDayStat() {
        return this.server.getDayStat();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getSlowThreads() {
        return this.server.getSlowThreads();
    }

    public void close() {
        if (this.hosts != null) {
            Enumeration enumeration = this.hosts.elements();
            while (enumeration.hasMoreElements()) {
                VirtualHost virtualHost = (VirtualHost)enumeration.nextElement();
                virtualHost.close();
            }
        }
        if (this.defaultHost != null) {
            this.defaultHost.close();
        }
        this.cache = null;
        this.defaultHost = null;
        this.hosts = null;
    }

    void setDate(long l) {
        this.bogusDate = l;
        this.defaultHost.setDate(l);
    }

    public abstract ServerRequest createRequest();

    protected ServletServer(Path path, RegistryNode registryNode, Path path2) throws Exception {
        if (registryNode == null) {
            throw new ServletException("empty registry");
        }
        this.startTime = Alarm.getCurrentTime();
        this.registry = registryNode;
        this.config = path;
        if (path != null) {
            this.configLastModified = path.getLastModified();
        }
        if (path2 == null) {
            path2 = Pwd.lookup();
        }
        this.pwd = path2;
        this.updateInterval = 1000 * registryNode.getInt("class-update-interval", 2);
        if (this.updateInterval < 0L) {
            this.updateInterval = 0L;
        }
        this.parent = CauchoSystem.getContextClassLoader();
        if (this.parent == null) {
            this.parent = this.getClass().getClassLoader();
        }
        this.init();
    }

    static class Host {
        RegistryNode registry;
        String appDir;

        public int hashCode() {
            return this.registry.hashCode() * 65521 + this.appDir.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Host)) {
                return false;
            }
            Host host = (Host)object;
            return host.registry == this.registry && host.appDir.equals(this.appDir);
        }

        Host(RegistryNode registryNode, String string) {
            this.registry = registryNode;
            this.appDir = string;
        }
    }
}

