/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.regexp.IllegalRegexpException;
import com.caucho.regexp.Regexp;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

class UrlMap {
    private ArrayList regexps = new ArrayList();
    private boolean bestShort;

    void setBestShort() {
        this.bestShort = true;
    }

    int size() {
        return this.regexps.size();
    }

    void addMap(String string, String string2, String string3, String string4, Object object) throws IllegalRegexpException {
        if (string.length() == 0 || string.length() == 1 && string.charAt(0) == '/') {
            this.regexps.add(new RegexpEntry(-1, "", string2, string3, string4, object));
            return;
        }
        int n = string.length();
        boolean bl = true;
        if (string.charAt(0) != '/' && string.charAt(0) != '*') {
            string = "/" + string;
            ++n;
        }
        int n2 = -1;
        boolean bl2 = false;
        CharBuffer charBuffer = new CharBuffer();
        charBuffer.append("^");
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '*' && n3 + 1 == n && n3 > 0 && string.charAt(n3 - 1) == '/') {
                bl = false;
                charBuffer.setLength(charBuffer.length() - 1);
                if (n2 < 0) {
                    n2 = n3 - 1;
                }
                if (n2 == 0) {
                    n2 = 1;
                }
            } else if (c == '*') {
                bl = false;
                charBuffer.append(".*");
                if (n2 < 0) {
                    n2 = n3;
                }
                if (n3 == 0) {
                    bl2 = true;
                }
            } else if (c == '.' || c == '[' || c == '^' || c == '$' || c == '{' || c == '}' || c == '|' || c == '(' || c == ')' || c == '?') {
                charBuffer.append('\\');
                charBuffer.append(c);
            } else {
                charBuffer.append(c);
            }
            ++n3;
        }
        if (bl) {
            charBuffer.append('$');
        } else {
            charBuffer.append("(?=/)|" + charBuffer.toString() + "$");
        }
        if (n2 < 0) {
            n2 = string.length();
        } else if (n2 < string.length() && string.charAt(n2) == '/') {
            --n2;
        }
        this.addRegexp(n2, charBuffer.close(), string2, string3, string4, object, bl2);
    }

    void addMap(String string, Object object) throws IllegalRegexpException {
        this.addMap(string, null, "", "", object);
    }

    void addRegexp(String string, String string2, String string3, String string4, Object object) throws IllegalRegexpException {
        this.addRegexp(0, string, string2, string3, string4, object, false);
    }

    void addRegexp(int n, String string, String string2, String string3, String string4, Object object, boolean bl) throws IllegalRegexpException {
        int n2 = 0;
        while (n2 < this.regexps.size()) {
            RegexpEntry regexpEntry = (RegexpEntry)this.regexps.get(n2);
            if (regexpEntry.getPattern().equals(string)) {
                this.regexps.remove(n2);
                break;
            }
            ++n2;
        }
        RegexpEntry regexpEntry = new RegexpEntry(n, string, string2, string3, string4, object);
        if (bl) {
            regexpEntry.setShortMatch();
        }
        this.regexps.add(regexpEntry);
    }

    Object map(String string, CharBuffer charBuffer, CharBuffer charBuffer2, CharBuffer charBuffer3) {
        Object object = null;
        int n = -1;
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < this.regexps.size()) {
            RegexpEntry regexpEntry;
            RegexpEntry regexpEntry2 = regexpEntry = (RegexpEntry)this.regexps.get(n4);
            synchronized (regexpEntry2) {
                if (regexpEntry.regexp.exec(string, 0) < 0) {
                    Object var12_12 = null;
                } else {
                    int n5 = regexpEntry.regexp.getBegin(0);
                    int n6 = regexpEntry.regexp.getEnd(0);
                    int n7 = n6 - n5;
                    boolean bl = regexpEntry.isShortMatch();
                    if (!(regexpEntry.prefixLength < n || regexpEntry.prefixLength <= n && (n7 < n2 || bl && n7 > n3))) {
                        if (charBuffer != null) {
                            charBuffer.clear();
                            charBuffer.append(string, n5, n7);
                        }
                        if (charBuffer2 != null) {
                            charBuffer2.clear();
                            charBuffer2.append(string, 0, n5);
                            regexpEntry.regexp.replace(string, regexpEntry.pathReplace, charBuffer2);
                            charBuffer2.append(string, n6, string.length() - n6);
                        }
                        if (charBuffer3 != null) {
                            charBuffer3.clear();
                            regexpEntry.regexp.replace(string, regexpEntry.replace2, charBuffer3);
                        }
                        object = regexpEntry.value;
                        n = regexpEntry.prefixLength;
                        n3 = n7;
                        if (!regexpEntry.isShortMatch()) {
                            n2 = n7;
                        }
                        if (regexpEntry.prefixLength > n2) {
                            n2 = regexpEntry.prefixLength;
                        }
                    }
                }
            }
            ++n4;
        }
        return object;
    }

    UrlMap() {
    }

    UrlMap(boolean bl) {
        this.bestShort = bl;
    }

    static class RegexpEntry {
        String pattern;
        String flags;
        Regexp regexp;
        Object value;
        String pathReplace;
        String replace2;
        int prefixLength;
        boolean shortMatch;

        void setShortMatch() {
            this.shortMatch = true;
        }

        boolean isShortMatch() {
            return this.shortMatch;
        }

        String getPattern() {
            return this.pattern;
        }

        RegexpEntry(int n, String string, String string2, String string3, String string4, Object object) throws IllegalRegexpException {
            this.prefixLength = n;
            this.pattern = string;
            if (string2 == null) {
                string2 = CauchoSystem.isWindows() ? "i" : "";
            }
            this.flags = string2;
            this.regexp = new Regexp(string, string2);
            this.value = object;
            if (string3 == null) {
                string3 = "";
            }
            if (string4 == null) {
                string4 = "";
            }
            this.pathReplace = string3;
            this.replace2 = string4;
        }
    }
}

