/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.QPooledConnection;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CauchoSystem;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class DBPool
implements AlarmListener,
Driver {
    private static WriteStream dbg = LogStream.open("/caucho.com/sql/pool");
    private static final String URL_PREFIX = "jdbc:caucho:";
    public static final String PROPERTY_USER_NAME = "user";
    public static final String PROPERTY_PASSWORD = "password";
    private static Hashtable pools = new Hashtable();
    private static ClassLoader staticLoader;
    private static final long POOL_WAIT_TIME = 5000L;
    private String poolName;
    private String driverName;
    private Driver driver;
    private String url;
    private String user;
    private String password;
    private int maxConnections = 20;
    private int nConnections = 0;
    private int activeConnections = 0;
    private boolean isClosed;
    private ArrayList connections = new ArrayList();

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = string.substring(URL_PREFIX.length());
        DBPool dBPool = null;
        try {
            dBPool = DBPool.getPool(string2);
        }
        catch (Exception exception) {
            throw new SQLException("No suitable connection pool " + string2);
        }
        if (dBPool == null) {
            return null;
        }
        Driver driver = dBPool.getDriver();
        if (driver == null) {
            return null;
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (((Hashtable)properties).get(PROPERTY_USER_NAME) == null) {
            ((Hashtable)properties).put(PROPERTY_USER_NAME, dBPool.getUser());
        }
        if (((Hashtable)properties).get(PROPERTY_PASSWORD) == null) {
            ((Hashtable)properties).put(PROPERTY_PASSWORD, dBPool.getPassword());
        }
        return driver.getPropertyInfo(dBPool.getURL(), properties);
    }

    public boolean acceptsURL(String string) throws SQLException {
        return string.startsWith(URL_PREFIX);
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        String string2 = string.substring(URL_PREFIX.length());
        if (string2 == null || string2.equals("")) {
            return null;
        }
        String string3 = null;
        String string4 = null;
        if (properties != null) {
            string3 = properties.getProperty(PROPERTY_USER_NAME);
            string4 = properties.getProperty(PROPERTY_PASSWORD);
        }
        DBPool dBPool = null;
        try {
            dBPool = DBPool.getPool(string2);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getLocalizedMessage());
        }
        if (dBPool != null) {
            return dBPool.getConnection(string3, string4);
        }
        return null;
    }

    public static synchronized DBPool getPool(String string) throws SQLException {
        ClassLoader classLoader = CauchoSystem.getStaticClassLoader();
        if (classLoader != staticLoader) {
            DBPool.closePools();
        }
        staticLoader = classLoader;
        DBPool dBPool = (DBPool)pools.get(string);
        if (dBPool != null) {
            return dBPool;
        }
        RegistryNode registryNode = DBPool.getPoolConfig(string);
        if (registryNode == null) {
            throw new SQLException("no such database pool `" + string + "'");
        }
        String string2 = string;
        if (registryNode != null) {
            string2 = registryNode.getString("url", null);
        }
        String string3 = null;
        if (registryNode != null) {
            string3 = registryNode.getString("driver", null);
        }
        String string4 = registryNode.getString(PROPERTY_USER_NAME, null);
        String string5 = registryNode.getString(PROPERTY_PASSWORD, null);
        int n = registryNode.getInt("max-connections", 20);
        dBPool = new DBPool(string, string2, string4, string5, string3, classLoader, n);
        pools.put(string, dBPool);
        return dBPool;
    }

    private static RegistryNode getPoolConfig(String string) {
        RegistryNode registryNode = Registry.lookup("/caucho.com");
        if (registryNode == null) {
            return null;
        }
        RegistryNode registryNode2 = null;
        Iterator iterator = registryNode.iterator();
        while (iterator.hasNext()) {
            RegistryNode registryNode3 = (RegistryNode)iterator.next();
            String string2 = registryNode3.getValue();
            if (!registryNode3.getName().equals("dbpool.sql")) continue;
            if (string == null && (string2 == null || string2.equals(""))) {
                return registryNode3;
            }
            if (string2 == null) {
                registryNode2 = registryNode3;
                continue;
            }
            if (!string.equals(string2)) continue;
            return registryNode3;
        }
        return registryNode2;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public String getURL() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getTotalConnections() {
        return this.nConnections;
    }

    public int getActiveConnections() {
        return this.activeConnections;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (string != null && !string.equals(this.user)) {
            return this.createConnection(string, string2);
        }
        if (string2 != null && !string2.equals(this.password)) {
            return this.createConnection(string, string2);
        }
        return this.getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection getConnection() throws SQLException {
        ArrayList arrayList;
        Object object;
        QPooledConnection qPooledConnection = null;
        boolean bl = false;
        while (true) {
            object = this.connections;
            synchronized (object) {
                block19: {
                    while (true) {
                        if (this.connections.size() <= 0) {
                            if (this.nConnections < this.maxConnections) {
                                ++this.nConnections;
                                ++this.activeConnections;
                                break;
                            }
                            break block19;
                        }
                        qPooledConnection = (QPooledConnection)this.connections.get(this.connections.size() - 1);
                        this.connections.remove(this.connections.size() - 1);
                        try {
                            if (!qPooledConnection.getConnection().isClosed()) {
                                if (dbg.canWrite()) {
                                    dbg.log("reuse connection (" + this.nConnections + ") " + qPooledConnection);
                                }
                                ++this.activeConnections;
                                return qPooledConnection;
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        --this.nConnections;
                        qPooledConnection.kill();
                    }
                    arrayList = null;
                    break;
                }
                try {
                    this.connections.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new SQLException("interrupt: " + interruptedException);
                }
            }
        }
        if (dbg.canWrite()) {
            dbg.log("new connection [" + this.nConnections + "] url=" + this.url + " user=" + this.user);
        }
        try {
            object = this.createConnection(this.user, this.password);
            return new QPooledConnection(this, (Connection)object);
        }
        catch (SQLException sQLException) {
            arrayList = this.connections;
            synchronized (arrayList) {
                --this.nConnections;
                --this.activeConnections;
                throw sQLException;
            }
        }
    }

    private Connection createConnection(String string, String string2) throws SQLException {
        Connection connection;
        if (this.isClosed) {
            throw new SQLException("can't create connection from closed pool");
        }
        if (this.driver != null) {
            Properties properties = new Properties();
            if (string != null) {
                ((Hashtable)properties).put(PROPERTY_USER_NAME, string);
            } else {
                ((Hashtable)properties).put(PROPERTY_USER_NAME, "");
            }
            if (string2 != null) {
                ((Hashtable)properties).put(PROPERTY_PASSWORD, string2);
            } else {
                ((Hashtable)properties).put(PROPERTY_PASSWORD, "");
            }
            connection = this.driver.connect(this.url, properties);
        } else {
            connection = DriverManager.getConnection(this.url, string, string2);
        }
        if (connection == null) {
            throw new SQLException("can't create connection for `" + this.url + "'");
        }
        return connection;
    }

    public void setLoginTimeout(int n) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    void freeConnection(Connection connection) {
        boolean bl = false;
        if (connection == null) {
            return;
        }
        if (this.isClosed) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (connection.isClosed()) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            try {
                connection.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
        }
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            --this.activeConnections;
            if (bl) {
                --this.nConnections;
                Object var4_7 = null;
                return;
            }
        }
        if (dbg.canWrite()) {
            dbg.log("free connection (" + this.nConnections + ") " + connection);
        }
        QPooledConnection qPooledConnection = new QPooledConnection(this, connection);
        qPooledConnection.setPoolWaitTime(Alarm.getCurrentTime());
        arrayList = this.connections;
        synchronized (arrayList) {
            if (this.connections.size() == 0) {
                this.connections.notifyAll();
            }
            this.connections.add(qPooledConnection);
        }
    }

    private static void closePools() {
        Enumeration enumeration = pools.elements();
        pools = new Hashtable();
        while (enumeration.hasMoreElements()) {
            DBPool dBPool = (DBPool)enumeration.nextElement();
            if (dBPool.driver == null || dBPool.driver.getClass().getClassLoader() == null) {
                pools.put(dBPool.poolName, dBPool);
                continue;
            }
            dBPool.close();
        }
    }

    public void handleAlarm(Alarm alarm) {
        QPooledConnection qPooledConnection;
        int n;
        if (this.isClosed) {
            return;
        }
        long l = Alarm.getCurrentTime();
        ArrayList<QPooledConnection> arrayList = null;
        ArrayList arrayList2 = this.connections;
        synchronized (arrayList2) {
            n = 0;
            while (n < this.connections.size()) {
                qPooledConnection = (QPooledConnection)this.connections.get(n);
                try {
                    if (qPooledConnection.getPoolWaitTime() + 5000L < l || qPooledConnection.getConnection().isClosed()) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<QPooledConnection>();
                        }
                        --this.nConnections;
                        ((AbstractCollection)this.connections).remove(qPooledConnection);
                        arrayList.add(qPooledConnection);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++n;
            }
        }
        n = 0;
        while (arrayList != null && n < arrayList.size()) {
            qPooledConnection = (QPooledConnection)arrayList.get(n);
            if (dbg.canWrite()) {
                dbg.log("closing connection (" + this.nConnections + "): " + qPooledConnection.getConnection());
            }
            qPooledConnection.kill();
            ++n;
        }
        alarm.queue(5000L);
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        ArrayList arrayList = this.connections;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.connections.size()) {
                QPooledConnection qPooledConnection = (QPooledConnection)this.connections.get(n);
                try {
                    qPooledConnection.getConnection().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            this.connections.clear();
        }
    }

    private DBPool() {
    }

    public DBPool(String string, String string2, String string3, String string4, String string5, ClassLoader classLoader, int n) throws SQLException {
        this.poolName = string;
        this.driverName = string5;
        try {
            if (string5 != null && classLoader != null) {
                this.driver = (Driver)classLoader.loadClass(string5).newInstance();
            } else if (string5 != null) {
                this.driver = (Driver)Class.forName(string5).newInstance();
            }
        }
        catch (Exception exception) {
            throw new SQLException("Can't load driver: `" + string5 + "'");
        }
        if (this.driver == null) {
            throw new SQLException("DBPool has no driver");
        }
        this.url = string2.intern();
        this.user = string3 == null ? "" : string3.intern();
        String string6 = this.password = string4 == null ? "" : string4.intern();
        if (n == 0) {
            n = 1;
        }
        this.maxConnections = n;
        new Alarm("db-pool", this, 5000L);
    }

    static {
        try {
            DriverManager.registerDriver(new DBPool());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
        }
    }
}

