/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.DynamicClassLoader;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;

public class DirectoryClassLoader
extends DynamicClassLoader {
    private static WriteStream dbg = LogStream.open("/caucho.com/util/loader");
    private Path dir;
    private long lastModified;
    private ArrayList jarList;

    public static DirectoryClassLoader create(ClassLoader classLoader, Path path) {
        DirectoryClassLoader directoryClassLoader;
        try {
            directoryClassLoader = new DirectoryClassLoader(classLoader);
        }
        catch (Error error) {
            directoryClassLoader = new DirectoryClassLoader();
            directoryClassLoader.setParent(classLoader);
        }
        directoryClassLoader.dir = path;
        directoryClassLoader.lastModified = path.getLastModified();
        directoryClassLoader.jarList = new ArrayList();
        directoryClassLoader.fillJars();
        return directoryClassLoader;
    }

    public synchronized boolean isModified() {
        if (this.dir.getLastModified() > this.lastModified) {
            return true;
        }
        return super.isModified();
    }

    private void fillJars() {
        this.jarList.clear();
        String[] stringArray = null;
        try {
            stringArray = this.dir.list();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            if (stringArray[n].endsWith(".jar") || stringArray[n].endsWith(".zip")) {
                Path path = this.dir.lookup(stringArray[n]);
                this.jarList.add(new JarPath(path));
            }
            ++n;
        }
    }

    protected String fillClassPath() {
        CharBuffer charBuffer = new CharBuffer();
        int n = 0;
        while (n < this.jarList.size()) {
            JarPath jarPath = (JarPath)this.jarList.get(n);
            charBuffer.append(jarPath.getContainer().getNativePath());
            charBuffer.append(CauchoSystem.getPathSeparatorChar());
            ++n;
        }
        charBuffer.append(super.fillClassPath());
        if (dbg.canWrite()) {
            dbg.log("classpath: " + charBuffer.toString());
        }
        return charBuffer.toString();
    }

    protected Path getPath(String string) {
        int n = 0;
        while (n < this.jarList.size()) {
            Path path = (Path)this.jarList.get(n);
            Path path2 = path.lookup(string);
            if (path2.canRead()) {
                return path2;
            }
            ++n;
        }
        return null;
    }

    protected DirectoryClassLoader() {
    }

    protected DirectoryClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }
}

