/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class DoubleArray {
    double[] data = new double[16];
    int size = 0;

    public void clear() {
        this.size = 0;
    }

    private void expand(int n) {
        while (n > this.data.length) {
            double[] dArray = new double[this.data.length * 2];
            int n2 = 0;
            while (n2 < this.data.length) {
                dArray[n2] = this.data[n2];
                ++n2;
            }
            this.data = dArray;
        }
    }

    public int size() {
        return this.size;
    }

    public void append(double d) {
        this.expand(this.size + 1);
        this.data[this.size++] = d;
    }

    public void append(DoubleArray doubleArray) {
        this.expand(this.size + doubleArray.size);
        int n = 0;
        while (n < doubleArray.size) {
            this.data[this.size++] = doubleArray.data[n];
            ++n;
        }
    }

    public void insert(int n, double d) {
        this.expand(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = d;
        ++this.size;
    }

    public double pop() {
        return this.data[--this.size];
    }

    public void setLength(int n) {
        this.expand(n);
        int n2 = this.size;
        while (n2 < n) {
            this.data[n2] = 0.0;
            ++n2;
        }
        this.size = n;
    }

    public double get(int n) {
        return this.data[n];
    }

    public double last() {
        return this.data[this.size - 1];
    }

    public void set(int n, double d) {
        if (n + 1 > this.size) {
            this.setLength(n + 1);
        }
        this.data[n] = d;
    }

    public boolean contains(double d) {
        int n = 0;
        while (n < this.size) {
            if (this.data[n] == d) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isSubset(DoubleArray doubleArray) {
        int n = 0;
        while (n < doubleArray.size) {
            if (!this.contains(doubleArray.data[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void union(DoubleArray doubleArray) {
        int n = 0;
        while (n < doubleArray.size) {
            if (!this.contains(doubleArray.data[n])) {
                this.append(doubleArray.data[n]);
            }
            ++n;
        }
    }
}

