/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.ChangeListener;
import com.caucho.util.QDate;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.LooseXml;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class Registry {
    private static RegistryNode defaultRegistry;
    private static ArrayList listeners;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegistryNode parse(Path path) throws IOException {
        RegistryNode registryNode;
        ReadStream readStream = null;
        try {
            readStream = path.openRead();
            registryNode = Registry.parse(readStream);
            Object var3_3 = null;
            if (readStream == null) return registryNode;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (readStream == null) throw throwable;
            readStream.close();
            throw throwable;
        }
        readStream.close();
        return registryNode;
    }

    public static RegistryNode parse(ReadStream readStream) throws IOException {
        LooseXml looseXml = new LooseXml();
        RegistryNode registryNode = new RegistryNode(null, null, null, null, 0);
        SaxHandler saxHandler = new SaxHandler(readStream.getPath(), registryNode);
        looseXml.setDocumentHandler(saxHandler);
        looseXml.parse(readStream);
        return registryNode;
    }

    public static synchronized RegistryNode setDefault(RegistryNode registryNode) {
        return Registry.setRegistry(registryNode);
    }

    public static synchronized RegistryNode setRegistry(RegistryNode registryNode) {
        RegistryNode registryNode2 = defaultRegistry;
        defaultRegistry = registryNode;
        if (registryNode2 != null) {
            registryNode2.isModified = true;
        }
        Registry.handleChange();
        return registryNode2;
    }

    public static synchronized RegistryNode getRegistry() {
        return defaultRegistry;
    }

    public static RegistryNode lookup(String string) {
        RegistryNode registryNode = Registry.getRegistry();
        return registryNode == null ? null : registryNode.lookup(string);
    }

    public static boolean getBoolean(String string, boolean bl) {
        RegistryNode registryNode = Registry.lookup(string);
        return registryNode == null ? bl : registryNode.getBoolean();
    }

    public static int getInt(String string, int n) {
        RegistryNode registryNode = Registry.lookup(string);
        return registryNode == null ? n : registryNode.getInt();
    }

    public static double getDouble(String string, double d) {
        RegistryNode registryNode = Registry.lookup(string);
        return registryNode == null ? d : registryNode.getDouble();
    }

    public static String getString(String string, String string2) {
        RegistryNode registryNode = Registry.lookup(string);
        return registryNode == null ? string2 : registryNode.getString();
    }

    public static QDate getDate(String string, QDate qDate) {
        RegistryNode registryNode = Registry.lookup(string);
        return registryNode == null ? qDate : registryNode.getDate();
    }

    public static long getPeriod(String string, long l) {
        RegistryNode registryNode = Registry.lookup(string);
        return registryNode == null ? l : registryNode.getPeriod();
    }

    public static synchronized void addListener(ChangeListener changeListener) {
        if (listeners == null) {
            listeners = new ArrayList();
        }
        listeners.add(changeListener);
    }

    public static synchronized void removeListener(ChangeListener changeListener) {
        if (listeners != null) {
            ((AbstractCollection)listeners).remove(changeListener);
        }
    }

    static void handleChange() {
        if (listeners == null) {
            return;
        }
        int n = 0;
        while (n < listeners.size()) {
            ChangeListener changeListener = (ChangeListener)listeners.get(n);
            changeListener.handleChange(null);
            ++n;
        }
    }

    private Registry() {
    }

    static class SaxHandler
    extends HandlerBase {
        Path path;
        private Locator locator;
        ArrayList elements = new ArrayList();
        RegistryNode node;

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            RegistryNode registryNode;
            if (string.equals("resin:include")) {
                this.doInclude(attributeList);
                return;
            }
            this.node = registryNode = this.node.add(string, null, this.locator.getSystemId(), this.locator.getLineNumber());
            int n = attributeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string2 = attributeList.getName(n2);
                String string3 = attributeList.getValue(n2);
                if (string2.equals("id")) {
                    registryNode.value = string3;
                } else {
                    registryNode.add(string2, string3, this.locator.getSystemId(), this.locator.getLineNumber());
                }
                ++n2;
            }
        }

        private void doInclude(AttributeList attributeList) throws SAXException {
            try {
                String string = attributeList.getValue("href");
                if (string == null) {
                    throw new SAXException("resin:include expects `href' attribute");
                }
                Path path = this.path.getParent().lookup(string);
                RegistryNode registryNode = Registry.parse(path);
                if (registryNode == null || registryNode.getFirstChild() == null) {
                    this.node = this.node.add("resin:include", null, null, 0);
                    return;
                }
                Iterator iterator = registryNode.iterator();
                while (iterator.hasNext()) {
                    this.node.add((RegistryNode)iterator.next());
                }
                this.node = registryNode.getFirstChild();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException.toString());
            }
        }

        public void endElement(String string) {
            if (this.node != null) {
                this.node = this.node.parent;
            }
        }

        private boolean isWhitespace(char c) {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            char c;
            while (n2 > 0) {
                c = cArray[n];
                if (c != ' ' && c != '\t' && c != '\n' && c != '\r') break;
                ++n;
                --n2;
            }
            while (n2 > 0) {
                c = cArray[n + n2 - 1];
                if (c != ' ' && c != '\t' && c != '\n' && c != '\r') break;
                --n2;
            }
            if (n2 <= 0) {
                return;
            }
            if (this.node.value != null) {
                throw new SAXException("Can't use both id=value and text values");
            }
            if (this.node.value == null) {
                this.node.value = new String(cArray, n, n2);
            }
        }

        SaxHandler(Path path, RegistryNode registryNode) {
            this.path = path;
            this.node = registryNode;
        }
    }
}

