/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.HttpPath;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;

class HttpStream
extends StreamImpl {
    private static HashMap reserved = new HashMap();
    private Socket s;
    private InputStream is;
    private OutputStream os;
    private ReadStream rs;
    private WriteStream ws;
    private MemoryStream tempStream;
    private boolean didGet;
    private boolean canWrite;
    private HashMap attributes;

    static HttpStream openRead(HttpPath httpPath) throws IOException {
        Socket socket = new Socket(httpPath.getHost(), httpPath.getPort());
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        return new HttpStream(httpPath, socket, inputStream, outputStream, false);
    }

    static HttpStream openReadWrite(HttpPath httpPath) throws IOException {
        Socket socket = new Socket(httpPath.getHost(), httpPath.getPort());
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        return new HttpStream(httpPath, socket, inputStream, outputStream, true);
    }

    public Object getAttribute(String string) throws IOException {
        if (!this.didGet) {
            this.getConnInput();
        }
        return this.attributes.get(string.toLowerCase());
    }

    public Iterator getAttributeNames() throws IOException {
        if (!this.didGet) {
            this.getConnInput();
        }
        return this.attributes.keySet().iterator();
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string.toLowerCase(), object);
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string.toLowerCase());
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!this.canWrite) {
            return;
        }
        if (this.tempStream == null) {
            this.tempStream = new MemoryStream();
        }
        this.tempStream.write(byArray, n, n2);
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.didGet) {
            this.getConnInput();
        }
        int n3 = this.rs.read(byArray, n, n2);
        return n3;
    }

    private void getConnInput() throws IOException {
        if (this.didGet) {
            return;
        }
        this.didGet = true;
        if (this.canWrite) {
            this.ws.print("POST ");
        } else {
            this.ws.print("GET ");
        }
        this.ws.print(this.path.getPath());
        if (this.path.getQuery() != null) {
            this.ws.print("?");
            this.ws.print(this.path.getQuery());
        }
        this.ws.print(" HTTP/1.0\r\n");
        this.ws.print("Host: ");
        this.ws.print(this.path.getHost());
        if (this.path.getPort() != 80) {
            this.ws.print(":");
            this.ws.print(String.valueOf(this.path.getPort()));
        }
        this.ws.print("\r\n");
        Object object = this.getAttribute("User-Agent");
        if (object == null) {
            this.ws.print("User-Agent: Mozilla/4.0 (compatible; Resin 1.0; JDK)\r\n");
        } else {
            this.ws.print("User-Agent: " + object + "\r\n");
        }
        Iterator iterator = this.getAttributeNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (reserved.get(string.toLowerCase()) != null) continue;
            this.ws.print(string + ": " + this.getAttribute(string) + "\r\n");
        }
        this.ws.print("Connection: close\r\n");
        if (this.canWrite) {
            int n = 0;
            if (this.tempStream != null) {
                n += this.tempStream.getLength();
            }
            this.ws.print("Content-Length: ");
            this.ws.print(n);
            this.ws.print("\r\n");
        }
        this.ws.print("\r\n");
        if (this.canWrite && this.tempStream != null) {
            this.tempStream.writeToStream(this.ws);
            this.tempStream.destroy();
        }
        this.parseHeaders();
    }

    private void parseHeaders() throws IOException {
        CharBuffer charBuffer = new CharBuffer();
        if (!this.rs.readln(charBuffer) || charBuffer.length() == 0) {
            return;
        }
        int n = 0;
        n = 0;
        while (n < charBuffer.length() && charBuffer.charAt(n) != ' ') {
            ++n;
        }
        while (n < charBuffer.length() && charBuffer.charAt(n) == ' ') {
            ++n;
        }
        int n2 = 0;
        while (n < charBuffer.length()) {
            char c = charBuffer.charAt(n);
            if (c < '0' || c > '9') break;
            n2 = 10 * n2 + c - 48;
            ++n;
        }
        this.attributes.put("status", String.valueOf(n2));
        CharBuffer charBuffer2 = new CharBuffer();
        CharBuffer charBuffer3 = new CharBuffer();
        while (true) {
            charBuffer.clear();
            if (!this.rs.readln(charBuffer) || charBuffer.length() == 0) break;
            n = 0;
            while (n < charBuffer.length() && Character.isWhitespace(charBuffer.charAt(n))) {
                ++n;
            }
            charBuffer2.clear();
            while (n < charBuffer.length() && !Character.isWhitespace(charBuffer.charAt(n)) && charBuffer.charAt(n) != ':') {
                charBuffer2.append(charBuffer.charAt(n));
                ++n;
            }
            while (n < charBuffer.length() && Character.isWhitespace(charBuffer.charAt(n))) {
                ++n;
            }
            if (charBuffer2.length() == 0 || n >= charBuffer.length() || charBuffer.charAt(n) != ':') continue;
            ++n;
            while (n < charBuffer.length() && Character.isWhitespace(charBuffer.charAt(n))) {
                ++n;
            }
            this.attributes.put(charBuffer2.toLowerCase().toString(), charBuffer.substring(n));
        }
    }

    public int getAvailable() throws IOException {
        if (!this.didGet) {
            this.getConnInput();
        }
        return this.rs.getAvailable();
    }

    public void close() throws IOException {
        block7: {
            try {
                if (this.ws != null) {
                    this.ws.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
                if (this.os != null) {
                    this.os.close();
                }
                if (this.is == null) break block7;
                this.is.close();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.s != null) {
                    this.s.close();
                }
                throw throwable;
            }
        }
        Object var2_1 = null;
        if (this.s != null) {
            this.s.close();
        }
    }

    private HttpStream(Path path, Socket socket, InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.setPath(path);
        this.s = socket;
        this.is = inputStream;
        this.os = outputStream;
        this.tempStream = this.tempStream;
        this.canWrite = bl;
        this.ws = VfsStream.openWrite(outputStream);
        this.rs = VfsStream.openRead(inputStream, this.ws);
        this.attributes = new HashMap();
    }

    static {
        reserved.put("user-agent", "");
        reserved.put("content-length", "");
        reserved.put("content-encoding", "");
        reserved.put("connection", "");
        reserved.put("host", "");
    }
}

