/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.LruCache;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class Jar {
    private static LruCache jarCache = new LruCache(256);
    private Path backing;
    private long lastModified;
    private long lastTime;
    private HashMap entries;

    static Jar create(Path path) {
        LruCache lruCache = jarCache;
        synchronized (lruCache) {
            Jar jar = (Jar)jarCache.get(path);
            if (jar == null) {
                jar = new Jar(path);
                jarCache.put(path, jar);
            }
            Jar jar2 = jar;
            Object var2_4 = null;
            return jar2;
        }
    }

    Path getBacking() {
        return this.backing;
    }

    public boolean exists(String string) {
        Entry entry = this.getSafeJarEntry(string);
        return entry != null;
    }

    public boolean isDirectory(String string) {
        Entry entry = this.getSafeJarEntry(string);
        return entry != null && entry.isDirectory();
    }

    public boolean isFile(String string) {
        Entry entry = this.getSafeJarEntry(string);
        return entry != null && entry.isFile();
    }

    public long getLength(Path path) {
        Entry entry = this.getSafeJarEntry(path.getPath());
        if (entry == null) {
            return -1L;
        }
        if (entry.getLength() >= 0L) {
            return entry.getLength();
        }
        try {
            long l;
            ReadStream readStream = new ReadStream(this.openReadImpl(path));
            long l2 = 0L;
            while ((l = readStream.skip(65536L)) == 65536L) {
                l2 += l;
            }
            entry.length = (int)(l2 + l);
            readStream.close();
        }
        catch (IOException iOException) {
            entry.length = 0L;
        }
        return entry.getLength();
    }

    public long getLastModified(String string) {
        long l = Alarm.getCurrentTime();
        if (l != this.lastTime) {
            this.lastTime = l;
            this.lastModified = this.backing.getLastModified();
        }
        return this.lastModified;
    }

    public boolean canRead(String string) {
        return this.backing.canRead() && this.isFile(string);
    }

    public boolean canWrite(String string) {
        return false;
    }

    public String[] list(String string) throws IOException {
        return new String[0];
    }

    public StreamImpl openReadImpl(Path path) throws IOException {
        ZipEntry zipEntry;
        String string = path.getPath();
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        ReadStream readStream = this.backing.openRead();
        ZipInputStream zipInputStream = new ZipInputStream(readStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(string)) continue;
            return new ZipStreamImpl(zipInputStream, readStream, path);
        }
        zipInputStream.close();
        ((InputStream)readStream).close();
        throw new FileNotFoundException(path.toString());
    }

    public String toString() {
        return this.backing.toString();
    }

    private Entry getSafeJarEntry(String string) {
        try {
            return this.getJarEntry(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Entry getJarEntry(String string) throws IOException {
        Jar jar = this;
        synchronized (jar) {
            ZipEntry zipEntry;
            if (this.lastModified == this.getLastModified(null) && this.entries != null) {
                Entry entry = (Entry)this.entries.get(string);
                Object var3_5 = null;
                return entry;
            }
            ReadStream readStream = this.backing.openRead();
            ZipInputStream zipInputStream = new ZipInputStream(readStream);
            if (this.entries == null) {
                this.entries = new HashMap();
            } else {
                this.entries.clear();
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                Entry entry = new Entry(string2, zipEntry.isDirectory(), zipEntry.getSize());
                this.entries.put("/" + string2, entry);
            }
            zipInputStream.close();
            ((InputStream)readStream).close();
            Entry entry = (Entry)this.entries.get(string);
            Object var3_6 = null;
            return entry;
        }
    }

    Jar(Path path) {
        this.backing = path;
    }

    static class Entry {
        String path;
        boolean isDirectory;
        long length;

        boolean isFile() {
            return !this.isDirectory;
        }

        boolean isDirectory() {
            return this.isDirectory;
        }

        long getLength() {
            return this.length;
        }

        Entry(String string, boolean bl, long l) {
            this.path = string;
            this.isDirectory = bl;
            this.length = l;
        }
    }

    static class ZipStreamImpl
    extends StreamImpl {
        private ZipInputStream zis;
        private InputStream is;
        private Path path;

        public Path getPath() {
            return this.path;
        }

        public boolean canRead() {
            return true;
        }

        public int getAvailable() throws IOException {
            if (this.zis == null) {
                return -1;
            }
            return this.zis.available();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.zis.read(byArray, n, n2);
            return n3;
        }

        public void close() throws IOException {
            this.is.close();
            this.zis.close();
        }

        ZipStreamImpl(ZipInputStream zipInputStream, InputStream inputStream, Path path) {
            this.zis = zipInputStream;
            this.is = inputStream;
            this.path = path;
        }
    }
}

