/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Jar;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.Map;

public class JarPath
extends FilesystemPath {
    private Jar jarFile;

    protected Path fsWalk(String string, Map map, String string2) {
        return new JarPath(this.root, string, string2, this.jarFile);
    }

    public String getScheme() {
        return "jar";
    }

    public Path getContainer() {
        return this.jarFile.getBacking();
    }

    public boolean exists() {
        return this.jarFile.exists(this.getPath());
    }

    public boolean isDirectory() {
        return this.jarFile.isDirectory(this.getPath());
    }

    public boolean isFile() {
        return this.jarFile.isFile(this.getPath());
    }

    public long getLength() {
        return this.jarFile.getLength(this);
    }

    public long getLastModified() {
        return this.jarFile.getLastModified(this.getPath());
    }

    public boolean canRead() {
        return this.jarFile.canRead(this.getPath());
    }

    public boolean canWrite() {
        return this.jarFile.canWrite(this.getPath());
    }

    public String[] list() throws IOException {
        return this.jarFile.list(this.getPath());
    }

    public StreamImpl openReadImpl() throws IOException {
        return this.jarFile.openReadImpl(this);
    }

    public String toString() {
        return "jar:(" + this.jarFile + ")" + this.getPath();
    }

    public int hashCode() {
        return 65531 * super.hashCode() + this.jarFile.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JarPath)) {
            return false;
        }
        JarPath jarPath = (JarPath)object;
        return this.jarFile.equals(jarPath.jarFile) && super.equals(object);
    }

    protected JarPath(FilesystemPath filesystemPath, String string, String string2, Jar jar) {
        super(filesystemPath, string, string2);
        this.jarFile = jar;
    }

    public JarPath(Path path) {
        this(null, "/", "/", Jar.create(path));
        this.root = this;
    }
}

