/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.Path;
import com.caucho.vfs.SmtpStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MailtoPath
extends Path {
    protected String url;
    private ArrayList to;
    private ArrayList cc;
    private ArrayList bcc;
    private HashMap attributes;

    protected Path schemeWalk(String string, Map map, String string2, int n) {
        StringCharCursor stringCharCursor = new StringCharCursor(string2, n);
        ArrayList arrayList = MailtoPath.parseAddressList(stringCharCursor);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        CharBuffer charBuffer = new CharBuffer();
        if (stringCharCursor.current() == '?') {
            char c = stringCharCursor.next();
            while (MailtoPath.isUserChar(c)) {
                charBuffer.clear();
                while (MailtoPath.isUserChar(c)) {
                    charBuffer.append(c);
                    c = stringCharCursor.next();
                }
                String string3 = charBuffer.toString();
                if (c != '=') {
                    throw new RuntimeException("broken attribute at: " + c);
                }
                charBuffer.clear();
                c = stringCharCursor.next();
                while (c != '\uffff' && c != '&') {
                    charBuffer.append(c);
                    c = stringCharCursor.next();
                }
                hashMap.put(string3, charBuffer.toString());
                while (c == '&' || c == ' ' || c == '\t') {
                    c = stringCharCursor.next();
                }
            }
        }
        return new MailtoPath(this, string, arrayList, hashMap);
    }

    static ArrayList parseAddressList(StringCharCursor stringCharCursor) {
        ArrayList<Recipient> arrayList = new ArrayList<Recipient>();
        char c = stringCharCursor.current();
        CharBuffer charBuffer = new CharBuffer();
        while (Character.isWhitespace(c)) {
            c = stringCharCursor.next();
        }
        while (MailtoPath.isUserChar(c)) {
            charBuffer.clear();
            while (MailtoPath.isUserChar(c)) {
                charBuffer.append(c);
                c = stringCharCursor.next();
            }
            Recipient recipient = new Recipient();
            arrayList.add(recipient);
            recipient.user = charBuffer.toString();
            if (c == '@') {
                c = stringCharCursor.next();
                if (!MailtoPath.isUserChar(c)) {
                    throw new RuntimeException("bad url");
                }
                charBuffer.clear();
                while (MailtoPath.isUserChar(c)) {
                    charBuffer.append(c);
                    c = stringCharCursor.next();
                }
                recipient.host = charBuffer.toString();
            }
            while (c == ',' || c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                c = stringCharCursor.next();
            }
        }
        return arrayList;
    }

    private static boolean isUserChar(int n) {
        switch (n) {
            case 33: 
            case 36: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 94: 
            case 95: 
            case 126: {
                return true;
            }
        }
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57;
    }

    public String getURL() {
        return this.getPath();
    }

    public String getScheme() {
        return "mailto";
    }

    public String getPath() {
        return "mailto:" + this.url;
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, String.valueOf(object));
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public StreamImpl openWriteImpl() throws IOException {
        return new SmtpStream(this.to, this.attributes);
    }

    MailtoPath(MailtoPath mailtoPath, String string, ArrayList arrayList, HashMap hashMap) {
        super(mailtoPath);
        this.url = string;
        this.to = arrayList;
        this.attributes = hashMap;
    }

    static class Recipient {
        String user;
        String host;

        Recipient() {
        }
    }
}

