/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import java.io.IOException;
import java.io.OutputStream;

public class MemoryStream
extends StreamImpl {
    private TempBuffer head;
    private TempBuffer tail;

    public Path getPath() {
        return new NullPath("temp:");
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n < n2) {
            int n3;
            if (this.tail == null || this.tail.length >= this.tail.buf.length) {
                this.addBuffer(TempBuffer.allocate());
            }
            if (n2 < (n3 = this.tail.buf.length - this.tail.length)) {
                n3 = n2;
            }
            System.arraycopy(byArray, n, this.tail.buf, this.tail.length, n3);
            n += n3;
            this.tail.length += n3;
        }
    }

    private void addBuffer(TempBuffer tempBuffer) {
        tempBuffer.next = null;
        tempBuffer.length = 0;
        if (this.tail != null) {
            this.tail.next = tempBuffer;
            this.tail = tempBuffer;
        } else {
            this.tail = tempBuffer;
            this.head = tempBuffer;
        }
        ++this.head.bufferCount;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        TempBuffer tempBuffer = this.head;
        while (tempBuffer != null) {
            outputStream.write(tempBuffer.buf, 0, tempBuffer.length);
            tempBuffer = tempBuffer.next;
        }
    }

    public int getLength() {
        if (this.tail == null) {
            return 0;
        }
        return this.tail.length;
    }

    public ReadStream openRead() throws IOException {
        this.close();
        TempReadStream tempReadStream = new TempReadStream(this.head, this.getPath());
        return new ReadStream(tempReadStream);
    }

    public void destroy() {
        while (this.head != null) {
            TempBuffer tempBuffer = this.head.next;
            TempBuffer.free(this.head);
            this.head = tempBuffer;
        }
        this.head = null;
        this.tail = null;
    }
}

