/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.NullPath;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InterruptedIOException;

public class PipeStream
extends StreamImpl {
    private PipeStream sibling;
    private byte[] readBuffer;
    private int readOffset;
    private int readLength;

    public static Object[] create() {
        PipeStream pipeStream;
        PipeStream pipeStream2 = new PipeStream();
        pipeStream2.sibling = pipeStream = new PipeStream();
        pipeStream.sibling = pipeStream2;
        return new Object[]{new ReadStream(pipeStream2, null), new WriteStream(pipeStream)};
    }

    public boolean canRead() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.readBuffer == null) {
            return 0;
        }
        PipeStream pipeStream = this;
        synchronized (pipeStream) {
            try {
                int n3;
                if (this.readOffset >= this.readLength) {
                    if (this.sibling.readBuffer == null) {
                        return 0;
                    }
                    this.notifyAll();
                    this.wait();
                }
                if ((n3 = this.readLength - this.readOffset) <= 0) {
                    return 0;
                }
                if (n2 < n3) {
                    n3 = n2;
                }
                System.arraycopy(this.readBuffer, this.readOffset, byArray, n, n3);
                this.readOffset += n3;
                return n3;
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        }
    }

    public int getAvailable() throws IOException {
        PipeStream pipeStream = this;
        synchronized (pipeStream) {
            int n = this.readLength - this.readOffset;
            Object var2_3 = null;
            return n;
        }
    }

    public boolean canWrite() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            PipeStream pipeStream = this.sibling;
            synchronized (pipeStream) {
                if (this.sibling.readBuffer == null) {
                    return;
                }
                if (this.sibling.readLength == this.sibling.readBuffer.length) {
                    if (this.sibling.readOffset < this.sibling.readLength) {
                        try {
                            this.sibling.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new InterruptedIOException(interruptedException.getMessage());
                        }
                    }
                    this.sibling.readOffset = 0;
                    this.sibling.readLength = 0;
                }
                if (this.sibling.readOffset == this.sibling.readLength) {
                    this.sibling.readOffset = 0;
                    this.sibling.readLength = 0;
                }
                if (this.sibling.readBuffer == null) {
                    return;
                }
                int n3 = this.sibling.readBuffer.length - this.sibling.readLength;
                if (n2 < n3) {
                    n3 = n2;
                }
                System.arraycopy(byArray, n, this.sibling.readBuffer, this.sibling.readLength, n3);
                this.sibling.readLength += n3;
                n2 -= n3;
                n += n3;
                this.sibling.notifyAll();
            }
        }
        return;
    }

    public void close() throws IOException {
        if (this.readBuffer == null) {
            return;
        }
        PipeStream pipeStream = this;
        synchronized (pipeStream) {
            this.readBuffer = null;
            this.readLength = 0;
            this.readOffset = 0;
            this.notifyAll();
        }
        pipeStream = this.sibling;
        synchronized (pipeStream) {
            this.sibling.notifyAll();
        }
    }

    private PipeStream() {
        this.setPath(new NullPath("pipe"));
        this.readBuffer = new byte[2 * TempBuffer.SIZE];
        this.readOffset = 0;
        this.readLength = 0;
    }
}

