/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class ReaderWriterStream
extends StreamImpl {
    private static NullPath nullPath;
    private Reader is;
    private Writer os;
    private boolean flushOnNewline;
    private boolean closeChildOnClose = true;
    private int peek1;
    private int peek2;

    public void init(Reader reader, Writer writer) {
        this.is = reader;
        this.os = writer;
        this.setPath(nullPath);
        this.peek1 = -1;
        this.peek2 = -1;
    }

    public boolean canRead() {
        return this.is != null;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.is == null) {
            return -1;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.peek1 >= 0) {
                byArray[n++] = (byte)this.peek1;
                this.peek1 = this.peek2;
                this.peek2 = -1;
            } else {
                int n4 = this.is.read();
                if (n4 < 0) {
                    return n3 == 0 ? -1 : n3;
                }
                if (n4 < 128) {
                    byArray[n++] = (byte)n4;
                } else if (n4 < 2048) {
                    byArray[n++] = (byte)(192 + (n4 >> 6));
                    this.peek1 = 128 + (n4 & 0x1F);
                } else {
                    byArray[n++] = (byte)(224 + (n4 >> 12));
                    this.peek1 = 128 + (n4 >> 6 & 0x1F);
                    this.peek2 = 128 + (n4 & 0x1F);
                }
            }
            ++n3;
        }
        return n2;
    }

    public boolean canWrite() {
        return this.os != null;
    }

    public boolean getFlushOnNewline() {
        return this.flushOnNewline;
    }

    public void setFlushOnNewline(boolean bl) {
        this.flushOnNewline = bl;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        while (n < n3) {
            int n4;
            int n5;
            if ((n5 = byArray[n++] & 0xFF) < 128) {
                this.os.write(n5);
                continue;
            }
            if ((n5 & 0xE0) == 192) {
                if (n >= n3) {
                    throw new EOFException("unexpected end of file in utf8 character");
                }
                if (((n4 = byArray[n++] & 0xFF) & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                this.os.write(((n5 & 0x1F) << 6) + (n4 & 0x3F));
                continue;
            }
            if ((n5 & 0xF0) == 224) {
                if (n + 1 >= n3) {
                    throw new EOFException("unexpected end of file in utf8 character");
                }
                n4 = byArray[n++] & 0xFF;
                int n6 = byArray[n++] & 0xFF;
                if ((n4 & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                if ((n6 & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                this.os.write(((n5 & 0x1F) << 12) + ((n4 & 0x3F) << 6) + (n6 & 0x3F));
                continue;
            }
            throw new CharConversionException("illegal utf8 encoding at (" + n5 + ")");
        }
    }

    public void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    public void setCloseChildOnClose(boolean bl) {
        this.closeChildOnClose = bl;
    }

    public void close() throws IOException {
        if (this.os != null && this.closeChildOnClose) {
            this.os.close();
            this.os = null;
        }
        if (this.is != null && this.closeChildOnClose) {
            this.is.close();
            this.is = null;
        }
    }

    public ReaderWriterStream(Reader reader, Writer writer) {
        this.init(reader, writer);
        if (nullPath == null) {
            nullPath = new NullPath("stream");
        }
        this.setPath(nullPath);
    }

    public ReaderWriterStream(Reader reader, Writer writer, Path path) {
        this.init(reader, writer);
        this.setPath(path);
    }
}

