/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VfsStream
extends StreamImpl {
    private static NullPath nullPath;
    private static byte[] unixNewline;
    private InputStream is;
    private OutputStream os;
    private boolean flushOnNewline;
    private boolean closeChildOnClose = true;
    private byte[] newline = unixNewline;

    public void setNewline(byte[] byArray) {
        this.newline = byArray;
    }

    public byte[] getNewline() {
        return this.newline;
    }

    public static ReadWritePair openReadWrite(InputStream inputStream, OutputStream outputStream) {
        VfsStream vfsStream = new VfsStream(inputStream, outputStream);
        WriteStream writeStream = new WriteStream(vfsStream);
        ReadStream readStream = new ReadStream(vfsStream, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public static ReadStream openRead(InputStream inputStream) {
        VfsStream vfsStream = new VfsStream(inputStream, null);
        return new ReadStream(vfsStream);
    }

    public static ReadStream openRead(InputStream inputStream, WriteStream writeStream) {
        VfsStream vfsStream = new VfsStream(inputStream, null);
        return new ReadStream(vfsStream, writeStream);
    }

    public static WriteStream openWrite(OutputStream outputStream) {
        VfsStream vfsStream = new VfsStream(null, outputStream);
        return new WriteStream(vfsStream);
    }

    public void init(InputStream inputStream, OutputStream outputStream) {
        this.is = inputStream;
        this.os = outputStream;
        this.setPath(nullPath);
    }

    public boolean canRead() {
        return this.is != null;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.is == null) {
            return -1;
        }
        return this.is.read(byArray, n, n2);
    }

    public int getAvailable() throws IOException {
        if (this.is == null) {
            return -1;
        }
        return this.is.available();
    }

    public boolean canWrite() {
        return this.os != null;
    }

    public boolean getFlushOnNewline() {
        return this.flushOnNewline;
    }

    public void setFlushOnNewline(boolean bl) {
        this.flushOnNewline = bl;
    }

    public void write(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        if (this.os != null) {
            this.os.write(byArray, n, n2);
        }
    }

    public void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    public void setCloseChildOnClose(boolean bl) {
        this.closeChildOnClose = bl;
    }

    public void close() throws IOException {
        if (this.os != null && this.closeChildOnClose) {
            this.os.close();
            this.os = null;
        }
        if (this.is != null && this.closeChildOnClose) {
            this.is.close();
            this.is = null;
        }
    }

    public VfsStream(InputStream inputStream, OutputStream outputStream) {
        this.init(inputStream, outputStream);
        if (nullPath == null) {
            nullPath = new NullPath("stream");
        }
        this.setPath(nullPath);
    }

    public VfsStream(InputStream inputStream, OutputStream outputStream, Path path) {
        this.init(inputStream, outputStream);
        this.setPath(path);
    }

    static {
        unixNewline = new byte[]{10};
    }
}

